/*
 * Decompiled with CFR 0.152.
 */
package com.munjaon.server.util;

import com.munjaon.server.util.StringUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/*
 * Exception performing whole class analysis ignored.
 */
public final class CommonUtil {
    public static final String DATE_FORMAT_14 = "yyyyMMddHHmmss";
    public static final int TIMEOUT_DIVIDE = 60000;

    public static String cutNewLine(String msg) {
        String encString = "";
        if (msg != null) {
            encString = msg.replaceAll("\r", "");
            encString = encString.replaceAll("\n", "");
        }
        return encString;
    }

    public static String encodeNewLine(String msg) {
        String encString = "";
        if (msg != null) {
            encString = msg.replaceAll("\r", "");
            encString = encString.replaceAll("\n", "\u24dd\u24db");
        }
        return encString;
    }

    public static String decodeNewLine(String msg) {
        String encString = "";
        if (msg != null) {
            encString = msg.replaceAll("\u24dd\u24db", "\n");
        }
        return encString;
    }

    public static String encodeComma(String msg) {
        String encString = "";
        if (msg != null) {
            encString = msg.replaceAll("\"", "\u24d2\u24de\u24dc\u24dc\u24d0");
        }
        return encString;
    }

    public static String decodeComma(String msg) {
        String decString = "";
        if (msg != null) {
            decString = msg.replaceAll("\u24d2\u24de\u24dc\u24dc\u24d0", "\"");
        }
        return decString;
    }

    public static boolean checkMsgNull(String msgStr) {
        boolean isValid = false;
        String[] msgArray = msgStr.split("\u24dc\u24e2");
        int msgArrayLen = msgArray.length;
        for (int i = 0; i < msgArrayLen; ++i) {
            msgArray[i] = msgArray[i].trim();
            if (msgArray[i].length() >= 1) continue;
            isValid = true;
            break;
        }
        return isValid;
    }

    public static String cutString(String str, int limit) {
        int len = str.length();
        int sumLength = 0;
        String cutString = null;
        byte[] toByte = str.getBytes();
        if (limit < 2) {
            return "";
        }
        if (toByte.length > limit) {
            for (int cnt = 0; cnt < len; ++cnt) {
                sumLength = (str.charAt(cnt) & 0xFF00) == 0 ? ++sumLength : (sumLength += 2);
                if (sumLength <= limit) continue;
                cutString = str.substring(0, cnt);
                break;
            }
        } else {
            cutString = str;
        }
        return cutString;
    }

    public static int substringDate(String inDate, int beginIndex, int lastIndex) {
        int subDate = -1;
        if ((inDate = CommonUtil.doNumber((String)inDate)).length() == 8 && beginIndex < lastIndex && lastIndex <= 8) {
            subDate = Integer.parseInt(inDate.substring(beginIndex, lastIndex));
        }
        return subDate;
    }

    public static int substringTime(String inTime, int beginIndex, int lastIndex) {
        int subDate = -1;
        if ((inTime = CommonUtil.doNumber((String)inTime)).length() == 6 && beginIndex < lastIndex && lastIndex <= 6) {
            subDate = Integer.parseInt(inTime.substring(beginIndex, lastIndex));
        }
        return subDate;
    }

    public static boolean validDate(String fullDate) {
        boolean validFlag = true;
        if ((fullDate = CommonUtil.doNumber((String)fullDate)).length() != 14) {
            validFlag = false;
        } else if (!CommonUtil.isValidDay((String)fullDate.substring(0, 8)) || !CommonUtil.isValidTime((String)fullDate.substring(8, 14))) {
            validFlag = false;
        }
        return validFlag;
    }

    public static boolean isValidDay(String inDate) {
        boolean validFlag = true;
        int year = CommonUtil.substringDate((String)inDate, (int)0, (int)4);
        if (year < 2013) {
            validFlag = false;
        }
        int month = CommonUtil.substringDate((String)inDate, (int)4, (int)6);
        int day = CommonUtil.substringDate((String)inDate, (int)6, (int)8);
        if (month < 1 || month > 12) {
            validFlag = false;
        }
        if (day < 1 || day > 31) {
            validFlag = false;
        }
        if ((month == 4 || month == 6 || month == 9 || month == 11) && day == 31) {
            validFlag = false;
        }
        if (month == 2) {
            boolean isleap;
            boolean bl = isleap = year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
            if (day > 29 || day == 29 && !isleap) {
                validFlag = false;
            }
        }
        return validFlag;
    }

    public static boolean isValidTime(String inTime) {
        boolean validFlag = true;
        int hour = CommonUtil.substringTime((String)inTime, (int)0, (int)2);
        int minute = CommonUtil.substringTime((String)inTime, (int)2, (int)4);
        int second = CommonUtil.substringTime((String)inTime, (int)4, (int)6);
        if (hour < 0 || hour > 23) {
            validFlag = false;
        }
        if (minute < 0 || minute > 59) {
            validFlag = false;
        }
        if (second < 0 || second > 59) {
            validFlag = false;
        }
        return validFlag;
    }

    public static boolean isBeforeDate(String srcDate, String destDate) {
        boolean validFlag = false;
        Calendar srcCal = CommonUtil.getCalendar((String)srcDate);
        Calendar destCal = CommonUtil.getCalendar((String)destDate);
        if (srcCal == null || destCal == null) {
            validFlag = true;
        } else if (srcCal.before(destCal)) {
            validFlag = true;
        }
        return validFlag;
    }

    public static Calendar getCalendar(int hour) {
        Calendar thisCal = null;
        thisCal.add(10, hour);
        return thisCal;
    }

    public static Calendar getCalendar(String inDate) {
        Calendar thisCal = null;
        if ((inDate = CommonUtil.doNumber((String)inDate)).length() == 14 && CommonUtil.validDate((String)inDate)) {
            String date = inDate.substring(0, 8);
            String time = inDate.substring(8, 14);
            int year = CommonUtil.substringDate((String)date, (int)0, (int)4);
            int month = CommonUtil.substringDate((String)date, (int)4, (int)6);
            int day = CommonUtil.substringDate((String)date, (int)6, (int)8);
            int hour = CommonUtil.substringTime((String)time, (int)0, (int)2);
            int minute = CommonUtil.substringTime((String)time, (int)2, (int)4);
            int second = CommonUtil.substringTime((String)time, (int)4, (int)6);
            thisCal = Calendar.getInstance();
            thisCal.set(year, month - 1, day, hour, minute, second);
        }
        return thisCal;
    }

    public static String currentTime() {
        Calendar currDate = Calendar.getInstance();
        SimpleDateFormat dateForm = new SimpleDateFormat("HHmmss");
        return dateForm.format(currDate.getTime());
    }

    public static String getLastDate(String year, String month, String day) {
        String dateStr = null;
        String lastDay = null;
        Calendar currDate = Calendar.getInstance();
        currDate.set(Integer.parseInt(year), Integer.parseInt(month) - 1, Integer.parseInt(day));
        lastDay = Integer.toString(currDate.getActualMaximum(5));
        dateStr = year + month + lastDay;
        return dateStr;
    }

    public static String currentDay() {
        Calendar currDate = Calendar.getInstance();
        SimpleDateFormat dateForm = new SimpleDateFormat("yyyyMMdd");
        return dateForm.format(currDate.getTime());
    }

    public static String currentDate() {
        Calendar currDate = Calendar.getInstance();
        SimpleDateFormat dateForm = new SimpleDateFormat("yyyyMMddHHmmss");
        return dateForm.format(currDate.getTime());
    }

    public static String currentLogDate() {
        Calendar currDate = Calendar.getInstance();
        SimpleDateFormat dateForm = new SimpleDateFormat("[yyyy-MM-dd][HH:mm:ss]");
        return dateForm.format(currDate.getTime());
    }

    public static String formatDate(String format) {
        Calendar currDate = Calendar.getInstance();
        SimpleDateFormat dateForm = new SimpleDateFormat(format);
        return dateForm.format(currDate.getTime());
    }

    public static String getTargetDate(int term) {
        Calendar currDate = Calendar.getInstance();
        currDate.add(10, term);
        SimpleDateFormat dateForm = new SimpleDateFormat("yyyyMMddHHmmss");
        return dateForm.format(currDate.getTime());
    }

    public static String getTargetDay(int term) {
        Calendar currDate = Calendar.getInstance();
        currDate.add(10, term);
        SimpleDateFormat dateForm = new SimpleDateFormat("yyyyMMdd");
        return dateForm.format(currDate.getTime());
    }

    public static Date parseDate14(String sDay) {
        Date date = null;
        if (sDay != null || sDay.length() == 14) {
            SimpleDateFormat dateForm = new SimpleDateFormat("yyyyMMddHHmmss");
            try {
                date = dateForm.parse(sDay);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return date;
    }

    public static int validTimeOut(String sDay) {
        int interval = 100000;
        Date fromDate = CommonUtil.parseDate14((String)sDay);
        Date toDate = CommonUtil.parseDate14((String)CommonUtil.currentDate());
        if (fromDate != null && toDate != null) {
            long duration = toDate.getTime() - fromDate.getTime();
            interval = (int)(duration / 60000L);
        }
        return interval;
    }

    public static String doNumber(String spell) {
        Object phoneNumber = "";
        if (spell == null) {
            return phoneNumber;
        }
        int spell_Length = (spell = spell.trim()).length();
        if (spell_Length < 1) {
            return phoneNumber;
        }
        for (int i = 0; i < spell_Length; ++i) {
            char eachChar = spell.charAt(i);
            if ('0' > eachChar || eachChar > '9') continue;
            phoneNumber = (String)phoneNumber + eachChar;
        }
        return phoneNumber;
    }

    public static String cutFloatNumber(String srcNum, int digit) {
        int index;
        String headNum = "";
        String tailNum = "";
        Object retNum = "";
        if (srcNum != null && !srcNum.trim().equals("") && (index = (srcNum = srcNum.trim()).indexOf(".")) > 0) {
            headNum = srcNum.substring(0, index);
            tailNum = srcNum.substring(index + 1, srcNum.length());
            if (tailNum.length() == 0) {
                tailNum = "0";
            }
            if (tailNum.length() > digit) {
                tailNum = tailNum.substring(0, digit);
            }
            retNum = headNum + "." + tailNum;
        }
        return retNum;
    }

    public static boolean CheckPhone(String src) {
        if (src == null || src.trim().length() < 10) {
            return false;
        }
        return src.startsWith("0");
    }

    public static String trim(String obj) {
        return StringUtil.trim((Object)obj);
    }

    public static void main(String[] args) {
        System.out.println(CommonUtil.isBeforeDate((String)"20131206121212", (String)"20131207121212"));
        System.out.println("\ud558\ub8e8\uc804 : " + CommonUtil.getTargetDay((int)-24));
        System.out.println(CommonUtil.currentLogDate());
        System.out.println("validTimeOut() : " + CommonUtil.validTimeOut((String)"20141209154558"));
    }
}

