/*
 * Decompiled with CFR 0.152.
 */
package com.munjaon.server.server.task;

import com.munjaon.server.cache.enums.CacheService;
import com.munjaon.server.cache.service.ReportService;
import com.munjaon.server.queue.pool.ReportQueue;
import com.munjaon.server.server.dto.ReportDto;
import com.munjaon.server.server.dto.ReportUserDto;
import com.munjaon.server.util.LogUtil;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;

public class ReportQueueTask
implements Runnable {
    public static final SimpleDateFormat sdf = new SimpleDateFormat("[MM-dd HH:mm:ss]");
    public static final String LOG_DATE_FORMAT = "[MM-dd HH:mm:ss]";
    private ReportUserDto reportUserDto;
    private final LogUtil logger;

    public ReportQueueTask(ReportUserDto reportUserDto, LogUtil logger) {
        this.reportUserDto = reportUserDto;
        this.logger = logger;
    }

    @Override
    public void run() {
        if (this.reportUserDto == null || this.reportUserDto.getUserId() == null) {
            return;
        }
        if (this.reportUserDto.getReportQueue() == null || !this.reportUserDto.getReportQueue().isOpen()) {
            return;
        }
        ReportQueue reportQueue = this.reportUserDto.getReportQueue();
        ReportService reportService = (ReportService)CacheService.REPORT_SERVICE.getService();
        List list = reportService.getReportListForUser(this.reportUserDto.getUserId());
        if (list == null || list.isEmpty()) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        for (ReportDto dto : list) {
            try {
                if (builder.isEmpty()) {
                    builder.append(dto.getMsgId());
                } else {
                    builder.append(",").append(dto.getMsgId());
                }
                this.saveSystemLog((Object)("reportDto : " + dto.toString()));
                reportQueue.pushReportToQueue(dto);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        HashMap<String, String> reqMap = new HashMap<String, String>();
        reqMap.put("userId", this.reportUserDto.getUserId());
        reqMap.put("msgId", builder.toString());
        reportService.deleteBulkReport(reqMap);
    }

    private void saveSystemLog(Object obj) {
        this.saveLog(obj, true);
    }

    private void saveLog(Object obj) {
        this.saveLog(obj, false);
    }

    private void saveLog(Object obj, boolean isConsoleOutput) {
        if (isConsoleOutput) {
            System.out.println(LocalDateTime.now().format(DateTimeFormatter.ofPattern(LOG_DATE_FORMAT)) + " {{REPORT_QUEUE_TASK}} " + obj);
        }
        if (this.logger == null) {
            return;
        }
        this.logger.log(obj);
    }
}

