/*
 * Decompiled with CFR 0.152.
 */
package com.munjaon.server.server.task;

import com.munjaon.server.cache.dto.MemberDto;
import com.munjaon.server.cache.enums.CacheService;
import com.munjaon.server.cache.service.MemberService;
import com.munjaon.server.queue.dto.BasicMessageDto;
import com.munjaon.server.queue.enums.QueueTypeWorker;
import com.munjaon.server.server.dto.ConnectUserDto;
import com.munjaon.server.server.packet.Bind;
import com.munjaon.server.server.packet.CommonMessage;
import com.munjaon.server.server.packet.Header;
import com.munjaon.server.server.packet.KakaoMessage;
import com.munjaon.server.server.packet.LinkCheck;
import com.munjaon.server.server.packet.LmsMessage;
import com.munjaon.server.server.packet.MmsMessage;
import com.munjaon.server.server.packet.Packet;
import com.munjaon.server.server.packet.SmsMessage;
import com.munjaon.server.server.queue.CollectUserQueue;
import com.munjaon.server.util.FileUtil;
import com.munjaon.server.util.JobFileFactory;
import com.munjaon.server.util.LogUtil;
import com.munjaon.server.util.MessageUtil;
import com.munjaon.server.util.SerialNoUtil;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.Callable;

public class CollectReadTask
implements Callable<ConnectUserDto> {
    public static final SimpleDateFormat sdf = new SimpleDateFormat("[MM-dd HH:mm:ss]");
    public static final String LOG_DATE_FORMAT = "[MM-dd HH:mm:ss]";
    private Selector selector;
    private SelectionKey key;
    private CollectUserQueue collectUserQueue = CollectUserQueue.getInstance();
    private ConnectUserDto connectUserDto;
    private String serviceType;
    private final LogUtil logger;

    public CollectReadTask(Selector selector, SelectionKey key, String serviceType, LogUtil logger) {
        this.selector = selector;
        this.key = key;
        this.connectUserDto = (ConnectUserDto)key.attachment();
        this.serviceType = serviceType;
        this.logger = logger;
    }

    @Override
    public ConnectUserDto call() throws Exception {
        int size = -1;
        try {
            SocketChannel channel = (SocketChannel)this.key.channel();
            ByteBuffer headBuffer = ByteBuffer.allocate(10);
            try {
                size = channel.read(headBuffer);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (size > 0) {
                String command = Header.getCommand((ByteBuffer)headBuffer);
                switch (Integer.parseInt(command)) {
                    case 1: {
                        this.recvBind(channel, headBuffer);
                        break;
                    }
                    case 3: {
                        this.recvDeliver(channel, headBuffer);
                        break;
                    }
                    case 7: {
                        this.recvLinkCheck(channel);
                        break;
                    }
                    default: {
                        this.expireConnectUser();
                        break;
                    }
                }
            } else {
                this.expireConnectUser();
            }
        }
        catch (Exception e) {
            size = -1;
            e.printStackTrace();
        }
        if (size <= 0) {
            this.connectUserDto.setCommand(-1);
        }
        return this.connectUserDto;
    }

    private void recvDeliver(SocketChannel channel, ByteBuffer headBuffer) throws IOException {
        switch (this.serviceType) {
            case "SMS": {
                this.recvSmsDeliver(channel, headBuffer);
                break;
            }
            case "LMS": {
                this.recvLmsDeliver(channel, headBuffer);
                break;
            }
            case "MMS": {
                this.recvMmsDeliver(channel, headBuffer);
                break;
            }
            case "KAT": {
                this.recvKatDeliver(channel, headBuffer);
                break;
            }
            case "KFT": {
                this.recvKftDeliver(channel, headBuffer);
                break;
            }
        }
    }

    public BasicMessageDto recvCommonMessage(ByteBuffer deliverBuffer) {
        if (deliverBuffer == null) {
            return null;
        }
        BasicMessageDto messageDto = new BasicMessageDto();
        messageDto.setRouterSeq("40");
        messageDto.setServiceType("4");
        messageDto.setUserId(this.connectUserDto.getUserId());
        messageDto.setRemoteIP(this.connectUserDto.getRemoteIP());
        messageDto.setSendStatus("0");
        messageDto.setUserMsgID(CommonMessage.getMessageIdForDeliver((ByteBuffer)deliverBuffer));
        messageDto.setUserSender(CommonMessage.getSenderForDeliver((ByteBuffer)deliverBuffer));
        messageDto.setUserReceiver(CommonMessage.getReceiverForDeliver((ByteBuffer)deliverBuffer));
        messageDto.setReserveDt(CommonMessage.getReserveTimeForDeliver((ByteBuffer)deliverBuffer));
        messageDto.setRequestDt(CommonMessage.getRequestTimeForDeliver((ByteBuffer)deliverBuffer));
        messageDto.setUnitCost("10.4");
        return messageDto;
    }

    private void recvSmsDeliver(SocketChannel channel, ByteBuffer headBuffer) throws IOException {
        try {
            ByteBuffer bodyBuffer = ByteBuffer.allocate(239);
            channel.read(bodyBuffer);
            ByteBuffer deliverBuffer = ByteBuffer.allocate(249);
            Packet.mergeBuffers((ByteBuffer)deliverBuffer, (ByteBuffer)headBuffer, (ByteBuffer)bodyBuffer);
            BasicMessageDto messageDto = this.recvCommonMessage(deliverBuffer);
            messageDto.setUserMessage(SmsMessage.getMessageForDeliver((ByteBuffer)deliverBuffer));
            System.out.println("BasicMessageDto : " + messageDto.toString());
            QueueTypeWorker worker = QueueTypeWorker.find((String)"SMS");
            if (worker != null) {
                worker.pushQueue(messageDto);
                channel.write(SmsMessage.makeDeliverAckBuffer((String)messageDto.getUserMsgID(), (String)messageDto.getSendStatus()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void recvLmsDeliver(SocketChannel channel, ByteBuffer headBuffer) throws IOException {
        try {
            ByteBuffer bodyBuffer = ByteBuffer.allocate(2129);
            channel.read(bodyBuffer);
            ByteBuffer deliverBuffer = ByteBuffer.allocate(2139);
            Packet.mergeBuffers((ByteBuffer)deliverBuffer, (ByteBuffer)headBuffer, (ByteBuffer)bodyBuffer);
            BasicMessageDto messageDto = this.recvCommonMessage(deliverBuffer);
            messageDto.setUserSubject(LmsMessage.getSubjectForDeliver((ByteBuffer)deliverBuffer));
            messageDto.setUserMessage(LmsMessage.getMessageForDeliver((ByteBuffer)deliverBuffer));
            QueueTypeWorker worker = QueueTypeWorker.find((String)"LMS");
            if (worker != null) {
                worker.pushQueue(messageDto);
                channel.write(LmsMessage.makeDeliverAckBuffer((String)messageDto.getUserMsgID(), (String)messageDto.getSendStatus()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void recvMmsDeliver(SocketChannel channel, ByteBuffer headBuffer) throws IOException {
        try {
            ByteBuffer bodyBuffer = ByteBuffer.allocate(2130);
            channel.read(bodyBuffer);
            ByteBuffer deliverBuffer = ByteBuffer.allocate(2140);
            Packet.mergeBuffers((ByteBuffer)deliverBuffer, (ByteBuffer)headBuffer, (ByteBuffer)bodyBuffer);
            BasicMessageDto messageDto = this.recvCommonMessage(deliverBuffer);
            messageDto.setUserSubject(MmsMessage.getSubjectForDeliver((ByteBuffer)deliverBuffer));
            messageDto.setUserMessage(MmsMessage.getMessageForDeliver((ByteBuffer)deliverBuffer));
            String fileCount = MessageUtil.doNumber((String)MmsMessage.getFileCountForDeliver((ByteBuffer)deliverBuffer));
            int recvFileCount = 0;
            if (fileCount != null && fileCount.length() > 0) {
                recvFileCount = Integer.parseInt(fileCount);
                messageDto.setUserFileCnt(recvFileCount);
                this.saveSystemLog((Object)("recvFileCount : " + recvFileCount));
            }
            this.saveSystemLog((Object)("messageDto : " + messageDto.toString()));
            String imagePath = System.getProperty("ROOTPATH") + File.separator + "mmsfile";
            imagePath = imagePath + File.separator + MessageUtil.getDate() + File.separator + SerialNoUtil.getSerialNo();
            FileUtil.mkdirs((String)imagePath);
            for (int i = 0; i < recvFileCount; ++i) {
                ByteBuffer fileHeadBuffer = ByteBuffer.allocate(48);
                channel.read(fileHeadBuffer);
                String fileName = MmsMessage.getFileNameForDeliver((ByteBuffer)fileHeadBuffer);
                String fileSize = MmsMessage.getFileSizeForDeliver((ByteBuffer)fileHeadBuffer);
                ByteBuffer fileBuffer = ByteBuffer.allocate(Integer.parseInt(fileSize));
                channel.read(fileBuffer);
                fileBuffer.flip();
                JobFileFactory.saveFileForByteBuffer((String)imagePath, (String)fileName, (ByteBuffer)fileBuffer);
                if (i == 0) {
                    messageDto.setUserFileName01(imagePath + File.separator + fileName);
                } else if (i == 1) {
                    messageDto.setUserFileName02(imagePath + File.separator + fileName);
                } else if (i == 2) {
                    messageDto.setUserFileName03(imagePath + File.separator + fileName);
                }
                this.saveSystemLog((Object)("File : " + fileName + ", Size : " + fileSize));
            }
            QueueTypeWorker worker = QueueTypeWorker.find((String)"MMS");
            if (worker != null) {
                worker.pushQueue(messageDto);
                channel.write(MmsMessage.makeDeliverAckBuffer((String)messageDto.getUserMsgID(), (String)messageDto.getSendStatus()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void recvKatDeliver(SocketChannel channel, ByteBuffer headBuffer) throws IOException {
        try {
            ByteBuffer bodyBuffer = ByteBuffer.allocate(2233);
            channel.read(bodyBuffer);
            ByteBuffer deliverBuffer = ByteBuffer.allocate(2243);
            Packet.mergeBuffers((ByteBuffer)deliverBuffer, (ByteBuffer)headBuffer, (ByteBuffer)bodyBuffer);
            BasicMessageDto messageDto = this.recvCommonMessage(deliverBuffer);
            messageDto.setUserSubject(KakaoMessage.getSubjectForDeliver((ByteBuffer)deliverBuffer));
            messageDto.setUserMessage(KakaoMessage.getMessageForDeliver((ByteBuffer)deliverBuffer));
            messageDto.setKakaoSenderKey(KakaoMessage.getKakaoSenderKeyForDeliver((ByteBuffer)deliverBuffer));
            messageDto.setKakaoTemplateCode(KakaoMessage.getKakaoTemplateCodeForDeliver((ByteBuffer)deliverBuffer));
            this.saveSystemLog((Object)("messageDto : " + messageDto.toString()));
            String jsonPath = System.getProperty("ROOTPATH") + File.separator + "kakaofile";
            jsonPath = jsonPath + File.separator + MessageUtil.getDate() + File.separator + SerialNoUtil.getSerialNo();
            FileUtil.mkdirs((String)jsonPath);
            ByteBuffer fileHeadBuffer = ByteBuffer.allocate(48);
            channel.read(fileHeadBuffer);
            String fileName = KakaoMessage.getFileNameForDeliver((ByteBuffer)fileHeadBuffer);
            String fileSize = KakaoMessage.getFileSizeForDeliver((ByteBuffer)fileHeadBuffer);
            ByteBuffer fileBuffer = ByteBuffer.allocate(Integer.parseInt(fileSize));
            channel.read(fileBuffer);
            fileBuffer.flip();
            JobFileFactory.saveFileForByteBuffer((String)jsonPath, (String)fileName, (ByteBuffer)fileBuffer);
            messageDto.setKakaoJsonFile(jsonPath + File.separator + fileName);
            this.saveSystemLog((Object)("File : " + fileName + ", Size : " + fileSize));
            QueueTypeWorker worker = QueueTypeWorker.find((String)"KAT");
            if (worker != null) {
                worker.pushQueue(messageDto);
                channel.write(KakaoMessage.makeDeliverAckBuffer((String)messageDto.getUserMsgID(), (String)messageDto.getSendStatus()));
            } else {
                this.saveSystemLog((Object)"worker is null");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void recvKftDeliver(SocketChannel channel, ByteBuffer headBuffer) throws IOException {
        try {
            ByteBuffer bodyBuffer = ByteBuffer.allocate(2233);
            channel.read(bodyBuffer);
            ByteBuffer deliverBuffer = ByteBuffer.allocate(2243);
            Packet.mergeBuffers((ByteBuffer)deliverBuffer, (ByteBuffer)headBuffer, (ByteBuffer)bodyBuffer);
            BasicMessageDto messageDto = this.recvCommonMessage(deliverBuffer);
            messageDto.setUserSubject(KakaoMessage.getSubjectForDeliver((ByteBuffer)deliverBuffer));
            messageDto.setUserMessage(KakaoMessage.getMessageForDeliver((ByteBuffer)deliverBuffer));
            messageDto.setKakaoSenderKey(KakaoMessage.getKakaoSenderKeyForDeliver((ByteBuffer)deliverBuffer));
            messageDto.setKakaoTemplateCode(KakaoMessage.getKakaoTemplateCodeForDeliver((ByteBuffer)deliverBuffer));
            this.saveSystemLog((Object)("messageDto : " + messageDto.toString()));
            String jsonPath = System.getProperty("ROOTPATH") + File.separator + "kakaofile";
            jsonPath = jsonPath + File.separator + MessageUtil.getDate() + File.separator + SerialNoUtil.getSerialNo();
            FileUtil.mkdirs((String)jsonPath);
            ByteBuffer fileHeadBuffer = ByteBuffer.allocate(48);
            channel.read(fileHeadBuffer);
            String fileName = KakaoMessage.getFileNameForDeliver((ByteBuffer)fileHeadBuffer);
            String fileSize = KakaoMessage.getFileSizeForDeliver((ByteBuffer)fileHeadBuffer);
            ByteBuffer fileBuffer = ByteBuffer.allocate(Integer.parseInt(fileSize));
            channel.read(fileBuffer);
            fileBuffer.flip();
            JobFileFactory.saveFileForByteBuffer((String)jsonPath, (String)fileName, (ByteBuffer)fileBuffer);
            messageDto.setKakaoJsonFile(jsonPath + File.separator + fileName);
            this.saveSystemLog((Object)("File : " + fileName + ", Size : " + fileSize));
            QueueTypeWorker worker = QueueTypeWorker.find((String)"KFT");
            if (worker != null) {
                worker.pushQueue(messageDto);
                channel.write(KakaoMessage.makeDeliverAckBuffer((String)messageDto.getUserMsgID(), (String)messageDto.getSendStatus()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void recvLinkCheck(SocketChannel channel) throws IOException {
        ByteBuffer bodyBuffer = ByteBuffer.allocate(3);
        channel.read(bodyBuffer);
        channel.write(LinkCheck.makeLinkCheckAckBuffer());
    }

    private void recvBind(SocketChannel channel, ByteBuffer headBuffer) {
        String resultCode = "00";
        try {
            ByteBuffer bindBuffer = ByteBuffer.allocate(51);
            ByteBuffer bodyBuffer = ByteBuffer.allocate(41);
            channel.read(bodyBuffer);
            Packet.mergeBuffers((ByteBuffer)bindBuffer, (ByteBuffer)headBuffer, (ByteBuffer)bodyBuffer);
            String id = Bind.getBindId((ByteBuffer)bindBuffer);
            String pwd = Bind.getBindPwd((ByteBuffer)bindBuffer);
            this.saveSystemLog((Object)("Bind id : " + id));
            this.saveSystemLog((Object)("Bind pwd : " + pwd));
            if (id == null || pwd == null) {
                resultCode = "50";
            } else if (this.collectUserQueue.isExist(this.serviceType, id)) {
                resultCode = "60";
            } else {
                MemberService svc = (MemberService)CacheService.LOGIN_SERVICE.getService();
                MemberDto memberDto = null;
                if (svc != null) {
                    memberDto = svc.get(id);
                }
                if (memberDto == null || !pwd.equals(memberDto.getAccessKey())) {
                    resultCode = "20";
                } else {
                    this.connectUserDto.setUserId(id);
                    this.connectUserDto.setLogin(true);
                    this.connectUserDto.setMemberDto(memberDto);
                    this.connectUserDto.updateLastTrafficTime();
                }
            }
        }
        catch (Exception e) {
            resultCode = "10";
            e.printStackTrace();
        }
        try {
            this.saveSystemLog((Object)("Bind ResultCode : " + resultCode));
            channel.write(Bind.makeBindAckBuffer((String)resultCode));
            if (!"00".equals(resultCode)) {
                this.expireConnectUser();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void expireConnectUser() {
        if (this.key == null || !this.key.isValid()) {
            return;
        }
        try {
            SocketChannel channel = (SocketChannel)this.key.channel();
            if (this.connectUserDto != null) {
                if (this.connectUserDto.getUserId() != null) {
                    this.collectUserQueue.removeUser(this.connectUserDto.getServiceType(), this.connectUserDto.getUserId());
                }
                this.key.attach(null);
            }
            channel.close();
            this.key.cancel();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveSystemLog(Object obj) {
        this.saveLog(obj, true);
    }

    private void saveLog(Object obj) {
        this.saveLog(obj, false);
    }

    private void saveLog(Object obj, boolean isConsoleOutput) {
        if (isConsoleOutput) {
            System.out.println(LocalDateTime.now().format(DateTimeFormatter.ofPattern(LOG_DATE_FORMAT)) + " {{COLLECT_READ_TASK}} " + obj);
        }
        if (this.logger == null) {
            return;
        }
        this.logger.log(obj);
    }
}

