/*
 * Decompiled with CFR 0.152.
 */
package com.munjaon.server.server.service;

import com.munjaon.server.server.config.ServerConfig;
import com.munjaon.server.server.service.PropertyLoader;
import com.munjaon.server.util.LogUtil;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.json.simple.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class Service
extends Thread {
    public static final SimpleDateFormat sdf = new SimpleDateFormat("[MM-dd HH:mm:ss]");
    public static final String LOG_DATE_FORMAT = "[MM-dd HH:mm:ss]";
    private String LOG_FILE;
    protected LogUtil logger;
    private Long LAST_PROPERTY_LOAD_TIME = 0L;
    protected boolean IS_SERVER_RUN;
    protected boolean IS_READY_YN;
    protected boolean IS_RUN_YN;
    protected boolean IS_STOP_YN;

    public Service() {
    }

    public Service(String serviceName) {
        super(serviceName);
        this.LOG_FILE = System.getProperty("ROOTPATH") + this.getProp("LOG_FILE");
    }

    protected String getProp(String name) {
        return Service.getProp((String)this.getName(), (String)name);
    }

    public static String getProp(String svc, String name) {
        return PropertyLoader.getProp((String)svc, (String)name);
    }

    protected void checkRun() {
        this.IS_RUN_YN = this.getProp("RUN_FLAG") != null && "Y".equals(this.getProp("RUN_FLAG"));
    }

    protected void checkServerRun() {
        this.IS_SERVER_RUN = Service.getProp((String)"server", (String)"run") != null && "Y".equals(Service.getProp((String)"server", (String)"run"));
    }

    public void reloadCheckRun() {
        if (System.currentTimeMillis() - this.LAST_PROPERTY_LOAD_TIME > ServerConfig.INTERVAL_PROPERTY_RELOAD_TIME) {
            this.checkRun();
            this.checkServerRun();
            this.LAST_PROPERTY_LOAD_TIME = System.currentTimeMillis();
        }
    }

    public boolean isRun() {
        return this.IS_SERVER_RUN && this.IS_RUN_YN && !this.IS_STOP_YN;
    }

    public boolean isReady() {
        return this.IS_READY_YN;
    }

    protected void setLogFile(String sLogFile) {
        if (this.logger != null) {
            this.logger.close();
            this.logger = null;
        }
        this.logger = new LogUtil(sLogFile);
    }

    protected void saveSystemLog(Object obj) {
        this.saveLog(obj, true);
    }

    protected void saveLog(Object obj) {
        this.saveLog(obj, false);
    }

    protected void saveLog(Object obj, boolean isConsoleOutput) {
        if (isConsoleOutput) {
            System.out.println(LocalDateTime.now().format(DateTimeFormatter.ofPattern("[MM-dd HH:mm:ss]")) + " {{" + this.getName() + "}} " + obj);
        }
        if (this.logger != null) {
            this.logger.log(obj);
        } else if (obj instanceof Throwable) {
            LogUtil.log((String)this.LOG_FILE, (Object)obj);
        } else {
            LogUtil.log((String)this.LOG_FILE, (Object)("{{" + this.getName() + "}} " + obj));
        }
    }

    protected void initLogFile() {
        this.LOG_FILE = System.getProperty("ROOTPATH") + this.getProp("LOG_FILE");
        System.out.println("LOG_FILE: " + this.LOG_FILE);
        this.setLogFile(this.LOG_FILE);
        this.saveSystemLog((Object)"Service Log Initializing ... ...");
    }

    @Override
    public void run() {
        while (true) {
            try {
                this.checkReady();
                this.initLogFile();
                this.reloadCheckRun();
                if (this.isRun() && this.isReady()) {
                    this.initResources();
                    this.doService();
                    this.releaseResources();
                    this.saveSystemLog((Object)"Service Stopped.");
                } else {
                    this.saveSystemLog((Object)"Service is Not Running.");
                }
                Thread.sleep(3000L);
                continue;
            }
            catch (Exception e) {
                this.saveSystemLog((Object)e);
                continue;
            }
            finally {
                if (this.logger == null) continue;
                this.logger.close();
                this.logger = null;
                continue;
            }
            break;
        }
    }

    public abstract void checkReady();

    public abstract void initResources();

    public abstract void releaseResources();

    public abstract void doService();

    public abstract JSONObject monitorService();
}

