/*
 * Decompiled with CFR 0.152.
 */
package com.munjaon.server.server.service;

import com.munjaon.server.queue.dto.BasicMessageDto;
import com.munjaon.server.queue.enums.QueueTypeWorker;
import com.munjaon.server.queue.pool.ReadQueue;
import com.munjaon.server.queue.pool.WriteQueue;
import com.munjaon.server.server.service.PropertyLoader;
import com.munjaon.server.server.service.Service;
import com.munjaon.server.util.CommonUtil;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.json.simple.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
public class QueueServerService
extends Service {
    private String QUEUE_MODE = null;
    private long QUEUE_MODE_CHECK_TIME = 0L;
    private long QUEUE_INIT_CHECK_TIME = 0L;
    private long SUM_COMMIT_COUNT = 0L;
    private WriteQueue writeQueue;
    private ReadQueue readQueue;
    private QueueTypeWorker worker;

    public QueueServerService(String serviceName, WriteQueue writeQueue, ReadQueue readQueue) {
        super(serviceName);
        this.writeQueue = writeQueue;
        this.readQueue = readQueue;
        this.worker = QueueTypeWorker.find((String)writeQueue.getQueueInfo().getServiceType());
        if (this.worker == null) {
            throw new RuntimeException("No worker found for " + writeQueue.getQueueInfo().getServiceType());
        }
    }

    public void checkMode() {
        if (System.currentTimeMillis() - this.QUEUE_MODE_CHECK_TIME > 10000L) {
            this.QUEUE_MODE = PropertyLoader.get((String)"COMMON.QUEUE_MODE");
            if (this.QUEUE_MODE == null) {
                this.QUEUE_MODE = "DB";
            }
            this.QUEUE_MODE = this.QUEUE_MODE.toUpperCase();
            this.QUEUE_MODE_CHECK_TIME = System.currentTimeMillis();
        }
    }

    public void checkReady() {
        this.IS_READY_YN = true;
    }

    public void initResources() {
        this.QUEUE_MODE = QueueServerService.getProp((String)"COMMON", (String)"QUEUE_MODE");
        if (this.QUEUE_MODE == null) {
            this.QUEUE_MODE = "DB";
        }
        try {
            if (this.isRun()) {
                this.writeQueue.initQueue();
                this.readQueue.initQueue();
                this.initQueue();
                this.worker.addQueue(this.writeQueue);
                this.loadMemoryQueue();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void initQueue() throws Exception {
        boolean isQueueInit = false;
        String writeQueueCreateDate = this.writeQueue.getCreateDate();
        String readQueueCreateDate = this.readQueue.getReadXMLDate();
        String thisDate = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        if (readQueueCreateDate.equals(readQueueCreateDate)) {
            if (thisDate.equals(writeQueueCreateDate)) {
                isQueueInit = false;
            } else {
                String preDate = CommonUtil.getTargetDay((int)-24);
                if (writeQueueCreateDate.equals(preDate)) {
                    BasicMessageDto messageDto;
                    while ((messageDto = this.readQueue.popMessageFromBuffer()) != null) {
                        this.worker.memoryEnQueue(messageDto);
                    }
                    isQueueInit = true;
                } else {
                    isQueueInit = true;
                }
            }
        } else {
            isQueueInit = true;
        }
        if (isQueueInit) {
            this.SUM_COMMIT_COUNT = 0L;
            this.writeQueue.truncateQueue();
            this.readQueue.initPopCounter();
        }
    }

    private void loadMemoryQueue() throws Exception {
        if (this.worker.getMemorySize() > 0) {
            BasicMessageDto messageDto;
            while ((messageDto = this.worker.memoryDeQueue()) != null) {
                this.writeQueue.pushMessageToBuffer(messageDto);
            }
        }
    }

    private void checkQueue() throws Exception {
        if (System.currentTimeMillis() - this.QUEUE_INIT_CHECK_TIME < 60000L) {
            return;
        }
        this.QUEUE_INIT_CHECK_TIME = System.currentTimeMillis();
        boolean isQueueInit = false;
        String thisDate = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String writeQueueCreateDate = this.writeQueue.getCreateDate();
        if (!writeQueueCreateDate.equals(thisDate)) {
            BasicMessageDto messageDto;
            if (this.worker != null) {
                this.worker.removeQueue(this.writeQueue.getQueueInfo().getQueueName());
            }
            while ((messageDto = this.readQueue.popMessageFromBuffer()) != null) {
                this.worker.memoryEnQueue(messageDto);
            }
            isQueueInit = true;
        }
        if (isQueueInit) {
            this.SUM_COMMIT_COUNT = 0L;
            this.writeQueue.truncateQueue();
            this.readQueue.initPopCounter();
            this.worker.addQueue(this.writeQueue);
            this.loadMemoryQueue();
        }
    }

    private void messageService() throws Exception {
        BasicMessageDto messageDto;
        int DB_PROC_COUNT = 0;
        for (int loopCnt = 0; loopCnt < 30 && (messageDto = this.readQueue.popMessageFromBuffer()) != null; ++loopCnt) {
            this.worker.saveMessageToTable(messageDto);
            ++DB_PROC_COUNT;
            ++this.SUM_COMMIT_COUNT;
        }
        if (DB_PROC_COUNT > 0) {
            Thread.sleep(10L);
        } else {
            Thread.sleep(1000L);
        }
    }

    public void releaseResources() {
        try {
            if (this.writeQueue != null) {
                this.worker.removeQueue(this.writeQueue.getQueueInfo().getQueueName());
                this.writeQueue.close();
            }
            if (this.readQueue != null) {
                this.readQueue.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void doService() {
        while (this.isRun()) {
            try {
                this.checkMode();
                this.checkQueue();
                this.messageService();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public JSONObject monitorService() {
        return null;
    }
}

