/*
 * Decompiled with CFR 0.152.
 */
package com.munjaon.server.server.service;

import com.munjaon.server.queue.enums.QueueTypeWorker;
import com.munjaon.server.server.service.CollectBackServerService;
import com.munjaon.server.server.service.Service;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.util.Iterator;
import org.json.simple.JSONObject;

public class CollectBackServerService
extends Service {
    private final InetSocketAddress listenAddress;
    private CollectorThreadService threadService;
    private Selector selector;
    private final String serviceType;

    public CollectBackServerService(String serviceName, String serviceType, int port) {
        super(serviceName);
        this.listenAddress = new InetSocketAddress(port);
        this.serviceType = serviceType;
    }

    public void checkReady() {
        QueueTypeWorker worker = QueueTypeWorker.find((String)this.serviceType);
        this.IS_READY_YN = worker != null && worker.getQueueSize() > 0;
    }

    public void initResources() {
        try {
            this.initCollectChannel();
            this.threadService = new CollectorThreadService(8, this.serviceType, this.logger);
        }
        catch (IOException e) {
            this.saveSystemLog((Object)e);
            throw new RuntimeException(e);
        }
    }

    private void initCollectChannel() throws IOException {
        this.selector = Selector.open();
        ServerSocketChannel serverChannel = ServerSocketChannel.open();
        serverChannel.configureBlocking(false);
        serverChannel.socket().bind(this.listenAddress);
        serverChannel.register(this.selector, 16);
    }

    private void closeCollectChannel() throws IOException {
        this.selector.close();
    }

    public void releaseResources() {
        try {
            this.closeCollectChannel();
            this.threadService.close();
        }
        catch (IOException e) {
            this.saveSystemLog((Object)e);
            throw new RuntimeException(e);
        }
    }

    public void doService() {
        while (this.isRun()) {
            try {
                this.execInterest();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void execInterest() throws IOException {
        if (this.selector.select(1000L) == 0) {
            return;
        }
        Iterator<SelectionKey> keys = this.selector.selectedKeys().iterator();
        while (keys.hasNext()) {
            SelectionKey key = keys.next();
            if (key.isValid()) {
                if (key.isAcceptable()) {
                    this.saveSystemLog((Object)"isAcceptable");
                    this.threadService.submit(this.selector, key, 1);
                } else if (key.isReadable()) {
                    this.saveSystemLog((Object)"isReadable");
                    this.threadService.submit(this.selector, key, 2);
                } else if (key.isWritable()) {
                    this.saveSystemLog((Object)"isWritable");
                    this.threadService.submit(this.selector, key, 3);
                }
            }
            keys.remove();
        }
    }

    public JSONObject monitorService() {
        return null;
    }
}

