/*
 * Decompiled with CFR 0.152.
 */
package com.munjaon.server.server.queue;

import com.munjaon.server.queue.pool.ReportQueue;
import com.munjaon.server.server.dto.ReportUserDto;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ReportUserQueue {
    private final Object lockObject = new Object();
    private final Map<String, ReportUserDto> connectUserQueue = new LinkedHashMap();
    private static ReportUserQueue reportUserQueue;

    private ReportUserQueue() {
    }

    public static synchronized ReportUserQueue getInstance() {
        if (reportUserQueue == null) {
            reportUserQueue = new ReportUserQueue();
        }
        return reportUserQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putUser(ReportUserDto user) {
        Object object = this.lockObject;
        synchronized (object) {
            this.connectUserQueue.put(user.getUserId(), user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReportUserDto getUser(String userId) {
        Object object = this.lockObject;
        synchronized (object) {
            return (ReportUserDto)this.connectUserQueue.get(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ReportUserDto> getUsers() {
        Object object = this.lockObject;
        synchronized (object) {
            return new ArrayList<ReportUserDto>(this.connectUserQueue.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExist(String userId) {
        Object object = this.lockObject;
        synchronized (object) {
            return this.connectUserQueue.containsKey(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUser(String userId) {
        Object object = this.lockObject;
        synchronized (object) {
            ReportUserDto userDto = (ReportUserDto)this.connectUserQueue.remove(userId);
            if (userDto != null) {
                ReportQueue queue = userDto.getReportQueue();
                try {
                    queue.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.lockObject;
        synchronized (object) {
            return this.connectUserQueue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.lockObject;
        synchronized (object) {
            return this.connectUserQueue.isEmpty();
        }
    }
}

