/*
 * Decompiled with CFR 0.152.
 */
package com.munjaon.server.server.queue;

import com.munjaon.server.server.dto.ConnectUserDto;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CollectUserQueue {
    private final Object lockObject = new Object();
    private final Map<String, ConnectUserDto> smstUserQueue = new LinkedHashMap();
    private final Map<String, ConnectUserDto> lmsUserQueue = new LinkedHashMap();
    private final Map<String, ConnectUserDto> mmsUserQueue = new LinkedHashMap();
    private final Map<String, ConnectUserDto> katUserQueue = new LinkedHashMap();
    private final Map<String, ConnectUserDto> kftUserQueue = new LinkedHashMap();
    private static CollectUserQueue collectUserQueue;

    private CollectUserQueue() {
    }

    public static synchronized CollectUserQueue getInstance() {
        if (collectUserQueue == null) {
            collectUserQueue = new CollectUserQueue();
        }
        return collectUserQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putUser(String serviceType, ConnectUserDto user) {
        Object object = this.lockObject;
        synchronized (object) {
            switch (serviceType) {
                case "SMS": {
                    this.smstUserQueue.put(user.getUserId(), user);
                    break;
                }
                case "LMS": {
                    this.lmsUserQueue.put(user.getUserId(), user);
                    break;
                }
                case "MMS": {
                    this.mmsUserQueue.put(user.getUserId(), user);
                    break;
                }
                case "KAT": {
                    this.katUserQueue.put(user.getUserId(), user);
                    break;
                }
                case "KFT": {
                    this.kftUserQueue.put(user.getUserId(), user);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectUserDto getUser(String serviceType, String userId) {
        Object object = this.lockObject;
        synchronized (object) {
            switch (serviceType) {
                case "SMS": {
                    return (ConnectUserDto)this.smstUserQueue.get(userId);
                }
                case "LMS": {
                    return (ConnectUserDto)this.lmsUserQueue.get(userId);
                }
                case "MMS": {
                    return (ConnectUserDto)this.mmsUserQueue.get(userId);
                }
                case "KAT": {
                    return (ConnectUserDto)this.katUserQueue.get(userId);
                }
                case "KFT": {
                    return (ConnectUserDto)this.kftUserQueue.get(userId);
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConnectUserDto> getUsers(String serviceType) {
        Object object = this.lockObject;
        synchronized (object) {
            switch (serviceType) {
                case "SMS": {
                    return new ArrayList<ConnectUserDto>(this.smstUserQueue.values());
                }
                case "LMS": {
                    return new ArrayList<ConnectUserDto>(this.lmsUserQueue.values());
                }
                case "MMS": {
                    return new ArrayList<ConnectUserDto>(this.mmsUserQueue.values());
                }
                case "KAT": {
                    return new ArrayList<ConnectUserDto>(this.katUserQueue.values());
                }
                case "KFT": {
                    return new ArrayList<ConnectUserDto>(this.kftUserQueue.values());
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExist(String serviceType, String userId) {
        Object object = this.lockObject;
        synchronized (object) {
            switch (serviceType) {
                case "SMS": {
                    return this.smstUserQueue.containsKey(userId);
                }
                case "LMS": {
                    return this.lmsUserQueue.containsKey(userId);
                }
                case "MMS": {
                    return this.mmsUserQueue.containsKey(userId);
                }
                case "KAT": {
                    return this.katUserQueue.containsKey(userId);
                }
                case "KFT": {
                    return this.kftUserQueue.containsKey(userId);
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUser(String serviceType, String userId) {
        Object object = this.lockObject;
        synchronized (object) {
            switch (serviceType) {
                case "SMS": {
                    this.smstUserQueue.remove(userId);
                    break;
                }
                case "LMS": {
                    this.lmsUserQueue.remove(userId);
                    break;
                }
                case "MMS": {
                    this.mmsUserQueue.remove(userId);
                    break;
                }
                case "KAT": {
                    this.katUserQueue.remove(userId);
                    break;
                }
                case "KFT": {
                    this.kftUserQueue.remove(userId);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size(String serviceType) {
        Object object = this.lockObject;
        synchronized (object) {
            switch (serviceType) {
                case "SMS": {
                    return this.smstUserQueue.size();
                }
                case "LMS": {
                    return this.lmsUserQueue.size();
                }
                case "MMS": {
                    return this.mmsUserQueue.size();
                }
                case "KAT": {
                    return this.katUserQueue.size();
                }
                case "KFT": {
                    return this.kftUserQueue.size();
                }
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty(String serviceType) {
        Object object = this.lockObject;
        synchronized (object) {
            switch (serviceType) {
                case "SMS": {
                    return this.smstUserQueue.isEmpty();
                }
                case "LMS": {
                    return this.lmsUserQueue.isEmpty();
                }
                case "MMS": {
                    return this.mmsUserQueue.isEmpty();
                }
                case "KAT": {
                    return this.katUserQueue.isEmpty();
                }
                case "KFT": {
                    return this.kftUserQueue.isEmpty();
                }
            }
            return true;
        }
    }
}

