/*
 * Decompiled with CFR 0.152.
 */
package com.munjaon.server.server.packet;

import com.munjaon.server.server.packet.Header;
import com.munjaon.server.server.packet.Packet;
import com.munjaon.server.util.CommonUtil;
import java.nio.ByteBuffer;

public final class LmsMessage {
    public static final int DELIVER_LMS_BODY_LENGTH = 2129;
    public static final int DELIVER_LMS_ACK_BODY_LENGTH = 21;
    public static final int DELIVER_SUBJECT_LENGTH = 40;
    public static final int DELIVER_SUBJECT_POSITION = 89;
    public static final int DELIVER_MESSAGE_LENGTH = 2000;
    public static final int DELIVER_MESSAGE_POSITION = 129;

    public static void putSubjectForDeliver(ByteBuffer buffer, String subject) {
        if (buffer == null || subject == null) {
            return;
        }
        subject = CommonUtil.cutString((String)subject, (int)40);
        buffer.put(89, subject.getBytes());
    }

    public static String getSubjectForDeliver(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        buffer.position(89);
        byte[] destArray = new byte[40];
        buffer.get(destArray);
        return Packet.getString((byte[])destArray);
    }

    public static void putMessageForDeliver(ByteBuffer buffer, String message) {
        if (buffer == null || message == null) {
            return;
        }
        message = CommonUtil.cutString((String)message, (int)2000);
        buffer.put(129, message.getBytes());
    }

    public static String getMessageForDeliver(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        buffer.position(129);
        byte[] destArray = new byte[2000];
        buffer.get(destArray);
        return Packet.getString((byte[])destArray);
    }

    public static ByteBuffer makeDeliverAckBuffer(String msgId, String status) {
        ByteBuffer buffer = ByteBuffer.allocate(31);
        Packet.setDefaultByte((ByteBuffer)buffer);
        Header.putHeader((ByteBuffer)buffer, (String)"4", (int)21);
        buffer.put(10, msgId.getBytes());
        buffer.put(30, status.getBytes());
        return buffer;
    }
}

