/*
 * Decompiled with CFR 0.152.
 */
package com.munjaon.server.util;

import com.munjaon.server.config.ServiceCode;
import com.munjaon.server.queue.config.QueueConstants;
import com.munjaon.server.queue.dto.BasicMessageDto;
import com.munjaon.server.server.dto.ReportDto;
import com.munjaon.server.util.StringUtil;
import java.nio.ByteBuffer;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

/*
 * Exception performing whole class analysis ignored.
 */
public final class MessageUtil {
    public static String getDateFormat(String format) {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern(format));
    }

    public static String getDate() {
        return MessageUtil.getDateFormat((String)"yyyyMMdd");
    }

    public static String getTime() {
        return MessageUtil.getDateFormat((String)"yyyyMMddHHmmss");
    }

    public static String doNumber(String spell) {
        StringBuilder phoneNumber = new StringBuilder();
        if (spell == null) {
            return phoneNumber.toString();
        }
        int spell_Length = (spell = spell.trim()).length();
        if (spell_Length < 1) {
            return phoneNumber.toString();
        }
        for (int i = 0; i < spell_Length; ++i) {
            char eachChar = spell.charAt(i);
            if ('0' > eachChar || eachChar > '9') continue;
            phoneNumber.append(eachChar);
        }
        return phoneNumber.toString();
    }

    public static String cutFloatNumber(String srcNum, int digit) {
        int index;
        String headNum = "";
        String tailNum = "";
        Object retNum = "";
        if (srcNum != null && !srcNum.trim().isEmpty() && (index = (srcNum = srcNum.trim()).indexOf(".")) > 0) {
            headNum = srcNum.substring(0, index);
            tailNum = srcNum.substring(index + 1);
            if (tailNum.isEmpty()) {
                tailNum = "0";
            }
            if (tailNum.length() > digit) {
                tailNum = tailNum.substring(0, digit);
            }
            retNum = headNum + "." + tailNum;
        }
        return retNum;
    }

    public static boolean checkPhone(String src) {
        if (src == null || src.trim().length() < 10) {
            return false;
        }
        return src.startsWith("0");
    }

    public static String trim(String obj) {
        return StringUtil.trim((Object)obj);
    }

    public static boolean isEmptyForMessage(String obj, boolean trimFlag) {
        if (trimFlag) {
            return obj == null || obj.trim().isEmpty();
        }
        return obj == null || obj.isEmpty();
    }

    public static boolean isEmptyForMessage(String obj) {
        return MessageUtil.isEmptyForMessage((String)obj, (boolean)false);
    }

    public static boolean isOverByteForMessage(String obj, int limitCount, boolean trimFlag) {
        if (MessageUtil.isEmptyForMessage((String)obj, (boolean)trimFlag)) {
            return true;
        }
        return obj.getBytes().length > limitCount;
    }

    public static boolean isOverByteForMessage(String obj, int limitCount) {
        return MessageUtil.isOverByteForMessage((String)obj, (int)limitCount, (boolean)false);
    }

    public static int calcWritePosition(int pushCounter, int dataByteLength) {
        return pushCounter < 0 ? 20 : 20 + pushCounter * dataByteLength;
    }

    public static int calcReadPosition(int popCounter, int dataByteLength) {
        return popCounter < 0 ? 20 : 20 + popCounter * dataByteLength;
    }

    public static void setBytesForCommonMessage(ByteBuffer buffer, BasicMessageDto messageDto) {
        buffer.position(0);
        buffer.put(messageDto.getUserId().getBytes());
        buffer.position(20);
        buffer.put(messageDto.getFeeType().getBytes());
        buffer.position(21);
        buffer.put(messageDto.getUnitCost().getBytes());
        buffer.position(31);
        buffer.put(messageDto.getMsgGroupID().getBytes());
        buffer.position(51);
        buffer.put(messageDto.getUserMsgID().getBytes());
        buffer.position(71);
        buffer.put(messageDto.getServiceType().getBytes());
        buffer.position(72);
        buffer.put(messageDto.getSendStatus().getBytes());
        buffer.position(77);
        buffer.put(messageDto.getUserSender().getBytes());
        buffer.position(89);
        buffer.put(messageDto.getUserReceiver().getBytes());
        buffer.position(101);
        buffer.put(messageDto.getReserveDt().getBytes());
        buffer.position(116);
        buffer.put(messageDto.getRequestDt().getBytes());
        buffer.position(131);
        buffer.put(messageDto.getRemoteIP().getBytes());
        buffer.position(156);
        buffer.put(messageDto.getRouterSeq().getBytes());
    }

    public static void getBytesForCommonMessage(ByteBuffer buffer, BasicMessageDto messageDto) {
        byte[] destArray = null;
        if (buffer == null || messageDto == null) {
            return;
        }
        buffer.position(0);
        destArray = new byte[20];
        buffer.get(destArray);
        messageDto.setUserId(QueueConstants.getString((byte[])destArray));
        buffer.position(21);
        destArray = new byte[10];
        buffer.get(destArray);
        messageDto.setUnitCost(QueueConstants.getString((byte[])destArray));
        buffer.position(31);
        destArray = new byte[20];
        buffer.get(destArray);
        messageDto.setMsgGroupID(QueueConstants.getString((byte[])destArray));
        buffer.position(51);
        destArray = new byte[20];
        buffer.get(destArray);
        messageDto.setUserMsgID(QueueConstants.getString((byte[])destArray));
        buffer.position(71);
        destArray = new byte[1];
        buffer.get(destArray);
        messageDto.setServiceType(QueueConstants.getString((byte[])destArray));
        buffer.position(72);
        destArray = new byte[5];
        buffer.get(destArray);
        messageDto.setSendStatus(QueueConstants.getString((byte[])destArray));
        buffer.position(77);
        destArray = new byte[12];
        buffer.get(destArray);
        messageDto.setUserSender(QueueConstants.getString((byte[])destArray));
        buffer.position(89);
        destArray = new byte[12];
        buffer.get(destArray);
        messageDto.setUserReceiver(QueueConstants.getString((byte[])destArray));
        buffer.position(101);
        destArray = new byte[15];
        buffer.get(destArray);
        messageDto.setReserveDt(QueueConstants.getString((byte[])destArray));
        buffer.position(116);
        destArray = new byte[15];
        buffer.get(destArray);
        messageDto.setRequestDt(QueueConstants.getString((byte[])destArray));
        buffer.position(131);
        destArray = new byte[25];
        buffer.get(destArray);
        messageDto.setRemoteIP(QueueConstants.getString((byte[])destArray));
        buffer.position(156);
        destArray = new byte[5];
        buffer.get(destArray);
        messageDto.setRouterSeq(QueueConstants.getString((byte[])destArray));
    }

    public static void setBytesForSmsMessage(ByteBuffer buffer, BasicMessageDto messageDto) {
        buffer.position(161);
        buffer.put(messageDto.getUserMessage().getBytes());
    }

    public static void getBytesForSmsMessage(ByteBuffer buffer, BasicMessageDto messageDto) {
        byte[] destArray = null;
        if (buffer == null || messageDto == null) {
            return;
        }
        buffer.position(161);
        destArray = new byte[160];
        buffer.get(destArray);
        messageDto.setUserMessage(QueueConstants.getString((byte[])destArray));
    }

    public static void setBytesForMediaMessage(ByteBuffer buffer, BasicMessageDto messageDto) {
        buffer.position(161);
        buffer.put(messageDto.getUserSubject().getBytes());
        buffer.position(221);
        buffer.put(messageDto.getUserMessage().getBytes());
    }

    public static void setBytesForKakaoMessage(ByteBuffer buffer, BasicMessageDto messageDto) {
        buffer.position(161);
        buffer.put(messageDto.getUserSubject().getBytes());
        buffer.position(221);
        buffer.put(messageDto.getUserMessage().getBytes());
        buffer.position(2221);
        buffer.put(messageDto.getKakaoSenderKey().getBytes());
        buffer.position(2261);
        buffer.put(messageDto.getKakaoTemplateCode().getBytes());
        buffer.position(2325);
        buffer.put(messageDto.getKakaoJsonFile().getBytes());
    }

    public static void getBytesForKakaoMessage(ByteBuffer buffer, BasicMessageDto messageDto) {
        byte[] destArray = null;
        if (buffer == null || messageDto == null) {
            return;
        }
        buffer.position(161);
        destArray = new byte[60];
        buffer.get(destArray);
        messageDto.setUserSubject(QueueConstants.getString((byte[])destArray));
        buffer.position(221);
        destArray = new byte[2000];
        buffer.get(destArray);
        messageDto.setUserMessage(QueueConstants.getString((byte[])destArray));
        buffer.position(2221);
        destArray = new byte[40];
        buffer.get(destArray);
        messageDto.setKakaoSenderKey(QueueConstants.getString((byte[])destArray));
        buffer.position(2261);
        destArray = new byte[64];
        buffer.get(destArray);
        messageDto.setKakaoTemplateCode(QueueConstants.getString((byte[])destArray));
        buffer.position(2325);
        destArray = new byte[128];
        buffer.get(destArray);
        messageDto.setKakaoJsonFile(QueueConstants.getString((byte[])destArray));
    }

    public static void getBytesForMediaMessage(ByteBuffer buffer, BasicMessageDto messageDto) {
        byte[] destArray = null;
        if (buffer == null || messageDto == null) {
            return;
        }
        buffer.position(161);
        destArray = new byte[60];
        buffer.get(destArray);
        messageDto.setUserSubject(QueueConstants.getString((byte[])destArray));
        buffer.position(221);
        destArray = new byte[2000];
        buffer.get(destArray);
        messageDto.setUserMessage(QueueConstants.getString((byte[])destArray));
    }

    public static void setBytesForMmsMessage(ByteBuffer buffer, BasicMessageDto messageDto) {
        buffer.position(2221);
        buffer.put(Integer.toString(messageDto.getUserFileCnt()).getBytes());
        buffer.position(2222);
        if (messageDto.getUserFileName01() != null) {
            buffer.put(messageDto.getUserFileName01().getBytes());
        }
        buffer.position(2350);
        if (messageDto.getUserFileName02() != null) {
            buffer.put(messageDto.getUserFileName02().getBytes());
        }
        buffer.position(2478);
        if (messageDto.getUserFileName03() != null) {
            buffer.put(messageDto.getUserFileName03().getBytes());
        }
    }

    public static void getBytesForMmsMessage(ByteBuffer buffer, BasicMessageDto messageDto) {
        byte[] destArray = null;
        if (buffer == null || messageDto == null) {
            return;
        }
        buffer.position(2221);
        destArray = new byte[1];
        buffer.get(destArray);
        messageDto.setUserFileCnt(Integer.parseInt(QueueConstants.getString((byte[])destArray)));
        buffer.position(2222);
        destArray = new byte[128];
        buffer.get(destArray);
        messageDto.setUserFileName01(QueueConstants.getString((byte[])destArray));
        buffer.position(2350);
        destArray = new byte[128];
        buffer.get(destArray);
        messageDto.setUserFileName02(QueueConstants.getString((byte[])destArray));
        buffer.position(2478);
        destArray = new byte[128];
        buffer.get(destArray);
        messageDto.setUserFileName03(QueueConstants.getString((byte[])destArray));
    }

    public static int isValidateMessageForReport(ReportDto reportDto) {
        if (reportDto == null) {
            return ServiceCode.MSG_ERROR_REPORT.getCode();
        }
        if (reportDto.getAgentMsgId() == null || reportDto.getAgentMsgId().trim().isEmpty()) {
            return ServiceCode.MSG_ERROR_REPORT_MSG_ID.getCode();
        }
        if (reportDto.getAgentMsgId().trim().length() > 20) {
            return ServiceCode.MSG_ERROR_REPORT_MSG_ID.getCode();
        }
        if (reportDto.getAgentCode() == null || reportDto.getAgentCode().trim().isEmpty()) {
            return ServiceCode.MSG_ERROR_REPORT_AGENT_CODE.getCode();
        }
        if (reportDto.getAgentCode().trim().length() > 2) {
            return ServiceCode.MSG_ERROR_REPORT_AGENT_CODE.getCode();
        }
        if (reportDto.getRsltDate() == null || reportDto.getRsltDate().trim().isEmpty()) {
            return ServiceCode.MSG_ERROR_REPORT_SEND_TIME.getCode();
        }
        if (reportDto.getRsltDate().trim().length() > 14) {
            return ServiceCode.MSG_ERROR_REPORT_SEND_TIME.getCode();
        }
        if (reportDto.getRsltNet() == null || reportDto.getRsltNet().trim().isEmpty()) {
            return ServiceCode.MSG_ERROR_REPORT_TELECOM.getCode();
        }
        if (reportDto.getRsltNet().trim().length() > 3) {
            return ServiceCode.MSG_ERROR_REPORT_TELECOM.getCode();
        }
        if (reportDto.getRsltCode() == null || reportDto.getRsltCode().trim().isEmpty()) {
            return ServiceCode.MSG_ERROR_REPORT_RESULT.getCode();
        }
        if (reportDto.getRsltCode().trim().length() > 5) {
            return ServiceCode.MSG_ERROR_REPORT_RESULT.getCode();
        }
        return ServiceCode.OK.getCode();
    }

    public static int calcWritePositionForReport(int pushCounter, int dataByteLength) {
        return pushCounter < 0 ? 40 : 40 + pushCounter * dataByteLength;
    }

    public static void setBytesForReport(ByteBuffer buffer, ReportDto reportDto) {
        if (buffer == null || reportDto == null) {
            return;
        }
        Object destArray = null;
        buffer.position(0);
        buffer.put(reportDto.getAgentMsgId().getBytes());
        buffer.position(20);
        buffer.put(reportDto.getAgentCode().getBytes());
        buffer.position(22);
        buffer.put(reportDto.getRsltDate().getBytes());
        buffer.position(36);
        buffer.put(reportDto.getRsltNet().getBytes());
        buffer.position(39);
        buffer.put(reportDto.getRsltCode().getBytes());
    }

    public static ReportDto getReportFromBuffer(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        byte[] destArray = null;
        ReportDto reportDto = new ReportDto();
        buffer.position(0);
        destArray = new byte[20];
        buffer.get(destArray);
        reportDto.setMsgId(new String(destArray).trim());
        buffer.position(20);
        destArray = new byte[2];
        buffer.get(destArray);
        reportDto.setAgentCode(new String(destArray).trim());
        buffer.position(22);
        destArray = new byte[14];
        buffer.get(destArray);
        reportDto.setRsltDate(new String(destArray).trim());
        buffer.position(36);
        destArray = new byte[3];
        buffer.get(destArray);
        reportDto.setRsltNet(new String(destArray).trim());
        buffer.position(39);
        destArray = new byte[5];
        buffer.get(destArray);
        reportDto.setRsltCode(new String(destArray).trim());
        return reportDto;
    }
}

