/*
 * Decompiled with CFR 0.152.
 */
package com.munjaon.server.util;

import com.munjaon.server.util.SerialNoUtil;
import com.munjaon.server.util.dto.FileBaseDto;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
public final class JobFileFactory {
    private static final Logger log = LoggerFactory.getLogger(JobFileFactory.class);
    public static final Long MAX_LIMIT_BYTES = 0xA00000L;

    public static File getFile(String path) {
        if (path == null) {
            return null;
        }
        return new File(path);
    }

    public static File getFile(String path, String fileName) {
        return JobFileFactory.getFile((String)(path + File.separator + fileName));
    }

    private static boolean exist(File file) {
        return file.exists();
    }

    public static boolean exist(String path) {
        if (path == null) {
            return false;
        }
        log.info("path : {}", (Object)path);
        return new File(path).exists();
    }

    public static boolean exist(String path, String fileName) {
        return JobFileFactory.exist((String)(path + File.separator + fileName));
    }

    public static boolean isDirectory(String path, String fileName) {
        return JobFileFactory.getFile((String)path, (String)fileName).isDirectory();
    }

    public static boolean isDirectory(String path) {
        return JobFileFactory.getFile((String)path).isDirectory();
    }

    public static boolean isDirectory(File file) {
        return file.isDirectory();
    }

    public static boolean isFile(String path, String fileName) {
        return JobFileFactory.getFile((String)path, (String)fileName).isFile();
    }

    public static boolean isFile(String path) {
        return JobFileFactory.getFile((String)path).isFile();
    }

    public static boolean isFile(File file) {
        return file.isFile();
    }

    public static boolean deleteFile(String path, String fileName) {
        return JobFileFactory.getFile((String)path, (String)fileName).delete();
    }

    public static boolean deleteFile(String path) {
        return JobFileFactory.getFile((String)path).delete();
    }

    public static boolean deleteFile(File file) {
        return file.delete();
    }

    public static long fileSize(String path, String fileName) {
        return JobFileFactory.getFile((String)path, (String)fileName).length();
    }

    public static long fileSize(String path) {
        return JobFileFactory.getFile((String)path).length();
    }

    public static long fileSize(File file) {
        return file.length();
    }

    public static boolean makeMultiDirectory(String dirs) {
        return JobFileFactory.getFile((String)dirs).mkdirs();
    }

    public static boolean makeDirectory(String dir) {
        return JobFileFactory.getFile((String)dir).mkdir();
    }

    public static String getExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        if (fileName.lastIndexOf(".") >= 0) {
            return fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase();
        }
        return null;
    }

    public static String getExtension(File file) {
        return JobFileFactory.getExtension((String)file.getName());
    }

    public static String getFileName(String fileName) {
        if (fileName == null) {
            return null;
        }
        if (fileName.lastIndexOf(".") >= 0) {
            return fileName.substring(0, fileName.lastIndexOf("."));
        }
        return fileName;
    }

    public static String getFileName(File file) {
        return JobFileFactory.getFileName((String)file.getName());
    }

    public static String getSaveFileName(String fileName) {
        if (fileName != null && fileName.lastIndexOf(".") >= 0) {
            return LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")) + SerialNoUtil.getMultiAlphabet((int)3) + SerialNoUtil.getMultiNumeric((int)3) + SerialNoUtil.getMultiAlphabet((int)3) + SerialNoUtil.getMultiNumeric((int)7) + "." + JobFileFactory.getExtension((String)fileName);
        }
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")) + SerialNoUtil.getMultiAlphabet((int)3) + SerialNoUtil.getMultiNumeric((int)3) + SerialNoUtil.getMultiAlphabet((int)3) + SerialNoUtil.getMultiNumeric((int)7);
    }

    public static String getSaveFileName(File file) {
        return JobFileFactory.getSaveFileName((String)file.getName());
    }

    public static boolean transferFile(String srcDir, String srcFileName, String destDir) throws IOException {
        return JobFileFactory.transferFile((String)srcDir, (String)srcFileName, (String)destDir, (String)srcFileName);
    }

    public static boolean transferFile(String srcDir, String srcFileName, String destDir, String destFileName) throws IOException {
        if (JobFileFactory.exist((String)(srcDir + File.separator + srcFileName))) {
            if (!JobFileFactory.exist((String)destDir)) {
                JobFileFactory.makeMultiDirectory((String)destDir);
            }
            return JobFileFactory.transferFile((String)(srcDir + File.separator + srcFileName), (String)(destDir + File.separator + destFileName));
        }
        return false;
    }

    public static boolean transferFile(String srcPath, String destPath) throws IOException {
        return JobFileFactory.transferFile((File)new File(srcPath), (File)new File(destPath));
    }

    public static boolean transferFile(File srcFile, File destFile) throws IOException {
        log.info("srcFile : {}", (Object)srcFile);
        log.info("destFile : {}", (Object)destFile);
        FileInputStream fis = new FileInputStream(srcFile);
        FileOutputStream fos = new FileOutputStream(destFile);
        FileChannel inputChannel = fis.getChannel();
        FileChannel outputChannel = fos.getChannel();
        boolean transferStatus = false;
        if (inputChannel.size() > 0L) {
            transferStatus = true;
            inputChannel.transferTo(0L, inputChannel.size(), outputChannel);
        }
        fis.close();
        fos.close();
        return transferStatus;
    }

    public static void saveFileForByteBuffer(String path, String fileName, ByteBuffer buffer) throws IOException {
        FileChannel fileChannel = FileChannel.open(Paths.get(path + File.separator + fileName, new String[0]), StandardOpenOption.CREATE_NEW, StandardOpenOption.READ, StandardOpenOption.WRITE);
        fileChannel.write(buffer);
        fileChannel.close();
    }

    public static String getJobDirectory(String rootDirectory, String orderNo, String companyNo, String date) {
        return rootDirectory + File.separator + orderNo + File.separator + orderNo + "_" + companyNo + File.separator + date;
    }

    public static List<FileBaseDto> uploadMultiFile(String path, List<MultipartFile> listMultipartFile) throws IOException {
        return JobFileFactory.uploadMultiFileEnableExtension((String)path, listMultipartFile, null);
    }

    public static List<FileBaseDto> uploadMultiFileEnableExtension(String path, List<MultipartFile> listMultipartFile, String[] listEnableExtension) throws IOException {
        if (listMultipartFile == null || listMultipartFile.size() == 0) {
            return null;
        }
        ArrayList<FileBaseDto> listFile = null;
        for (MultipartFile multipartFile : listMultipartFile) {
            FileBaseDto fileBaseDto;
            if (multipartFile.isEmpty() || (fileBaseDto = JobFileFactory.uploadFileEnableExtension((String)path, (MultipartFile)multipartFile, (String[])listEnableExtension)) == null) continue;
            if (listFile == null) {
                listFile = new ArrayList<FileBaseDto>();
            }
            listFile.add(fileBaseDto);
        }
        return listFile;
    }

    public static FileBaseDto uploadFile(String path, MultipartFile multipartFile) throws IOException {
        return JobFileFactory.uploadFileEnableExtension((String)path, (MultipartFile)multipartFile, null);
    }

    public static FileBaseDto uploadFileEnableExtension(String path, MultipartFile multipartFile, String[] listEnableExtension) throws IOException {
        if (multipartFile == null || multipartFile.isEmpty()) {
            return null;
        }
        if (!JobFileFactory.exist((String)path)) {
            JobFileFactory.makeMultiDirectory((String)path);
        }
        boolean enableUpload = true;
        if (listEnableExtension != null && listEnableExtension.length > 0) {
            enableUpload = false;
            String extension = JobFileFactory.getExtension((String)multipartFile.getOriginalFilename());
            if (extension != null) {
                for (String enableExtension : listEnableExtension) {
                    if (!extension.equals(enableExtension)) continue;
                    enableUpload = true;
                    break;
                }
            }
        }
        FileBaseDto fileBaseDto = null;
        if (enableUpload) {
            fileBaseDto = new FileBaseDto();
            fileBaseDto.setOriginFileName(multipartFile.getOriginalFilename());
            fileBaseDto.setSaveFileName(JobFileFactory.getSaveFileName((String)multipartFile.getOriginalFilename()));
            fileBaseDto.setFileSize(multipartFile.getSize());
            String uploadPath = path + File.separator + fileBaseDto.getSaveFileName();
            File uploadFile = new File(uploadPath);
            multipartFile.transferTo(uploadFile);
        }
        return fileBaseDto;
    }

    public static Long uploadFileSize(MultipartFile multipartFile) {
        if (multipartFile == null || multipartFile.isEmpty()) {
            return -1L;
        }
        return multipartFile.getSize();
    }

    public static void main(String[] args) throws IOException {
        System.out.println();
        System.out.println("ext : " + JobFileFactory.getExtension((String)"test"));
        System.out.println("name : " + JobFileFactory.getFileName((String)"test"));
        System.out.println("name : " + JobFileFactory.getSaveFileName((String)"test.txt"));
        System.out.println("exist : " + JobFileFactory.exist((String)"C:\\uploads\\20231129\\30e718ce1445499a9ef1c4929310c87f.xlsx"));
        System.out.println("Now : " + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
    }
}

