/*
 * Decompiled with CFR 0.152.
 */
package com.munjaon.server.server.service;

import com.munjaon.server.queue.pool.ReportQueue;
import com.munjaon.server.server.dto.ConnectUserDto;
import com.munjaon.server.server.dto.ReportDto;
import com.munjaon.server.server.dto.ReportUserDto;
import com.munjaon.server.server.packet.Header;
import com.munjaon.server.server.packet.LinkCheck;
import com.munjaon.server.server.packet.Packet;
import com.munjaon.server.server.packet.Report;
import com.munjaon.server.server.queue.ReportUserQueue;
import com.munjaon.server.server.service.ReportServerService;
import com.munjaon.server.server.service.Service;
import com.munjaon.server.server.task.ReportReadTask;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.json.simple.JSONObject;

public class ReportServerService
extends Service {
    private final InetSocketAddress listenAddress;
    private ReadThreadService threadService;
    private final ReportUserQueue reportUserQueue = ReportUserQueue.getInstance();
    private Selector selector;
    private int readMaxCore = Integer.parseInt(this.getProp("READ_MAX_CORE").trim());
    private int queueMaxCore = Integer.parseInt(this.getProp("QUEUE_MAX_CORE").trim());

    public ReportServerService(String serviceName, int port) {
        super(serviceName);
        this.listenAddress = new InetSocketAddress(port);
    }

    public void checkReady() {
        this.IS_READY_YN = true;
    }

    public void initResources() {
        try {
            this.initReportChannel();
            this.threadService = new ReadThreadService(8, this.logger);
        }
        catch (IOException e) {
            this.saveSystemLog((Object)e);
            throw new RuntimeException(e);
        }
    }

    private void initReportChannel() throws IOException {
        this.selector = Selector.open();
        ServerSocketChannel serverChannel = ServerSocketChannel.open();
        serverChannel.configureBlocking(false);
        serverChannel.socket().bind(this.listenAddress);
        serverChannel.register(this.selector, 16);
    }

    private void closeReportChannel() throws IOException {
        this.selector.close();
    }

    public void releaseResources() {
        try {
            this.closeReportChannel();
            this.threadService.close();
        }
        catch (IOException e) {
            this.saveSystemLog((Object)e);
            throw new RuntimeException(e);
        }
    }

    public void doService() {
        while (this.isRun()) {
            try {
                this.execInterest();
                this.checkInterest();
            }
            catch (Exception e) {
                this.saveSystemLog((Object)e.toString());
            }
        }
    }

    private void checkInterest() throws IOException, InterruptedException {
        for (SelectionKey key : this.selector.keys()) {
            if (key.isValid()) {
                ReportUserDto reportUserDto = (ReportUserDto)key.attachment();
                if (reportUserDto == null) continue;
                SocketChannel channel = (SocketChannel)key.channel();
                if (reportUserDto.isAlive() == 1) {
                    if (reportUserDto.getUserId() != null) {
                        this.reportUserQueue.removeUser(reportUserDto.getUserId());
                    }
                    Socket socket = channel.socket();
                    channel.close();
                    socket.close();
                    key.attach(null);
                    key.cancel();
                    continue;
                }
                if (reportUserDto.isAlive() == 2) {
                    channel.write(LinkCheck.makeLinkCheckBuffer());
                    continue;
                }
                if (!reportUserDto.isLogin()) continue;
                ReportQueue reportQueue = reportUserDto.getReportQueue();
                try {
                    ReportDto reportDto = reportQueue.popReportFromQueue();
                    if (reportDto == null) {
                        this.saveSystemLog((Object)"reportQueue.popReportFromQueue() : null");
                        continue;
                    }
                    this.saveSystemLog((Object)("reportQueue.popReportFromQueue() : " + reportDto.toString()));
                    ByteBuffer reportBuffer = ByteBuffer.allocate(64);
                    Packet.setDefaultByte((ByteBuffer)reportBuffer);
                    Header.putHeader((ByteBuffer)reportBuffer, (String)"5", (int)54);
                    Report.putReport((ByteBuffer)reportBuffer, (ReportDto)reportDto);
                    channel.write(reportBuffer);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            this.expireConnectUser(key);
        }
    }

    private void execInterest() throws IOException {
        if (this.selector.select(1000L) == 0) {
            return;
        }
        Iterator<SelectionKey> keys = this.selector.selectedKeys().iterator();
        ArrayList<Future> list = new ArrayList<Future>();
        while (keys.hasNext()) {
            SelectionKey key = keys.next();
            keys.remove();
            if (key.isValid()) {
                if (key.isAcceptable()) {
                    this.saveSystemLog((Object)"isAcceptable");
                    this.accept(this.selector, key);
                    continue;
                }
                if (!key.isReadable()) continue;
                this.saveSystemLog((Object)"isReadable");
                Future future = this.threadService.submit(new ReportReadTask(this.selector, key, this.logger));
                list.add(future);
                continue;
            }
            this.expireConnectUser(key);
        }
        for (Future future : list) {
            ReportUserDto reportUserDto = null;
            try {
                reportUserDto = (ReportUserDto)future.get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
            if (reportUserDto == null) {
                this.saveSystemLog((Object)("Future : " + future));
                continue;
            }
            this.saveSystemLog((Object)("Future : " + reportUserDto.toString()));
        }
    }

    private void accept(Selector selector, SelectionKey key) {
        try {
            ServerSocketChannel serverChannel = (ServerSocketChannel)key.channel();
            SocketChannel channel = serverChannel.accept();
            channel.configureBlocking(false);
            Socket socket = channel.socket();
            SocketAddress remoteAddr = socket.getRemoteSocketAddress();
            this.saveSystemLog((Object)("Connected to: " + remoteAddr));
            channel.register(selector, 1, ReportUserDto.builder().lastTrafficTime(Long.valueOf(System.currentTimeMillis())).remoteIP(remoteAddr.toString()).queuePath(System.getProperty("ROOTPATH") + File.separator + this.getProp("QUEUE_PATH")).build());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void expireConnectUser(SelectionKey key) {
        if (key == null || !key.isValid()) {
            return;
        }
        try {
            SocketChannel channel = (SocketChannel)key.channel();
            ConnectUserDto userDto = (ConnectUserDto)key.attachment();
            if (userDto != null && userDto.getUserId() != null) {
                this.reportUserQueue.removeUser(userDto.getUserId());
                key.attach(null);
            }
            channel.close();
            key.cancel();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public JSONObject monitorService() {
        return null;
    }
}

