/*
 * Decompiled with CFR 0.152.
 */
package com.munjaon.server.queue.pool;

import com.munjaon.server.queue.dto.BasicMessageDto;
import com.munjaon.server.queue.pool.WriteQueue;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QueuePool {
    private static final Logger log = LoggerFactory.getLogger(QueuePool.class);
    protected final Object lockMonitor = new Object();
    protected final LinkedList<WriteQueue> queuePool = new LinkedList();
    protected WriteQueue queue = null;
    protected int queueIndex = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueueSize() {
        Object object = this.lockMonitor;
        synchronized (object) {
            return this.queuePool.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExistQueue(String name) {
        Object object = this.lockMonitor;
        synchronized (object) {
            boolean isExist = false;
            for (WriteQueue writeQueue : this.queuePool) {
                if (!name.equals(writeQueue.getQueueName())) continue;
                isExist = true;
                break;
            }
            return isExist;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQueue(String name) {
        Object object = this.lockMonitor;
        synchronized (object) {
            for (int loopCnt = 0; loopCnt < this.queuePool.size(); ++loopCnt) {
                this.queue = (WriteQueue)this.queuePool.get(loopCnt);
                if (!name.equals(this.queue.getQueueName())) continue;
                this.queuePool.remove(loopCnt);
                System.out.println("[" + this.queue.getQueueInfo().getServiceType() + " Queue] [" + this.queue.getQueueName() + " is Removed]");
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQueue(WriteQueue queue) {
        Object object = this.lockMonitor;
        synchronized (object) {
            if (queue != null) {
                this.queuePool.addLast(queue);
                this.lockMonitor.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushQueue(BasicMessageDto data) throws Exception {
        Object object = this.lockMonitor;
        synchronized (object) {
            if (this.queuePool.isEmpty()) {
                try {
                    this.lockMonitor.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.queueIndex >= this.queuePool.size()) {
                this.queueIndex = 0;
            }
            this.queue = (WriteQueue)this.queuePool.get(this.queueIndex);
            log.info("Adding queue : {}, Data : {}", (Object)this.queue.getQueueName(), (Object)data);
            this.queue.pushMessageToBuffer(data);
            ++this.queueIndex;
        }
    }
}

