/*
 * Decompiled with CFR 0.152.
 */
package com.munjaon.server.queue.pool;

import com.munjaon.server.config.ServiceCode;
import com.munjaon.server.server.dto.ReportDto;
import com.munjaon.server.util.FileUtil;
import com.munjaon.server.util.MessageUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class ReportQueue {
    private final Object lockObject = new Object();
    private String queuePathFile;
    private String userId;
    private int writeCounter = 0;
    private int readCounter = 0;
    private FileChannel channel = null;
    private ByteBuffer headBuffer = ByteBuffer.allocateDirect(40);
    private ByteBuffer bodyBuffer = ByteBuffer.allocateDirect(44);
    private byte[] byteArray = null;

    public ReportQueue(String queuePathFile, String userId) throws Exception {
        this.queuePathFile = queuePathFile;
        this.userId = userId;
        this.initQueue();
    }

    private void initQueue() throws Exception {
        FileUtil.mkdirs((String)this.queuePathFile);
        File file = new File(this.queuePathFile + File.separator + this.userId + ".queue");
        this.channel = new RandomAccessFile(file, "rw").getChannel();
        if (file.length() == 0L) {
            this.writeCounter = 0;
            this.readCounter = 0;
            this.writeHeader();
        } else {
            this.readHeader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushReportToQueue(ReportDto reportDto) throws Exception {
        Object object = this.lockObject;
        synchronized (object) {
            if (ServiceCode.OK.getCode() != MessageUtil.isValidateMessageForReport((ReportDto)reportDto)) {
                return;
            }
            this.initBodyBuffer();
            MessageUtil.setBytesForReport((ByteBuffer)this.bodyBuffer, (ReportDto)reportDto);
            this.readHeader();
            this.channel.position(MessageUtil.calcWritePositionForReport((int)this.writeCounter, (int)44));
            this.bodyBuffer.flip();
            this.channel.write(this.bodyBuffer);
            ++this.writeCounter;
            this.writeHeader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReportDto popReportFromQueue() throws Exception {
        Object object = this.lockObject;
        synchronized (object) {
            this.readHeader();
            if (this.writeCounter <= this.readCounter) {
                return null;
            }
            this.bodyBuffer.clear();
            this.channel.position(MessageUtil.calcWritePositionForReport((int)this.readCounter, (int)44));
            this.channel.read(this.bodyBuffer);
            return MessageUtil.getReportFromBuffer((ByteBuffer)this.bodyBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTruncateQueue(int maxWriteCount) {
        boolean truncate = false;
        Object object = this.lockObject;
        synchronized (object) {
            if (this.writeCounter >= maxWriteCount && this.writeCounter == this.readCounter) {
                truncate = true;
            }
        }
        return truncate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWriteLimit(int maxWriteCount) {
        boolean isLimit = false;
        Object object = this.lockObject;
        synchronized (object) {
            if (this.writeCounter >= maxWriteCount) {
                isLimit = true;
            }
        }
        return isLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncateQueue() throws Exception {
        Object object = this.lockObject;
        synchronized (object) {
            if (this.isOpen()) {
                this.channel.truncate(0L);
                this.writeCounter = 0;
                this.readCounter = 0;
                this.writeHeader();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readHeader() throws Exception {
        Object object = this.lockObject;
        synchronized (object) {
            this.initHeadBuffer();
            this.channel.position(0L);
            this.channel.read(this.headBuffer);
            this.byteArray = new byte[20];
            this.headBuffer.position(0);
            this.headBuffer.get(this.byteArray);
            this.userId = new String(this.byteArray).trim();
            this.byteArray = new byte[10];
            this.headBuffer.position(20);
            this.headBuffer.get(this.byteArray);
            this.writeCounter = Integer.parseInt(new String(this.byteArray).trim());
            this.byteArray = new byte[10];
            this.headBuffer.position(30);
            this.headBuffer.get(this.byteArray);
            this.readCounter = Integer.parseInt(new String(this.byteArray).trim());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReadCounter() throws Exception {
        Object object = this.lockObject;
        synchronized (object) {
            ++this.readCounter;
            this.initHeadBuffer();
            this.channel.position(0L);
            this.headBuffer.put(this.userId.getBytes());
            this.headBuffer.position(20);
            this.headBuffer.put(Integer.toString(this.writeCounter).getBytes());
            this.headBuffer.position(30);
            this.headBuffer.put(Integer.toString(this.readCounter).getBytes());
            this.headBuffer.flip();
            this.channel.write(this.headBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHeader() throws Exception {
        Object object = this.lockObject;
        synchronized (object) {
            this.initHeadBuffer();
            this.channel.position(0L);
            this.headBuffer.put(this.userId.getBytes());
            this.headBuffer.position(20);
            this.headBuffer.put(Integer.toString(this.writeCounter).getBytes());
            this.headBuffer.position(30);
            this.headBuffer.put(Integer.toString(this.readCounter).getBytes());
            this.headBuffer.flip();
            this.channel.write(this.headBuffer);
        }
    }

    private void initHeadBuffer() {
        this.headBuffer.clear();
        for (int loopCnt = 0; loopCnt < 40; ++loopCnt) {
            this.headBuffer.put((byte)32);
        }
        this.headBuffer.position(0);
    }

    public void initBodyBuffer() {
        this.bodyBuffer.clear();
        for (int loopCnt = 0; loopCnt < 44; ++loopCnt) {
            this.bodyBuffer.put((byte)0);
        }
        this.bodyBuffer.position(0);
    }

    public void close() throws IOException {
        if (this.isOpen()) {
            this.channel.close();
        }
    }

    public boolean isOpen() {
        if (this.channel == null) {
            return false;
        }
        return this.channel.isOpen();
    }

    public String getQueuePathFile() {
        return this.queuePathFile;
    }

    public String getUserId() {
        return this.userId;
    }

    public int getWriteCounter() {
        return this.writeCounter;
    }

    public int getReadCounter() {
        return this.readCounter;
    }
}

