/*
 * Decompiled with CFR 0.152.
 */
package com.munjaon.server.queue.pool;

import com.munjaon.server.queue.config.QueueConstants;
import com.munjaon.server.queue.dto.BasicMessageDto;
import com.munjaon.server.queue.dto.QueueInfo;
import com.munjaon.server.util.FileUtil;
import com.munjaon.server.util.MessageUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public abstract class ReadQueue {
    protected ByteBuffer headerBuffer = null;
    protected byte[] headerArray = null;
    protected String createDate;
    protected String readXMLDate;
    protected int popCounter = -1;
    protected int pushCounter = 0;
    protected String queuePath;
    protected FileChannel channel = null;
    protected FileOutputStream fileOutputStream = null;
    protected QueueInfo queueInfo = null;
    protected ByteBuffer dataBuffer = null;

    protected void initQueuePath() {
        this.queuePath = System.getProperty("ROOTPATH") + File.separator + this.queueInfo.getQueuePath();
        FileUtil.mkdirs((String)this.queuePath);
    }

    public void initReadQueue() throws IOException, JDOMException {
        this.queueInfo.setReadXMLFileName(this.queuePath + File.separator + this.queueInfo.getQueueName() + "_Read.xml");
        File file = new File(this.queueInfo.getReadXMLFileName());
        if (file.exists()) {
            this.readPopCounter(file);
        } else {
            this.readXMLDate = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
            this.popCounter = 0;
            this.writePopCounter();
        }
    }

    public void initPopCounter() throws IOException {
        this.initHeaderBuffer();
        this.readXMLDate = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        this.popCounter = 0;
        this.writePopCounter();
    }

    protected void readPopCounter(File file) throws IOException, JDOMException {
        SAXBuilder sax = new SAXBuilder();
        Document doc = sax.build(file);
        Element rootNode = doc.getRootElement();
        List childElements = rootNode.getChildren();
        for (Element child : childElements) {
            if ("createDate".equals(child.getName())) {
                this.readXMLDate = child.getValue();
            }
            if (!"popCounter".equals(child.getName())) continue;
            this.popCounter = Integer.parseInt(child.getValue());
        }
    }

    protected void readPopCounter() throws IOException, JDOMException {
        File file = new File(this.queueInfo.getReadXMLFileName());
        this.readPopCounter(file);
    }

    public void writePopCounter() throws IOException {
        SAXBuilder sb = new SAXBuilder();
        Document docFile = new Document();
        Element rootElement = new Element("ReadQueue");
        rootElement.addContent((Content)new Element("createDate").setText(this.readXMLDate));
        rootElement.addContent((Content)new Element("popCounter").setText(Integer.toString(this.popCounter)));
        docFile.setRootElement(rootElement);
        XMLOutputter xmlOutputter = new XMLOutputter(Format.getPrettyFormat());
        this.fileOutputStream = new FileOutputStream(this.queueInfo.getReadXMLFileName());
        xmlOutputter.output(docFile, (OutputStream)this.fileOutputStream);
    }

    public void initQueue() throws Exception {
        this.headerBuffer = ByteBuffer.allocateDirect(20);
        this.initQueuePath();
        this.queueInfo.setQueueFileName(this.queuePath + File.separator + this.queueInfo.getQueueName() + ".queue");
        File file = new File(this.queueInfo.getQueueFileName());
        if (!file.exists()) {
            throw new Exception(this.queueInfo.getQueueName() + "'s Queue is Not Exists!!");
        }
        this.channel = new RandomAccessFile(file, "r").getChannel();
        this.readHeader();
        this.initReadQueue();
    }

    protected void readHeader() throws Exception {
        this.initHeaderBuffer();
        this.channel.position(0L);
        this.channel.read(this.headerBuffer);
        this.headerArray = new byte[10];
        this.headerBuffer.position(0);
        this.headerBuffer.get(this.headerArray);
        this.createDate = QueueConstants.getString((byte[])this.headerArray);
        this.headerArray = new byte[10];
        this.headerBuffer.position(10);
        this.headerBuffer.get(this.headerArray);
        this.pushCounter = Integer.parseInt(QueueConstants.getString((byte[])this.headerArray));
    }

    protected void initHeaderBuffer() {
        this.headerBuffer.clear();
        for (int loopCnt = 0; loopCnt < 20; ++loopCnt) {
            this.headerBuffer.put((byte)0);
        }
        this.headerBuffer.position(0);
    }

    public void close() throws IOException {
        if (this.channel != null && this.channel.isOpen()) {
            this.channel.close();
        }
        if (this.fileOutputStream != null) {
            this.fileOutputStream.close();
        }
    }

    public BasicMessageDto popMessageFromBuffer() throws IOException, JDOMException, Exception {
        this.readHeader();
        this.readPopCounter();
        BasicMessageDto messageDto = null;
        if (this.popCounter < this.pushCounter) {
            this.initDataBuffer();
            this.popBuffer();
            messageDto = new BasicMessageDto();
            MessageUtil.getBytesForCommonMessage((ByteBuffer)this.dataBuffer, (BasicMessageDto)messageDto);
            this.getBytesForExtendMessage(messageDto);
            ++this.popCounter;
            this.writePopCounter();
        }
        return messageDto;
    }

    abstract void popBuffer() throws Exception;

    abstract void getBytesForExtendMessage(BasicMessageDto var1);

    abstract void initDataBuffer();

    public String getCreateDate() {
        return this.createDate;
    }

    public String getReadXMLDate() {
        return this.readXMLDate;
    }

    public int getPopCounter() {
        return this.popCounter;
    }

    public int getPushCounter() {
        return this.pushCounter;
    }

    public String getQueuePath() {
        return this.queuePath;
    }

    public QueueInfo getQueueInfo() {
        return this.queueInfo;
    }
}

