/*
 * Decompiled with CFR 0.152.
 */
package com.munjaon.server.server.service;

import com.munjaon.server.server.dto.ReportUserDto;
import com.munjaon.server.server.queue.ReportUserQueue;
import com.munjaon.server.server.service.ReportQueueServerService;
import com.munjaon.server.server.service.Service;
import com.munjaon.server.server.task.ReportQueueTask;
import java.util.List;
import org.json.simple.JSONObject;

public class ReportQueueServerService
extends Service {
    private final ReportUserQueue reportUserQueue = ReportUserQueue.getInstance();
    private QueueThreadService threadService;
    private int queueMaxCore = Integer.parseInt(this.getProp("QUEUE_MAX_CORE").trim());

    public ReportQueueServerService(String serviceName) {
        super(serviceName);
    }

    public void checkReady() {
        this.IS_READY_YN = true;
    }

    public void initResources() {
        this.threadService = new QueueThreadService(this.queueMaxCore, this.logger);
    }

    public void releaseResources() {
        this.threadService.close();
    }

    public void doService() {
        while (this.isRun()) {
            try {
                this.doQueueService();
                Thread.sleep(100L);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void doQueueService() {
        List reportUserList = this.reportUserQueue.getUsers();
        if (reportUserList == null || reportUserList.size() == 0) {
            return;
        }
        for (ReportUserDto reportUserDto : reportUserList) {
            this.threadService.execute(new ReportQueueTask(reportUserDto, this.logger));
        }
    }

    public JSONObject monitorService() {
        return null;
    }
}

