/*
 * Decompiled with CFR 0.152.
 */
package com.munjaon.server.queue.service;

import com.munjaon.server.cache.service.SerialNoService;
import com.munjaon.server.queue.dto.BasicMessageDto;
import com.munjaon.server.queue.mapper.SmsMapper;
import com.munjaon.server.queue.pool.SmsMemoryQueue;
import com.munjaon.server.queue.pool.SmsQueuePool;
import com.munjaon.server.queue.pool.WriteQueue;
import com.munjaon.server.queue.service.QueueAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SmsQueueService
implements QueueAction {
    private static final Logger log = LoggerFactory.getLogger(SmsQueueService.class);
    private final SmsMapper smsMapper;
    private final SmsQueuePool queueInstance = SmsQueuePool.getInstance();
    private final SmsMemoryQueue memoryQueue = SmsMemoryQueue.getInstance();
    private final SerialNoService serialNoService;

    public int getQueueSize() {
        return this.queueInstance.getQueueSize();
    }

    public boolean isExistQueue(String name) {
        return this.queueInstance.isExistQueue(name);
    }

    public void removeQueue(String name) {
        this.queueInstance.removeQueue(name);
    }

    public void addQueue(WriteQueue queue) {
        this.queueInstance.addQueue(queue);
    }

    public void pushQueue(BasicMessageDto data) {
        boolean isError = false;
        try {
            this.queueInstance.pushQueue(data);
        }
        catch (Exception e) {
            isError = true;
        }
        if (isError) {
            log.error("Push queue failed");
        }
    }

    public int saveMessageToTable(BasicMessageDto data) {
        String serialNo = this.serialNoService.getSerialNo();
        String groupSerialNo = serialNo.replace("MSGID", "MGRP");
        data.setId(serialNo);
        data.setMsgGroupID(groupSerialNo);
        log.debug("Save message to table : {}", (Object)data);
        return this.smsMapper.insert(data);
    }

    public void memoryEnQueue(BasicMessageDto data) {
        this.memoryQueue.memoryEnQueue(data);
    }

    public BasicMessageDto memoryDeQueue() {
        return this.memoryQueue.memoryDeQueue();
    }

    public int getMemorySize() {
        return this.memoryQueue.getMemorySize();
    }

    public boolean isMemoryEmpty() {
        return this.memoryQueue.isMemoryEmpty();
    }

    public SmsQueueService(SmsMapper smsMapper, SerialNoService serialNoService) {
        this.smsMapper = smsMapper;
        this.serialNoService = serialNoService;
    }
}

