/*
 * Decompiled with CFR 0.152.
 */
package com.munjaon.server.queue.pool;

import com.munjaon.server.config.ServiceCode;
import com.munjaon.server.queue.dto.BasicMessageDto;
import com.munjaon.server.queue.dto.QueueInfo;
import com.munjaon.server.queue.pool.WriteQueue;
import com.munjaon.server.util.MessageUtil;
import java.nio.ByteBuffer;

public class SmsWriteQueue
extends WriteQueue {
    public SmsWriteQueue(QueueInfo queueInfo) throws Exception {
        this.queueInfo = queueInfo;
    }

    public int isValidateMessageForExtend(BasicMessageDto messageDto) {
        if (MessageUtil.isEmptyForMessage((String)messageDto.getUserMessage(), (boolean)true) || MessageUtil.isOverByteForMessage((String)messageDto.getUserMessage(), (int)160, (boolean)false)) {
            return ServiceCode.MSG_ERROR_SMS_MESSAGE.getCode();
        }
        return ServiceCode.OK.getCode();
    }

    public void pushMessageToBuffer(BasicMessageDto messageDto) throws Exception {
        if (this.isValidateMessage(messageDto) == ServiceCode.OK.getCode().intValue()) {
            this.initDataBuffer();
            MessageUtil.setBytesForCommonMessage((ByteBuffer)this.dataBuffer, (BasicMessageDto)messageDto);
            MessageUtil.setBytesForSmsMessage((ByteBuffer)this.dataBuffer, (BasicMessageDto)messageDto);
            this.readHeader();
            if (this.dataBuffer != null) {
                this.channel.position(MessageUtil.calcWritePosition((int)this.pushCounter, (int)321));
                this.dataBuffer.flip();
                this.channel.write(this.dataBuffer);
                ++this.pushCounter;
                this.writeHeader();
            }
        }
    }

    public void initDataBuffer() {
        if (this.dataBuffer == null) {
            this.dataBuffer = ByteBuffer.allocateDirect(321);
        }
        this.dataBuffer.clear();
        for (int loopCnt = 0; loopCnt < 321; ++loopCnt) {
            this.dataBuffer.put((byte)0);
        }
        this.dataBuffer.position(0);
    }
}

