/*
 * Decompiled with CFR 0.152.
 */
package com.munjaon.server.util;

import java.nio.ByteBuffer;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ByteUtil {
    public static final int BYTE_SIZE = 128;
    public static final byte SET_DEFAULT_BYTE = 0;

    public static String byteToHex(byte[] src, boolean isLine) {
        Object hex = "";
        hex = "";
        int i = 0;
        int j = 1;
        while (i < src.length) {
            hex = (String)hex + ByteUtil.pad0((String)Integer.toHexString(src[i] & 0xFF), (int)2) + " ";
            if (isLine && src.length > 16 && j % 16 == 0) {
                hex = (String)hex + "\r\n";
            }
            ++i;
            ++j;
        }
        return hex;
    }

    public static String byteToHex(byte[] src) {
        Object hex = "";
        int i = 0;
        int j = 1;
        while (i < src.length) {
            hex = (String)hex + ByteUtil.pad0((String)Integer.toHexString(src[i] & 0xFF), (int)2) + " ";
            if (src.length > 16 && j % 16 == 0) {
                hex = (String)hex + "\r\n";
            }
            ++i;
            ++j;
        }
        return hex;
    }

    public static String byteToHex(byte[] src, int srcPos, int length) {
        Object hex = "";
        hex = "\r\n";
        int i = srcPos;
        int j = 1;
        while (i < srcPos + length) {
            hex = (String)hex + ByteUtil.pad0((String)Integer.toHexString(src[i] & 0xFF), (int)2) + " ";
            if (src.length > 16 && j % 16 == 0) {
                hex = (String)hex + "\r\n";
            }
            ++i;
            ++j;
        }
        return hex;
    }

    public static String intToHex(int src) {
        Object hex = "0x";
        byte[] bSrc = ByteUtil.intToByte((int)src);
        int i = 0;
        int j = 1;
        while (i < bSrc.length) {
            hex = (String)hex + ByteUtil.pad0((String)Integer.toHexString(bSrc[i] & 0xFF), (int)2);
            ++i;
            ++j;
        }
        return hex;
    }

    public static byte[] shortToByte(short s) {
        byte[] dest = new byte[2];
        dest[1] = (byte)(s & 0xFF);
        dest[0] = (byte)(s >>> 8 & 0xFF);
        return dest;
    }

    public static byte[] intToByte(int i) {
        byte[] dest = new byte[4];
        dest[3] = (byte)(i & 0xFF);
        dest[2] = (byte)(i >>> 8 & 0xFF);
        dest[1] = (byte)(i >>> 16 & 0xFF);
        dest[0] = (byte)(i >>> 24 & 0xFF);
        return dest;
    }

    public static byte[] longToByte(long l) {
        byte[] dest = new byte[8];
        dest[7] = (byte)(l & 0xFFL);
        dest[6] = (byte)(l >>> 8 & 0xFFL);
        dest[5] = (byte)(l >>> 16 & 0xFFL);
        dest[4] = (byte)(l >>> 24 & 0xFFL);
        dest[3] = (byte)(l >>> 32 & 0xFFL);
        dest[2] = (byte)(l >>> 40 & 0xFFL);
        dest[1] = (byte)(l >>> 48 & 0xFFL);
        dest[0] = (byte)(l >>> 56 & 0xFFL);
        return dest;
    }

    public static byte[] floatToByte(float f) {
        byte[] dest = new byte[4];
        return ByteUtil.setFloat((byte[])dest, (int)0, (float)f);
    }

    public static byte[] doubleToByte(double d) {
        byte[] dest = new byte[8];
        return ByteUtil.setDouble((byte[])dest, (int)0, (double)d);
    }

    public static byte getByte(byte[] src, int offset) {
        return src[offset];
    }

    public static byte[] getBytes(String data) {
        byte[] b = null;
        b = data.getBytes();
        return b;
    }

    public static byte[] getBytes(byte[] src, int offset, int length) {
        byte[] dest = new byte[length];
        System.arraycopy(src, offset, dest, 0, length);
        return dest;
    }

    public static short getShort(byte[] src, int offset) {
        return (short)((src[offset] & 0xFF) << 8 | src[offset + 1] & 0xFF);
    }

    public static int getInt(byte[] src, int offset) {
        return (src[offset] & 0xFF) << 24 | (src[offset + 1] & 0xFF) << 16 | (src[offset + 2] & 0xFF) << 8 | src[offset + 3] & 0xFF;
    }

    public static long getLong(byte[] src, int offset) {
        return (long)ByteUtil.getInt((byte[])src, (int)offset) << 32 | (long)ByteUtil.getInt((byte[])src, (int)(offset + 4)) & 0xFFFFFFFFL;
    }

    public static float getfloat(byte[] src, int offset) {
        return Float.intBitsToFloat(ByteUtil.getInt((byte[])src, (int)offset));
    }

    public static double getdouble(byte[] src, int offset) {
        return Double.longBitsToDouble(ByteUtil.getLong((byte[])src, (int)offset));
    }

    public static byte[] setByte(byte[] dest, int offset, byte b) {
        dest[offset] = b;
        return dest;
    }

    public static void setBytes(byte[] dest, int offset, String s) {
        ByteUtil.setBytes((byte[])dest, (int)offset, (byte[])s.getBytes());
    }

    public static byte[] setBytes(byte[] dest, int offset, byte[] src) {
        System.arraycopy(src, 0, dest, offset, src.length);
        return dest;
    }

    public static byte[] setBytes(byte[] dest, int offset, byte[] src, int len) {
        System.arraycopy(src, 0, dest, offset, len);
        return dest;
    }

    public static byte[] setShort(byte[] dest, int offset, short s) {
        dest[offset] = (byte)(s >>> 8 & 0xFF);
        dest[offset + 1] = (byte)(s & 0xFF);
        return dest;
    }

    public static byte[] setInt(byte[] dest, int offset, int i) {
        dest[offset] = (byte)(i >>> 24 & 0xFF);
        dest[offset + 1] = (byte)(i >>> 16 & 0xFF);
        dest[offset + 2] = (byte)(i >>> 8 & 0xFF);
        dest[offset + 3] = (byte)(i & 0xFF);
        return dest;
    }

    public static byte[] setLong(byte[] dest, int offset, long l) {
        ByteUtil.setInt((byte[])dest, (int)offset, (int)((int)(l >>> 32)));
        ByteUtil.setInt((byte[])dest, (int)(offset + 4), (int)((int)(l & 0xFFFFFFFFL)));
        return dest;
    }

    public static byte[] setFloat(byte[] dest, int offset, float f) {
        return ByteUtil.setInt((byte[])dest, (int)offset, (int)Float.floatToIntBits(f));
    }

    public static byte[] setDouble(byte[] dest, int offset, double d) {
        return ByteUtil.setLong((byte[])dest, (int)offset, (long)Double.doubleToLongBits(d));
    }

    public static boolean isEquals(byte[] b, String s) {
        if (b == null || s == null) {
            return false;
        }
        int slen = s.length();
        if (b.length != slen) {
            return false;
        }
        int i = slen;
        while (i-- > 0) {
            if (b[i] == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEquals(byte[] a, byte[] b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        int i = a.length;
        while (i-- > 0) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static int hexToInt(byte[] b) {
        int sum = 0;
        int len = 0;
        int pos = 0;
        if (b != null) {
            len = b.length;
            for (int i = len - 1; i > 0; --i) {
                sum += ByteUtil.sqrt((int)128, (int)i) * b[pos];
                ++pos;
            }
            sum += b[pos];
        }
        return sum;
    }

    public static int hexToInt(byte[] b, int start, int len) {
        int sum = 0;
        int pos = start;
        if (b != null) {
            for (int i = len - 1; i > 0; --i) {
                sum += ByteUtil.sqrt((int)128, (int)i) * b[pos];
                ++pos;
            }
            sum += b[pos];
        }
        return sum;
    }

    public static byte[] intToHex(int num, int digit) {
        byte[] b = new byte[digit];
        int[] intArr = ByteUtil.makeFunction((int)num, (int)digit, (int)128);
        for (int i = 0; i < digit; ++i) {
            b[i] = (byte)intArr[i];
        }
        return b;
    }

    private static int[] makeFunction(int num, int digit, int jinso) {
        int[] fun = new int[digit];
        int restNum = num;
        int pos = 0;
        for (int i = digit - 1; i > 0; --i) {
            int quotient = restNum / ByteUtil.sqrt((int)jinso, (int)i);
            fun[pos++] = quotient;
            restNum -= quotient * ByteUtil.sqrt((int)jinso, (int)i);
        }
        fun[pos++] = restNum;
        return fun;
    }

    private static int sqrt(int num, int count) {
        int sum = 0;
        sum = count >= 1 ? num : 0;
        for (int i = 1; i < count; ++i) {
            sum *= num;
        }
        return sum;
    }

    public static boolean arrayComp(byte[] src, byte[] obj) {
        boolean isSame = true;
        if (src.length != obj.length) {
            isSame = false;
        } else {
            for (int i = 0; i < src.length; ++i) {
                if (src[i] == obj[i]) continue;
                isSame = false;
                break;
            }
        }
        return isSame;
    }

    public static String pad0(String str, int size) {
        char[] zeros = new char[size - str.length()];
        for (int i = 0; i < zeros.length; ++i) {
            zeros[i] = 48;
        }
        return new String(zeros) + str;
    }

    public static byte[] convertCharArrayToByteArray(char[] ca) {
        byte[] ba = new byte[ca.length * 2];
        ByteBuffer.wrap(ba).asCharBuffer().put(ca);
        return ba;
    }

    public static char[] convertByteArrayToCharArray(byte[] ba) {
        char[] ca = new char[ba.length / 2];
        ByteBuffer.wrap(ba).asCharBuffer().get(ca);
        return ca;
    }

    public static byte[] setNull(byte[] b) {
        for (int i = 0; i < b.length; ++i) {
            b[i] = 0;
        }
        return b;
    }

    public static int toInt(byte[] value) {
        return value[3] & 0xFF | (value[2] & 0xFF) << 8 | (value[1] & 0xFF) << 16 | (value[0] & 0xFF) << 24;
    }

    public static byte[] toBytes(int value) {
        byte[] ret = new byte[4];
        ret[3] = (byte)(value & 0xFF);
        ret[2] = (byte)(value >> 8 & 0xFF);
        ret[1] = (byte)(value >> 16 & 0xFF);
        ret[0] = (byte)(value >> 24 & 0xFF);
        return ret;
    }

    public static int toInt2(byte[] value) {
        return value[0] & 0xFF | (value[1] & 0xFF) << 8 | (value[2] & 0xFF) << 16 | (value[3] & 0xFF) << 24;
    }

    public static byte[] toBytes2(int value) {
        byte[] ret = new byte[]{(byte)(value & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 24 & 0xFF)};
        return ret;
    }

    public static byte[] setSpaceAll(byte[] data) {
        return ByteUtil.setAll((byte[])data, (byte)32);
    }

    public static byte[] setAll(byte[] data, byte bt) {
        int len = data.length;
        for (int i = 0; i < len; ++i) {
            data[i] = bt;
        }
        return data;
    }

    public static byte[] replaceAll(byte[] data, byte from, byte to) {
        int len = data.length;
        for (int i = 0; i < len; ++i) {
            if (data[i] != from) continue;
            data[i] = to;
        }
        return data;
    }
}

