/*
 * Decompiled with CFR 0.152.
 */
package com.munjaon.server.server.service;

import com.munjaon.server.queue.enums.QueueTypeWorker;
import com.munjaon.server.server.dto.ConnectUserDto;
import com.munjaon.server.server.queue.CollectUserQueue;
import com.munjaon.server.server.service.CollectServerService;
import com.munjaon.server.server.service.Service;
import com.munjaon.server.server.task.CollectReadTask;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.json.simple.JSONObject;

public class CollectServerService
extends Service {
    private final InetSocketAddress listenAddress;
    private CollectThreadService threadService;
    private CollectUserQueue collectUserQueue = CollectUserQueue.getInstance();
    private Selector selector;
    private final String serviceType;
    private int readMaxCore = Integer.parseInt(this.getProp("READ_MAX_CORE").trim());

    public CollectServerService(String serviceName, String serviceType, int port) {
        super(serviceName);
        this.listenAddress = new InetSocketAddress(port);
        this.serviceType = serviceType;
    }

    public void checkReady() {
        QueueTypeWorker worker = QueueTypeWorker.find((String)this.serviceType);
        this.IS_READY_YN = worker != null && worker.getQueueSize() > 0;
        this.saveSystemLog((Object)("CollectServerService ready : " + this.IS_READY_YN));
    }

    public void initResources() {
        try {
            this.initCollectChannel();
            this.threadService = new CollectThreadService(this.readMaxCore, this.serviceType, this.logger);
        }
        catch (IOException e) {
            this.saveSystemLog((Object)e);
            throw new RuntimeException(e);
        }
    }

    private void initCollectChannel() throws IOException {
        this.selector = Selector.open();
        ServerSocketChannel serverChannel = ServerSocketChannel.open();
        serverChannel.configureBlocking(false);
        serverChannel.socket().bind(this.listenAddress);
        serverChannel.register(this.selector, 16);
    }

    private void closeCollectChannel() throws IOException {
        this.selector.close();
    }

    public void releaseResources() {
        try {
            this.closeCollectChannel();
            this.threadService.close();
        }
        catch (IOException e) {
            this.saveSystemLog((Object)e);
            throw new RuntimeException(e);
        }
    }

    public void doService() {
        while (this.isRun()) {
            try {
                this.execInterest();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void execInterest() throws IOException {
        if (this.selector.select(1000L) == 0) {
            return;
        }
        Iterator<SelectionKey> keys = this.selector.selectedKeys().iterator();
        ArrayList<Future> list = new ArrayList<Future>();
        while (keys.hasNext()) {
            SelectionKey key = keys.next();
            keys.remove();
            if (key.isValid()) {
                if (key.isAcceptable()) {
                    this.saveSystemLog((Object)"isAcceptable");
                    this.accept(this.selector, key);
                    continue;
                }
                if (!key.isReadable()) continue;
                this.saveSystemLog((Object)"isReadable");
                Future future = this.threadService.submit(new CollectReadTask(this.selector, key, this.serviceType, this.logger));
                list.add(future);
                continue;
            }
            this.expireConnectUser(key);
        }
        for (Future future : list) {
            ConnectUserDto connectUserDto = null;
            try {
                connectUserDto = (ConnectUserDto)future.get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
            if (connectUserDto == null) {
                this.saveSystemLog((Object)("Future : " + future));
                continue;
            }
            this.saveSystemLog((Object)("Future : " + connectUserDto.toString()));
        }
    }

    private void accept(Selector selector, SelectionKey key) {
        try {
            ServerSocketChannel serverChannel = (ServerSocketChannel)key.channel();
            SocketChannel channel = serverChannel.accept();
            channel.configureBlocking(false);
            Socket socket = channel.socket();
            SocketAddress remoteAddr = socket.getRemoteSocketAddress();
            this.saveSystemLog((Object)("Connected to: " + remoteAddr));
            channel.register(selector, 1, ConnectUserDto.builder().serviceType(this.serviceType).lastTrafficTime(Long.valueOf(System.currentTimeMillis())).remoteIP(remoteAddr.toString()).build());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void expireConnectUser(SelectionKey key) {
        if (key == null || !key.isValid()) {
            return;
        }
        try {
            SocketChannel channel = (SocketChannel)key.channel();
            ConnectUserDto userDto = (ConnectUserDto)key.attachment();
            if (userDto != null && userDto.getUserId() != null) {
                this.collectUserQueue.removeUser(this.serviceType, userDto.getUserId());
                key.attach(null);
            }
            channel.close();
            key.cancel();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public JSONObject monitorService() {
        return null;
    }
}

