/*
 * Decompiled with CFR 0.152.
 */
package com.munjaon.server.server.packet;

import com.munjaon.server.server.packet.Packet;
import com.munjaon.server.util.CommonUtil;
import java.nio.ByteBuffer;

public final class CommonMessage {
    public static final int DELIVER_MESSAGE_ID_LENGTH = 20;
    public static final int DELIVER_MESSAGE_ID_POSITION = 10;
    public static final int DELIVER_SENDER_LENGTH = 15;
    public static final int DELIVER_SENDER_POSITION = 30;
    public static final int DELIVER_RECEIVER_LENGTH = 15;
    public static final int DELIVER_RECEIVER_POSITION = 45;
    public static final int DELIVER_RESERVE_TIME_LENGTH = 14;
    public static final int DELIVER_RESERVE_TIME_POSITION = 60;
    public static final int DELIVER_REQUEST_TIME_LENGTH = 14;
    public static final int DELIVER_REQUEST_TIME_POSITION = 74;
    public static final int DELIVER_MSG_TYPE_LENGTH = 1;
    public static final int DELIVER_MSG_TYPE_POSITION = 88;
    public static final int DELIVER_ACK_MESSAGE_ID_LENGTH = 20;
    public static final int DELIVER_ACK_MESSAGE_ID_POSITION = 10;
    public static final int DELIVER_ACK_RESULT_LENGTH = 1;
    public static final int DELIVER_ACK_RESULT_POSITION = 30;

    public static void putMessageIdForDeliver(ByteBuffer buffer, String messageId) {
        if (buffer == null || messageId == null) {
            return;
        }
        buffer.put(10, messageId.getBytes());
    }

    public static String getMessageIdForDeliver(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        buffer.position(10);
        byte[] destArray = new byte[20];
        buffer.get(destArray);
        return Packet.getString((byte[])destArray);
    }

    public static void putSenderForDeliver(ByteBuffer buffer, String sender) {
        if (buffer == null || sender == null) {
            return;
        }
        sender = CommonUtil.cutString((String)CommonUtil.doNumber((String)sender), (int)15);
        buffer.put(30, sender.getBytes());
    }

    public static String getSenderForDeliver(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        buffer.position(30);
        byte[] destArray = new byte[15];
        buffer.get(destArray);
        return Packet.getString((byte[])destArray);
    }

    public static void putReceiverForDeliver(ByteBuffer buffer, String receiver) {
        if (buffer == null || receiver == null) {
            return;
        }
        receiver = CommonUtil.cutString((String)CommonUtil.doNumber((String)receiver), (int)15);
        buffer.put(45, receiver.getBytes());
    }

    public static String getReceiverForDeliver(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        buffer.position(45);
        byte[] destArray = new byte[15];
        buffer.get(destArray);
        return Packet.getString((byte[])destArray);
    }

    public static void putReserveTimeForDeliver(ByteBuffer buffer, String reserveTime) {
        if (buffer == null || reserveTime == null) {
            return;
        }
        buffer.put(60, reserveTime.getBytes());
    }

    public static String getReserveTimeForDeliver(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        buffer.position(60);
        byte[] destArray = new byte[14];
        buffer.get(destArray);
        return Packet.getString((byte[])destArray);
    }

    public static void putRequestTimeForDeliver(ByteBuffer buffer, String requestTime) {
        if (buffer == null || requestTime == null) {
            return;
        }
        buffer.put(74, requestTime.getBytes());
    }

    public static String getRequestTimeForDeliver(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        buffer.position(74);
        byte[] destArray = new byte[14];
        buffer.get(destArray);
        return Packet.getString((byte[])destArray);
    }

    public static void putMsgTypeForDeliver(ByteBuffer buffer, String msgType) {
        if (buffer == null || msgType == null) {
            return;
        }
        buffer.put(88, msgType.getBytes());
    }

    public static String getMsgTypeForDeliver(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        buffer.position(88);
        byte[] destArray = new byte[1];
        buffer.get(destArray);
        return Packet.getString((byte[])destArray);
    }

    public static void putMessageIdForDeliverAck(ByteBuffer buffer, String messageId) {
        if (buffer == null || messageId == null) {
            return;
        }
        buffer.put(10, messageId.getBytes());
    }

    public static String getMessageIdForDeliverAck(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        buffer.position(10);
        byte[] destArray = new byte[20];
        buffer.get(destArray);
        return Packet.getString((byte[])destArray);
    }

    public static void putResultForDeliverAck(ByteBuffer buffer, String result) {
        if (buffer == null || result == null) {
            return;
        }
        buffer.put(30, result.getBytes());
    }

    public static String getResultForDeliverAck(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        buffer.position(30);
        byte[] destArray = new byte[1];
        buffer.get(destArray);
        return Packet.getString((byte[])destArray);
    }
}

