/*
 * Decompiled with CFR 0.152.
 */
package com.munjaon.server.server.dto;

import com.munjaon.server.cache.dto.MemberDto;
import com.munjaon.server.server.dto.ConnectUserDto;
import java.util.Objects;

public class ConnectUserDto {
    private boolean isLogin;
    private Long lastTrafficTime;
    private String serviceType;
    private String userId;
    private String remoteIP;
    private final String feeType = "A";
    private int command;
    private MemberDto memberDto;

    public int isAlive() {
        if (this.isLogin) {
            if (System.currentTimeMillis() - this.lastTrafficTime > 10000L) {
                return 2;
            }
        } else if (System.currentTimeMillis() - this.lastTrafficTime > 5000L) {
            return 1;
        }
        return 0;
    }

    public void updateLastTrafficTime() {
        this.lastTrafficTime = System.currentTimeMillis();
    }

    ConnectUserDto(boolean isLogin, Long lastTrafficTime, String serviceType, String userId, String remoteIP, int command, MemberDto memberDto) {
        this.isLogin = isLogin;
        this.lastTrafficTime = lastTrafficTime;
        this.serviceType = serviceType;
        this.userId = userId;
        this.remoteIP = remoteIP;
        this.command = command;
        this.memberDto = memberDto;
    }

    public static ConnectUserDtoBuilder builder() {
        return new ConnectUserDtoBuilder();
    }

    public boolean isLogin() {
        return this.isLogin;
    }

    public Long getLastTrafficTime() {
        return this.lastTrafficTime;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getRemoteIP() {
        return this.remoteIP;
    }

    public String getFeeType() {
        Objects.requireNonNull(this);
        return "A";
    }

    public int getCommand() {
        return this.command;
    }

    public MemberDto getMemberDto() {
        return this.memberDto;
    }

    public void setLogin(boolean isLogin) {
        this.isLogin = isLogin;
    }

    public void setLastTrafficTime(Long lastTrafficTime) {
        this.lastTrafficTime = lastTrafficTime;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setRemoteIP(String remoteIP) {
        this.remoteIP = remoteIP;
    }

    public void setCommand(int command) {
        this.command = command;
    }

    public void setMemberDto(MemberDto memberDto) {
        this.memberDto = memberDto;
    }

    public String toString() {
        return "ConnectUserDto(isLogin=" + this.isLogin() + ", lastTrafficTime=" + this.getLastTrafficTime() + ", serviceType=" + this.getServiceType() + ", userId=" + this.getUserId() + ", remoteIP=" + this.getRemoteIP() + ", feeType=" + this.getFeeType() + ", command=" + this.getCommand() + ", memberDto=" + this.getMemberDto() + ")";
    }
}

