/*
 * Decompiled with CFR 0.152.
 */
package com.munjaon.server.config;

import jakarta.annotation.PostConstruct;
import java.io.File;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.ConfigurationBuilderEvent;
import org.apache.commons.configuration2.builder.ReloadingFileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.reloading.PeriodicReloadingTrigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ServerConfig {
    private static final Logger log = LoggerFactory.getLogger(ServerConfig.class);
    @Value(value="${agent.server-property-file}")
    private String serverProperyFile;
    @Value(value="${agent.root-path}")
    private String serverRootPath;
    private ReloadingFileBasedConfigurationBuilder<PropertiesConfiguration> builder;

    @PostConstruct
    void init() throws ConfigurationException {
        log.info("serverProperyFile : {}", (Object)this.serverProperyFile);
        this.builder = new ReloadingFileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)new Parameters().fileBased().setFile(new File(this.serverProperyFile))});
        this.builder.addEventListener(ConfigurationBuilderEvent.CONFIGURATION_REQUEST, (EventListener)new /* Unavailable Anonymous Inner Class!! */);
        PeriodicReloadingTrigger configReloadingTrigger = new PeriodicReloadingTrigger(this.builder.getReloadingController(), null, 1L, TimeUnit.SECONDS);
        configReloadingTrigger.start();
    }

    public String getString(String key) throws ConfigurationException {
        return ((PropertiesConfiguration)this.builder.getConfiguration()).getString(key);
    }

    public int getInt(String key) throws ConfigurationException {
        return ((PropertiesConfiguration)this.builder.getConfiguration()).getInt(key, 3);
    }

    public String[] getStringArray(String key) throws ConfigurationException {
        return this.getStringArray(key, ",");
    }

    public String[] getStringArray(String key, String regExp) throws ConfigurationException {
        String value = this.getString(key);
        return value == null ? null : value.split(regExp);
    }

    public String getServerProperyFile() {
        return this.serverProperyFile;
    }

    public String getServerRootPath() {
        return this.serverRootPath;
    }
}

