/*
 * Decompiled with CFR 0.152.
 */
package com.munjaon.server.config;

import com.munjaon.server.config.ServerConfig;
import com.munjaon.server.queue.dto.QueueInfo;
import com.munjaon.server.queue.pool.KakaoAlarmReadQueue;
import com.munjaon.server.queue.pool.KakaoAlarmWriteQueue;
import com.munjaon.server.queue.pool.KakaoFriendReadQueue;
import com.munjaon.server.queue.pool.KakaoFriendWriteQueue;
import com.munjaon.server.queue.pool.LmsReadQueue;
import com.munjaon.server.queue.pool.LmsWriteQueue;
import com.munjaon.server.queue.pool.MmsReadQueue;
import com.munjaon.server.queue.pool.MmsWriteQueue;
import com.munjaon.server.queue.pool.ReadQueue;
import com.munjaon.server.queue.pool.SmsReadQueue;
import com.munjaon.server.queue.pool.SmsWriteQueue;
import com.munjaon.server.queue.pool.WriteQueue;
import com.munjaon.server.server.service.CollectServerService;
import com.munjaon.server.server.service.PropertyLoader;
import com.munjaon.server.server.service.QueueServerService;
import com.munjaon.server.server.service.ReportQueueServerService;
import com.munjaon.server.server.service.ReportServerService;
import com.munjaon.server.util.ServiceUtil;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration
public class RunnerConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RunnerConfiguration.class);
    private final ServerConfig serverConfig;

    @Bean
    @Order(value=1)
    public CommandLineRunner getRunnerBeanForProperty() {
        System.setProperty("PROPS", this.serverConfig.getServerProperyFile());
        System.setProperty("ROOTPATH", this.serverConfig.getServerRootPath());
        PropertyLoader.load();
        try {
            String[] array = this.serverConfig.getStringArray("test.list");
            if (array != null && array.length > 0) {
                for (String s : array) {
                    System.out.println("List : " + s);
                }
            }
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
        return args -> System.out.println("Runner Bean #1 : " + this.serverConfig.getServerProperyFile());
    }

    @Bean
    @Order(value=2)
    public CommandLineRunner getRunnerBeanForSmsQueue() {
        try {
            String[] svcArray = ServiceUtil.getServiceNames((String[])this.serverConfig.getStringArray("SMS.SERVICE_LIST"));
            if (svcArray == null || svcArray.length == 0) {
                log.info("SMS service list is empty");
            } else if (ServiceUtil.isDuplicate((String[])svcArray)) {
                log.info("SMS service list is duplicated");
            } else {
                for (String svc : svcArray) {
                    log.info("SERVICE CREATE : {}", (Object)svc);
                    QueueInfo queueInfo = QueueInfo.builder().queueName(svc).serviceType("SMS").queuePath(this.serverConfig.getString("SMS.QUEUE_PATH")).build();
                    SmsWriteQueue smsWriteQueue = new SmsWriteQueue(queueInfo);
                    SmsReadQueue smsReadQueue = new SmsReadQueue(queueInfo);
                    QueueServerService queueServerService = new QueueServerService(svc, (WriteQueue)smsWriteQueue, (ReadQueue)smsReadQueue);
                    queueServerService.start();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return args -> System.out.println("Runner Bean #2");
    }

    @Bean
    @Order(value=2)
    public CommandLineRunner getRunnerBeanForLmsQueue() {
        try {
            String[] svcArray = ServiceUtil.getServiceNames((String[])this.serverConfig.getStringArray("LMS.SERVICE_LIST"));
            if (svcArray == null || svcArray.length == 0) {
                log.info("LMS service list is empty");
            } else if (ServiceUtil.isDuplicate((String[])svcArray)) {
                log.info("LMS service list is duplicated");
            } else {
                for (String svc : svcArray) {
                    log.info("SERVICE CREATE : {}", (Object)svc);
                    QueueInfo queueInfo = QueueInfo.builder().queueName(svc).serviceType("LMS").queuePath(this.serverConfig.getString("LMS.QUEUE_PATH")).build();
                    LmsWriteQueue lmsWriteQueue = new LmsWriteQueue(queueInfo);
                    LmsReadQueue lmsReadQueue = new LmsReadQueue(queueInfo);
                    QueueServerService queueServerService = new QueueServerService(svc, (WriteQueue)lmsWriteQueue, (ReadQueue)lmsReadQueue);
                    queueServerService.start();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return args -> System.out.println("Runner Bean #2");
    }

    @Bean
    @Order(value=2)
    public CommandLineRunner getRunnerBeanForMmsQueue() {
        try {
            String[] svcArray = ServiceUtil.getServiceNames((String[])this.serverConfig.getStringArray("MMS.SERVICE_LIST"));
            if (svcArray == null || svcArray.length == 0) {
                log.info("MMS service list is empty");
            } else if (ServiceUtil.isDuplicate((String[])svcArray)) {
                log.info("MMS service list is duplicated");
            } else {
                for (String svc : svcArray) {
                    log.info("SERVICE CREATE : {}", (Object)svc);
                    QueueInfo queueInfo = QueueInfo.builder().queueName(svc).serviceType("MMS").queuePath(this.serverConfig.getString("MMS.QUEUE_PATH")).build();
                    MmsWriteQueue mmsWriteQueue = new MmsWriteQueue(queueInfo);
                    MmsReadQueue mmsReadQueue = new MmsReadQueue(queueInfo);
                    QueueServerService queueServerService = new QueueServerService(svc, (WriteQueue)mmsWriteQueue, (ReadQueue)mmsReadQueue);
                    queueServerService.start();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return args -> System.out.println("Runner Bean #2");
    }

    @Bean
    @Order(value=2)
    public CommandLineRunner getRunnerBeanForKatQueue() {
        try {
            String[] svcArray = ServiceUtil.getServiceNames((String[])this.serverConfig.getStringArray("KAT.SERVICE_LIST"));
            if (svcArray == null || svcArray.length == 0) {
                log.info("KAT service list is empty");
            } else if (ServiceUtil.isDuplicate((String[])svcArray)) {
                log.info("KAT service list is duplicated");
            } else {
                for (String svc : svcArray) {
                    log.info("SERVICE CREATE : {}", (Object)svc);
                    QueueInfo queueInfo = QueueInfo.builder().queueName(svc).serviceType("KAT").queuePath(this.serverConfig.getString("KAT.QUEUE_PATH")).build();
                    KakaoAlarmWriteQueue katWriteQueue = new KakaoAlarmWriteQueue(queueInfo);
                    KakaoAlarmReadQueue katReadQueue = new KakaoAlarmReadQueue(queueInfo);
                    QueueServerService queueServerService = new QueueServerService(svc, (WriteQueue)katWriteQueue, (ReadQueue)katReadQueue);
                    queueServerService.start();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return args -> System.out.println("Runner Bean #2");
    }

    @Bean
    @Order(value=2)
    public CommandLineRunner getRunnerBeanForKftQueue() {
        try {
            String[] svcArray = ServiceUtil.getServiceNames((String[])this.serverConfig.getStringArray("KFT.SERVICE_LIST"));
            if (svcArray == null || svcArray.length == 0) {
                log.info("KFT service list is empty");
            } else if (ServiceUtil.isDuplicate((String[])svcArray)) {
                log.info("KFT service list is duplicated");
            } else {
                for (String svc : svcArray) {
                    log.info("SERVICE CREATE : {}", (Object)svc);
                    QueueInfo queueInfo = QueueInfo.builder().queueName(svc).serviceType("KFT").queuePath(this.serverConfig.getString("KFT.QUEUE_PATH")).build();
                    KakaoFriendWriteQueue kftWriteQueue = new KakaoFriendWriteQueue(queueInfo);
                    KakaoFriendReadQueue kftReadQueue = new KakaoFriendReadQueue(queueInfo);
                    QueueServerService queueServerService = new QueueServerService(svc, (WriteQueue)kftWriteQueue, (ReadQueue)kftReadQueue);
                    queueServerService.start();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return args -> System.out.println("Runner Bean #2");
    }

    @Bean
    @Order(value=3)
    public CommandLineRunner getRunnerBeanForSmsCollector() {
        try {
            String serviceName = "SMS_COLLECTOR";
            String serviceType = this.serverConfig.getString(serviceName + ".SERVICE_TYPE");
            int port = this.serverConfig.getInt(serviceName + ".SERVICE_PORT");
            CollectServerService collectServerService = new CollectServerService(serviceName, serviceType, port);
            collectServerService.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return args -> System.out.println("Runner Bean SmsCollector #3");
    }

    @Bean
    @Order(value=3)
    public CommandLineRunner getRunnerBeanForLmsCollector() {
        try {
            String serviceName = "LMS_COLLECTOR";
            String serviceType = this.serverConfig.getString(serviceName + ".SERVICE_TYPE");
            int port = this.serverConfig.getInt(serviceName + ".SERVICE_PORT");
            CollectServerService collectServerService = new CollectServerService(serviceName, serviceType, port);
            collectServerService.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return args -> System.out.println("Runner Bean SmsCollector #3");
    }

    @Bean
    @Order(value=3)
    public CommandLineRunner getRunnerBeanForMmsCollector() {
        try {
            String serviceName = "MMS_COLLECTOR";
            String serviceType = this.serverConfig.getString(serviceName + ".SERVICE_TYPE");
            int port = this.serverConfig.getInt(serviceName + ".SERVICE_PORT");
            CollectServerService collectServerService = new CollectServerService(serviceName, serviceType, port);
            collectServerService.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return args -> System.out.println("Runner Bean SmsCollector #3");
    }

    @Bean
    @Order(value=3)
    public CommandLineRunner getRunnerBeanForKatCollector() {
        try {
            String serviceName = "KAT_COLLECTOR";
            String serviceType = this.serverConfig.getString(serviceName + ".SERVICE_TYPE");
            int port = this.serverConfig.getInt(serviceName + ".SERVICE_PORT");
            CollectServerService collectServerService = new CollectServerService(serviceName, serviceType, port);
            collectServerService.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return args -> System.out.println("Runner Bean SmsCollector #3");
    }

    @Bean
    @Order(value=3)
    public CommandLineRunner getRunnerBeanForKftCollector() {
        try {
            String serviceName = "KFT_COLLECTOR";
            String serviceType = this.serverConfig.getString(serviceName + ".SERVICE_TYPE");
            int port = this.serverConfig.getInt(serviceName + ".SERVICE_PORT");
            CollectServerService collectServerService = new CollectServerService(serviceName, serviceType, port);
            collectServerService.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return args -> System.out.println("Runner Bean SmsCollector #3");
    }

    @Bean
    @Order(value=3)
    public CommandLineRunner getRunnerBeanForReporter() {
        try {
            String serviceName = "REPORTER";
            int port = this.serverConfig.getInt(serviceName + ".SERVICE_PORT");
            ReportServerService reportServerService = new ReportServerService(serviceName, port);
            reportServerService.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return args -> System.out.println("Runner Bean Reporter #3");
    }

    @Bean
    @Order(value=4)
    public CommandLineRunner getRunnerBeanForReportQueue() {
        try {
            String serviceName = "REPORT_QUEUE";
            ReportQueueServerService reportQueueServerService = new ReportQueueServerService(serviceName);
            reportQueueServerService.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return args -> System.out.println("Runner Bean ReporterQueue #4");
    }

    public RunnerConfiguration(ServerConfig serverConfig) {
        this.serverConfig = serverConfig;
    }
}

