/*
 * Decompiled with CFR 0.152.
 */
package nl.captcha.audio;

import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class Sample {
    public static final AudioFormat SC_AUDIO_FORMAT = new AudioFormat(16000.0f, 16, 1, true, false);
    private final AudioInputStream _audioInputStream;

    public Sample(InputStream is) {
        if (is instanceof AudioInputStream) {
            this._audioInputStream = (AudioInputStream)is;
            return;
        }
        try {
            this._audioInputStream = AudioSystem.getAudioInputStream(is);
        }
        catch (UnsupportedAudioFileException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Sample.checkFormat(this._audioInputStream.getFormat());
    }

    public AudioInputStream getAudioInputStream() {
        return this._audioInputStream;
    }

    public AudioFormat getFormat() {
        return this._audioInputStream.getFormat();
    }

    public long getSampleCount() {
        long total = this._audioInputStream.getFrameLength() * (long)this.getFormat().getFrameSize() * 8L / (long)this.getFormat().getSampleSizeInBits();
        return total / (long)this.getFormat().getChannels();
    }

    public double[] getInterleavedSamples() {
        double[] samples = new double[(int)this.getSampleCount()];
        try {
            this.getInterleavedSamples(0L, this.getSampleCount(), samples);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return samples;
    }

    public double[] getInterleavedSamples(long begin, long end, double[] samples) throws IOException, IllegalArgumentException {
        long nbSamples = end - begin;
        long nbBytes = nbSamples * (long)(this.getFormat().getSampleSizeInBits() / 8) * (long)this.getFormat().getChannels();
        if (nbBytes > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too many samples. Try using a smaller wav.");
        }
        byte[] inBuffer = new byte[(int)nbBytes];
        this._audioInputStream.read(inBuffer, 0, inBuffer.length);
        this.decodeBytes(inBuffer, samples);
        return samples;
    }

    public void getChannelSamples(int channel, double[] interleavedSamples, double[] channelSamples) {
        int nbChannels = this.getFormat().getChannels();
        int i = 0;
        while (i < channelSamples.length) {
            channelSamples[i] = interleavedSamples[nbChannels * i + channel];
            ++i;
        }
    }

    public void getStereoSamples(double[] leftSamples, double[] rightSamples) throws IOException {
        long sampleCount = this.getSampleCount();
        double[] interleavedSamples = new double[(int)sampleCount * 2];
        this.getInterleavedSamples(0L, sampleCount, interleavedSamples);
        int i = 0;
        while (i < leftSamples.length) {
            leftSamples[i] = interleavedSamples[2 * i];
            rightSamples[i] = interleavedSamples[2 * i + 1];
            ++i;
        }
    }

    public void decodeBytes(byte[] audioBytes, double[] audioSamples) {
        int sampleSizeInBytes = this.getFormat().getSampleSizeInBits() / 8;
        int[] sampleBytes = new int[sampleSizeInBytes];
        int k = 0;
        int i = 0;
        while (i < audioSamples.length) {
            double val;
            int j;
            if (this.getFormat().isBigEndian()) {
                j = 0;
                while (j < sampleSizeInBytes) {
                    sampleBytes[j] = audioBytes[k++];
                    ++j;
                }
            } else {
                j = sampleSizeInBytes - 1;
                while (j >= 0) {
                    sampleBytes[j] = audioBytes[k++];
                    if (sampleBytes[j] != 0) {
                        j += 0;
                    }
                    --j;
                }
            }
            int ival = 0;
            int j2 = 0;
            while (j2 < sampleSizeInBytes) {
                ival += sampleBytes[j2];
                if (j2 < sampleSizeInBytes - 1) {
                    ival <<= 8;
                }
                ++j2;
            }
            double ratio = Math.pow(2.0, this.getFormat().getSampleSizeInBits() - 1);
            audioSamples[i] = val = (double)ival / ratio;
            ++i;
        }
    }

    public final byte[] asByteArray() {
        return Sample.asByteArray(this.getSampleCount(), this.getInterleavedSamples());
    }

    public static final byte[] asByteArray(long sampleCount, double[] sample) {
        int b_len = (int)sampleCount * (SC_AUDIO_FORMAT.getSampleSizeInBits() / 8);
        byte[] buffer = new byte[b_len];
        int i = 0;
        while (i < sample.length) {
            int in = (int)(sample[i] * 32767.0);
            buffer[2 * i] = (byte)(in & 0xFF);
            buffer[2 * i + 1] = (byte)(in >> 8);
            ++i;
        }
        return buffer;
    }

    public String toString() {
        return "[Sample] samples: " + this.getSampleCount() + ", format: " + this.getFormat();
    }

    private static final void checkFormat(AudioFormat af) {
        if (!af.matches(SC_AUDIO_FORMAT)) {
            throw new IllegalArgumentException("Unsupported audio format.\nReceived: " + af.toString() + "\nExpected: " + SC_AUDIO_FORMAT);
        }
    }
}

