/*
 * Decompiled with CFR 0.152.
 */
package nl.captcha.audio;

import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.List;
import javax.sound.sampled.AudioInputStream;
import nl.captcha.audio.Sample;

public class Mixer {
    public static final Sample append(List<Sample> samples) {
        if (samples.size() == 0) {
            return Mixer.buildSample(0L, new double[0]);
        }
        int sampleCount = 0;
        double[] first = samples.get(0).getInterleavedSamples();
        sampleCount = (int)((long)sampleCount + samples.get(0).getSampleCount());
        double[][] samples_ary = new double[samples.size() - 1][];
        int i = 0;
        while (i < samples_ary.length) {
            samples_ary[i] = samples.get(i + 1).getInterleavedSamples();
            sampleCount = (int)((long)sampleCount + samples.get(i + 1).getSampleCount());
            ++i;
        }
        double[] appended = Mixer.concatAll(first, samples_ary);
        return Mixer.buildSample(sampleCount, appended);
    }

    public static final Sample mix(Sample sample1, double volAdj1, Sample sample2, double volAdj2) {
        double[] s1_ary = sample1.getInterleavedSamples();
        double[] s2_ary = sample2.getInterleavedSamples();
        double[] mixed = Mixer.mix(s1_ary, volAdj1, s2_ary, volAdj2);
        return Mixer.buildSample(sample1.getSampleCount(), mixed);
    }

    private static final double[] concatAll(double[] first, double[] ... rest) {
        int totalLength = first.length;
        double[][] dArray = rest;
        int n = rest.length;
        int n2 = 0;
        while (n2 < n) {
            double[] array = dArray[n2];
            totalLength += array.length;
            ++n2;
        }
        double[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        double[][] dArray2 = rest;
        int n3 = rest.length;
        int n4 = 0;
        while (n4 < n3) {
            double[] array = dArray2[n4];
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
            ++n4;
        }
        return result;
    }

    private static final double[] mix(double[] sample1, double volAdj1, double[] sample2, double volAdj2) {
        int i = 0;
        while (i < sample1.length) {
            if (i >= sample2.length) {
                sample1[i] = 0.0;
                break;
            }
            sample1[i] = sample1[i] * volAdj1 + sample2[i] * volAdj2;
            ++i;
        }
        return sample1;
    }

    private static final AudioInputStream buildStream(long sampleCount, double[] sample) {
        byte[] buffer = Sample.asByteArray(sampleCount, sample);
        ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
        return new AudioInputStream(bais, Sample.SC_AUDIO_FORMAT, sampleCount);
    }

    private static final Sample buildSample(long sampleCount, double[] sample) {
        AudioInputStream ais = Mixer.buildStream(sampleCount, sample);
        return new Sample(ais);
    }
}

