/*
 * Decompiled with CFR 0.152.
 */
package com.sci.v2.pcc.secu.seed.util;

import com.sci.v2.pcc.secu.seed.util.InvalidBase64Exception;
import java.util.StringTokenizer;

public class Base64Util {
    public static String encode(String raw) {
        return Base64Util.encode(raw.getBytes(), true);
    }

    public static String encode(String raw, boolean insertCRLF) {
        return Base64Util.encode(raw.getBytes(), insertCRLF);
    }

    public static String encode(byte[] raw) {
        return Base64Util.encode(raw, true);
    }

    public static String encode(byte[] raw, boolean insertCRLF) {
        StringBuffer encoded = new StringBuffer();
        if (insertCRLF) {
            int i = 0;
            while (i < raw.length) {
                if (i % 48 == 0 && i != 0) {
                    encoded.append("\n");
                }
                encoded.append(Base64Util.encodedBlock(raw, i));
                i += 3;
            }
        } else {
            int i = 0;
            while (i < raw.length) {
                encoded.append(Base64Util.encodedBlock(raw, i));
                i += 3;
            }
        }
        return encoded.toString();
    }

    protected static char[] encodedBlock(byte[] raw, int offset) {
        int block = 0;
        int slack = raw.length - offset - 1;
        int end = slack < 2 ? slack : 2;
        int i = 0;
        while (i <= end) {
            int b = raw[offset + i];
            int neuter = b >= 0 ? b : b + 256;
            block += neuter << 8 * (2 - i);
            ++i;
        }
        char[] base64 = new char[4];
        int i2 = 0;
        while (i2 < 4) {
            int sixbit = block >>> 6 * (3 - i2) & 0x3F;
            base64[i2] = Base64Util.getChar(sixbit);
            ++i2;
        }
        if (slack < 1) {
            base64[2] = 61;
        }
        if (slack < 2) {
            base64[3] = 61;
        }
        return base64;
    }

    protected static char getChar(int sixBit) {
        if (sixBit >= 0 && sixBit <= 25) {
            return (char)(65 + sixBit);
        }
        if (sixBit >= 26 && sixBit <= 51) {
            return (char)(97 + (sixBit - 26));
        }
        if (sixBit >= 52 && sixBit <= 61) {
            return (char)(48 + (sixBit - 52));
        }
        if (sixBit == 62) {
            return '+';
        }
        return sixBit != 63 ? (char)'?' : '/';
    }

    public static byte[] decode(String base64Src) throws InvalidBase64Exception {
        int pad = 0;
        String base64 = Base64Util.delCRLF(Base64Util.reform(base64Src));
        if (base64.length() % 4 != 0) {
            throw new InvalidBase64Exception("Data is not Base64 encoding type.(Data length error)");
        }
        if (!Base64Util.isBase64(base64.getBytes())) {
            throw new InvalidBase64Exception("Data is not Base64 encoding type.(String set error)");
        }
        int i = base64.length() - 1;
        while (base64.charAt(i) == '=') {
            ++pad;
            --i;
        }
        int base64Length = base64.length() * 6 / 8 - pad;
        byte[] raw = new byte[base64Length];
        int rawIndex = 0;
        int i2 = 0;
        while (i2 < base64.length()) {
            int block = (Base64Util.getValue(base64.charAt(i2)) << 18) + (Base64Util.getValue(base64.charAt(i2 + 1)) << 12) + (Base64Util.getValue(base64.charAt(i2 + 2)) << 6) + Base64Util.getValue(base64.charAt(i2 + 3));
            int j = 0;
            while (j < 3 && rawIndex + j < raw.length) {
                raw[rawIndex + j] = (byte)(block >> 8 * (2 - j) & 0xFF);
                ++j;
            }
            rawIndex += 3;
            i2 += 4;
        }
        return raw;
    }

    protected static int getValue(char c) {
        if (c >= 'A' && c <= 'Z') {
            return c - 65;
        }
        if (c >= 'a' && c <= 'z') {
            return c - 97 + 26;
        }
        if (c >= '0' && c <= '9') {
            return c - 48 + 52;
        }
        if (c == '+') {
            return 62;
        }
        if (c == '/') {
            return 63;
        }
        return c != '=' ? -1 : 0;
    }

    public static boolean isBase64(byte[] data) {
        int i = 0;
        while (i < data.length) {
            char c = (char)data[i];
            if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '+' || c == '/' || c == '=')) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected static String reform(String data) {
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(data);
        while (st.hasMoreTokens()) {
            sb.append(st.nextToken());
        }
        return sb.toString();
    }

    protected static String delCRLF(String data) {
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(data, "\n\r");
        while (st.hasMoreTokens()) {
            sb.append(st.nextToken());
        }
        return sb.toString();
    }
}

