/*
 * Decompiled with CFR 0.152.
 */
package core.log.impl;

import core.log.impl.PreparedStatementLoggableInterface;
import core.log.logger.SL;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class PreparedStatementLoggable
implements PreparedStatementLoggableInterface {
    private PreparedStatement preparedStatement;
    private Statement statement;
    private List parameterValues = new ArrayList();

    public PreparedStatementLoggable() {
    }

    public PreparedStatementLoggable(Connection connection) throws SQLException {
        this.statement = connection.createStatement();
    }

    public PreparedStatementLoggable(Connection connection, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.statement = connection.createStatement(resultSetType, resultSetConcurrency);
    }

    public PreparedStatementLoggable(Connection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.statement = connection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PreparedStatementLoggable(Connection connection, String sql) throws SQLException {
        this.preparedStatement = connection.prepareStatement(sql);
        this.parameterValues = new ArrayList();
    }

    public PreparedStatementLoggable(Connection connection, String sql, String[] columnNames) throws SQLException {
        this.preparedStatement = connection.prepareStatement(sql, columnNames);
        this.parameterValues = new ArrayList();
    }

    public PreparedStatementLoggable(Connection connection, String sql, int autoGeneratedKeys) throws SQLException {
        this.preparedStatement = connection.prepareStatement(sql, autoGeneratedKeys);
        this.parameterValues = new ArrayList();
    }

    public PreparedStatementLoggable(Connection connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.preparedStatement = connection.prepareStatement(sql, resultSetType, resultSetConcurrency);
        this.parameterValues = new ArrayList();
    }

    public PreparedStatementLoggable(Connection connection, String sql, int[] columnIndexes) throws SQLException {
        this.preparedStatement = connection.prepareStatement(sql, columnIndexes);
        this.parameterValues = new ArrayList();
    }

    public PreparedStatementLoggable(Connection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.preparedStatement = connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.parameterValues = new ArrayList();
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.preparedStatement.setLong(parameterIndex, x);
        this.saveQueryParamValue(parameterIndex, new Long(x));
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.preparedStatement.setBoolean(parameterIndex, x);
        this.saveQueryParamValue(parameterIndex, new Boolean(x));
    }

    public int executeUpdate() throws SQLException {
        return this.preparedStatement.executeUpdate();
    }

    public void addBatch() throws SQLException {
        this.preparedStatement.addBatch();
    }

    public void clearParameters() throws SQLException {
        this.preparedStatement.clearParameters();
        this.parameterValues = null;
        this.parameterValues = new ArrayList();
    }

    public boolean execute() throws SQLException {
        return this.preparedStatement.execute();
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.preparedStatement.setByte(parameterIndex, x);
        this.saveQueryParamValue(parameterIndex, new Byte(x));
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.preparedStatement.setShort(parameterIndex, x);
        this.saveQueryParamValue(parameterIndex, new Short(x));
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.preparedStatement.setInt(parameterIndex, x);
        this.saveQueryParamValue(parameterIndex, new Integer(x));
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.preparedStatement.setNull(parameterIndex, sqlType);
        this.saveQueryParamValue(parameterIndex, null);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.preparedStatement.setFloat(parameterIndex, x);
        this.saveQueryParamValue(parameterIndex, new Float(x));
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.preparedStatement.setDouble(parameterIndex, x);
        this.saveQueryParamValue(parameterIndex, new Double(x));
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.preparedStatement.setBigDecimal(parameterIndex, x);
        this.saveQueryParamValue(parameterIndex, x);
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.preparedStatement.setURL(parameterIndex, x);
        this.saveQueryParamValue(parameterIndex, x);
    }

    public void setArray(int i, Array x) throws SQLException {
        this.preparedStatement.setArray(i, x);
    }

    public void setBlob(int i, Blob x) throws SQLException {
        this.preparedStatement.setBlob(i, x);
    }

    public void setClob(int i, Clob x) throws SQLException {
        this.preparedStatement.setClob(i, x);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.preparedStatement.setString(parameterIndex, x);
        this.saveQueryParamValue(parameterIndex, x);
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.preparedStatement.setBytes(parameterIndex, x);
        this.saveQueryParamValue(parameterIndex, x);
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.preparedStatement.setDate(parameterIndex, x);
        this.saveQueryParamValue(parameterIndex, x);
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.preparedStatement.getParameterMetaData();
    }

    public void setRef(int i, Ref x) throws SQLException {
        this.preparedStatement.setRef(i, x);
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.preparedStatement.setTime(parameterIndex, x);
        this.saveQueryParamValue(parameterIndex, x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.preparedStatement.setTimestamp(parameterIndex, x);
        this.saveQueryParamValue(parameterIndex, x);
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.preparedStatement.setDate(parameterIndex, x, cal);
        this.saveQueryParamValue(parameterIndex, x);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.preparedStatement.setTime(parameterIndex, x, cal);
        this.saveQueryParamValue(parameterIndex, x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.preparedStatement.setTimestamp(parameterIndex, x, cal);
        this.saveQueryParamValue(parameterIndex, x);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.preparedStatement.setAsciiStream(parameterIndex, x, length);
        this.saveQueryParamValue(parameterIndex, x);
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.preparedStatement.setUnicodeStream(parameterIndex, x, length);
        this.saveQueryParamValue(parameterIndex, x);
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        String originSql = null;
        try {
            int ch = 0;
            StringWriter sw = new StringWriter();
            while ((ch = reader.read()) != -1) {
                sw.write((char)ch);
            }
            originSql = sw.toString();
        }
        catch (IOException e) {
            SL.getInstance().log(e);
        }
        this.preparedStatement.setCharacterStream(parameterIndex, (Reader)new StringReader(originSql), length);
        this.saveQueryParamValue(parameterIndex, originSql);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.preparedStatement.setBinaryStream(parameterIndex, x, length);
        this.saveQueryParamValue(parameterIndex, x);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.preparedStatement.setObject(parameterIndex, x, targetSqlType, scale);
        this.saveQueryParamValue(parameterIndex, x);
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.preparedStatement.setNull(paramIndex, sqlType, typeName);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.preparedStatement.setObject(parameterIndex, x, targetSqlType);
        this.saveQueryParamValue(parameterIndex, x);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.preparedStatement.setObject(parameterIndex, x);
        this.saveQueryParamValue(parameterIndex, x);
    }

    public ResultSet executeQuery() throws SQLException {
        return this.preparedStatement.executeQuery();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.preparedStatement.getMetaData();
    }

    public int getFetchDirection() throws SQLException {
        if (this.preparedStatement != null) {
            return this.preparedStatement.getFetchDirection();
        }
        if (this.statement != null) {
            return this.statement.getFetchDirection();
        }
        throw new SQLException("Confuse!!! Preparedstatment Or Statement?");
    }

    public int getFetchSize() throws SQLException {
        if (this.preparedStatement != null) {
            return this.preparedStatement.getFetchSize();
        }
        if (this.statement != null) {
            return this.statement.getFetchSize();
        }
        throw new SQLException("Confuse!!! Preparedstatment Or Statement?");
    }

    public int getMaxFieldSize() throws SQLException {
        if (this.preparedStatement != null) {
            return this.preparedStatement.getMaxFieldSize();
        }
        if (this.statement != null) {
            return this.statement.getMaxFieldSize();
        }
        throw new SQLException("Confuse!!! Preparedstatment Or Statement?");
    }

    public int getMaxRows() throws SQLException {
        if (this.preparedStatement != null) {
            return this.preparedStatement.getMaxRows();
        }
        if (this.statement != null) {
            return this.statement.getMaxRows();
        }
        throw new SQLException("Confuse!!! Preparedstatment Or Statement?");
    }

    public int getQueryTimeout() throws SQLException {
        if (this.preparedStatement != null) {
            return this.preparedStatement.getQueryTimeout();
        }
        if (this.statement != null) {
            return this.statement.getQueryTimeout();
        }
        throw new SQLException("Confuse!!! Preparedstatment Or Statement?");
    }

    public int getResultSetConcurrency() throws SQLException {
        if (this.preparedStatement != null) {
            return this.preparedStatement.getResultSetConcurrency();
        }
        if (this.statement != null) {
            return this.statement.getResultSetConcurrency();
        }
        throw new SQLException("Confuse!!! Preparedstatment Or Statement?");
    }

    public int getResultSetHoldability() throws SQLException {
        if (this.preparedStatement != null) {
            return this.preparedStatement.getResultSetHoldability();
        }
        if (this.statement != null) {
            return this.statement.getResultSetHoldability();
        }
        throw new SQLException("Confuse!!! Preparedstatment Or Statement?");
    }

    public int getResultSetType() throws SQLException {
        if (this.preparedStatement != null) {
            return this.preparedStatement.getResultSetType();
        }
        if (this.statement != null) {
            return this.statement.getResultSetType();
        }
        throw new SQLException("Confuse!!! Preparedstatment Or Statement?");
    }

    public int getUpdateCount() throws SQLException {
        if (this.preparedStatement != null) {
            return this.preparedStatement.getUpdateCount();
        }
        if (this.statement != null) {
            return this.statement.getUpdateCount();
        }
        throw new SQLException("Confuse!!! Preparedstatment Or Statement?");
    }

    public void cancel() throws SQLException {
        if (this.preparedStatement != null) {
            this.preparedStatement.cancel();
        } else if (this.statement != null) {
            this.statement.cancel();
        }
    }

    public void clearBatch() throws SQLException {
        if (this.preparedStatement != null) {
            this.preparedStatement.clearBatch();
        } else if (this.statement != null) {
            this.statement.clearBatch();
        }
    }

    public void clearWarnings() throws SQLException {
        if (this.preparedStatement != null) {
            this.preparedStatement.clearWarnings();
        } else if (this.statement != null) {
            this.statement.clearWarnings();
        }
    }

    public void close() throws SQLException {
        if (this.preparedStatement != null) {
            this.preparedStatement.close();
        } else if (this.statement != null) {
            this.statement.close();
        }
    }

    public boolean getMoreResults() throws SQLException {
        if (this.preparedStatement != null) {
            return this.preparedStatement.getMoreResults();
        }
        if (this.statement != null) {
            return this.statement.getMoreResults();
        }
        throw new SQLException("Confuse!!! Preparedstatment Or Statement?");
    }

    public int[] executeBatch() throws SQLException {
        if (this.preparedStatement != null) {
            return this.preparedStatement.executeBatch();
        }
        if (this.statement != null) {
            return this.statement.executeBatch();
        }
        throw new SQLException("Confuse!!! Preparedstatment Or Statement?");
    }

    public void setFetchDirection(int direction) throws SQLException {
        if (this.preparedStatement != null) {
            this.preparedStatement.setFetchDirection(direction);
        } else if (this.statement != null) {
            this.statement.setFetchDirection(direction);
        }
    }

    public void setFetchSize(int rows) throws SQLException {
        if (this.preparedStatement != null) {
            this.preparedStatement.setFetchSize(rows);
        } else if (this.statement != null) {
            this.statement.setFetchSize(rows);
        }
    }

    public void setMaxFieldSize(int max) throws SQLException {
        if (this.preparedStatement != null) {
            this.preparedStatement.setMaxFieldSize(max);
        } else if (this.statement != null) {
            this.statement.setMaxFieldSize(max);
        }
    }

    public void setMaxRows(int max) throws SQLException {
        if (this.preparedStatement != null) {
            this.preparedStatement.setMaxRows(max);
        } else if (this.statement != null) {
            this.statement.setMaxRows(max);
        }
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        if (this.preparedStatement != null) {
            this.preparedStatement.setQueryTimeout(seconds);
        } else if (this.statement != null) {
            this.statement.setQueryTimeout(seconds);
        }
    }

    public boolean getMoreResults(int current) throws SQLException {
        if (this.preparedStatement != null) {
            return this.preparedStatement.getMoreResults(current);
        }
        if (this.statement != null) {
            return this.statement.getMoreResults(current);
        }
        throw new SQLException("Confuse!!! Preparedstatment Or Statement?");
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        if (this.preparedStatement != null) {
            this.preparedStatement.setEscapeProcessing(enable);
        } else if (this.statement != null) {
            this.statement.setEscapeProcessing(enable);
        }
    }

    public void addBatch(String sql) throws SQLException {
        if (this.preparedStatement != null) {
            this.preparedStatement.addBatch(sql);
        } else if (this.statement != null) {
            this.statement.addBatch(sql);
        }
    }

    public void setCursorName(String name) throws SQLException {
        if (this.preparedStatement != null) {
            this.preparedStatement.setCursorName(name);
        } else if (this.statement != null) {
            this.statement.setCursorName(name);
        }
    }

    public Connection getConnection() throws SQLException {
        if (this.preparedStatement != null) {
            return this.preparedStatement.getConnection();
        }
        if (this.statement != null) {
            return this.statement.getConnection();
        }
        throw new SQLException("Confuse!!! Preparedstatment Or Statement?");
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        if (this.preparedStatement != null) {
            return this.preparedStatement.getGeneratedKeys();
        }
        if (this.statement != null) {
            return this.statement.getGeneratedKeys();
        }
        throw new SQLException("Confuse!!! Preparedstatment Or Statement?");
    }

    public ResultSet getResultSet() throws SQLException {
        if (this.preparedStatement != null) {
            return this.preparedStatement.getResultSet();
        }
        if (this.statement != null) {
            return this.statement.getResultSet();
        }
        throw new SQLException("Confuse!!! Preparedstatment Or Statement?");
    }

    public SQLWarning getWarnings() throws SQLException {
        if (this.preparedStatement != null) {
            return this.preparedStatement.getWarnings();
        }
        if (this.statement != null) {
            return this.statement.getWarnings();
        }
        throw new SQLException("Confuse!!! Preparedstatment Or Statement?");
    }

    public boolean execute(String sql) throws SQLException {
        if (this.preparedStatement != null) {
            return this.preparedStatement.execute(sql);
        }
        if (this.statement != null) {
            return this.statement.execute(sql);
        }
        throw new SQLException("Confuse!!! Preparedstatment Or Statement?");
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.preparedStatement != null) {
            return this.preparedStatement.execute(sql, autoGeneratedKeys);
        }
        if (this.statement != null) {
            return this.statement.execute(sql, autoGeneratedKeys);
        }
        throw new SQLException("Confuse!!! Preparedstatment Or Statement?");
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        if (this.preparedStatement != null) {
            return this.preparedStatement.execute(sql, columnIndexes);
        }
        if (this.statement != null) {
            return this.statement.execute(sql, columnIndexes);
        }
        throw new SQLException("Confuse!!! Preparedstatment Or Statement?");
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.preparedStatement != null) {
            return this.preparedStatement.executeUpdate(sql, autoGeneratedKeys);
        }
        if (this.statement != null) {
            return this.statement.executeUpdate(sql, autoGeneratedKeys);
        }
        throw new SQLException("Confuse!!! Preparedstatment Or Statement?");
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        if (this.preparedStatement != null) {
            return this.preparedStatement.executeUpdate(sql, columnIndexes);
        }
        if (this.statement != null) {
            return this.statement.executeUpdate(sql, columnIndexes);
        }
        throw new SQLException("Confuse!!! Preparedstatment Or Statement?");
    }

    public int executeUpdate(String sql) throws SQLException {
        if (this.preparedStatement != null) {
            return this.preparedStatement.executeUpdate(sql);
        }
        if (this.statement != null) {
            return this.statement.executeUpdate(sql);
        }
        throw new SQLException("Confuse!!! Preparedstatment Or Statement?");
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        if (this.preparedStatement != null) {
            return this.preparedStatement.executeUpdate(sql, columnNames);
        }
        if (this.statement != null) {
            return this.statement.executeUpdate(sql, columnNames);
        }
        throw new SQLException("Confuse!!! Preparedstatment Or Statement?");
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        if (this.preparedStatement != null) {
            return this.preparedStatement.execute(sql, columnNames);
        }
        if (this.statement != null) {
            return this.statement.execute(sql, columnNames);
        }
        throw new SQLException("Confuse!!! Preparedstatment Or Statement?");
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        if (this.preparedStatement != null) {
            return this.preparedStatement.executeQuery(sql);
        }
        if (this.statement != null) {
            return this.statement.executeQuery(sql);
        }
        throw new SQLException("Confuse!!! Preparedstatment Or Statement?");
    }

    private void saveQueryParamValue(int position, Object obj) {
        this.parameterValues.add(obj);
    }

    public List getParameterValues() {
        return this.parameterValues;
    }

    public void setParameterValuesInitailize() {
        this.parameterValues = new ArrayList();
    }
}

