/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.rowset;

import com.tmax.tibero.jdbc.err.TbError;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Vector;

public class TbRow
implements Serializable {
    private static final long serialVersionUID = -8999757353034075305L;
    protected Object[] originalCols;
    protected Object[] currentCols;
    protected boolean[] isColumnChanged;
    private boolean[] isNull;
    protected boolean deleted = false;
    protected boolean updated = false;
    protected boolean inserted = false;
    protected int columnCount;
    private int insertedColumnCnt;

    public TbRow(int n) {
        this.columnCount = n;
        this.originalCols = new Object[n];
        this.currentCols = new Object[n];
        this.isColumnChanged = new boolean[n];
        this.isNull = new boolean[n];
    }

    public TbRow(int n, boolean bl) {
        this(n);
        this.inserted = bl;
        this.insertedColumnCnt = 0;
    }

    public TbRow(int n, Object[] objectArray) {
        this(n);
        System.arraycopy(objectArray, 0, this.originalCols, 0, n);
    }

    public void cancelDeleted() {
        this.deleted = false;
    }

    public void cancelInserted() {
        this.inserted = false;
    }

    public void cancelUpdated() {
        this.insertedColumnCnt = 0;
        for (int i = 0; i < this.columnCount; ++i) {
            this.isColumnChanged[i] = false;
        }
        this.currentCols = null;
        this.currentCols = new Object[this.columnCount];
    }

    public void commitChangedColumns() {
        for (int i = 0; i < this.columnCount; ++i) {
            if (!this.isColumnChanged[i]) continue;
            this.originalCols[i] = this.currentCols[i];
            this.currentCols[i] = null;
            this.isColumnChanged[i] = false;
        }
        this.updated = false;
    }

    public TbRow createCopy() throws SQLException {
        TbRow tbRow = new TbRow(this.columnCount);
        for (int i = 0; i < this.columnCount; ++i) {
            tbRow.originalCols[i] = this.getCopy(this.originalCols[i]);
            tbRow.currentCols[i] = this.getCopy(this.currentCols[i]);
        }
        System.arraycopy(this.isColumnChanged, 0, tbRow.isColumnChanged, 0, this.columnCount);
        tbRow.insertedColumnCnt = this.insertedColumnCnt;
        tbRow.deleted = this.deleted;
        tbRow.inserted = this.inserted;
        tbRow.updated = this.updated;
        return tbRow;
    }

    public Object getChangedColumn(int n) {
        return this.currentCols[n - 1];
    }

    public Object getColumn(int n) {
        return this.originalCols[n - 1];
    }

    public Object getCopy(Object object) throws SQLException {
        if (object == null) {
            return null;
        }
        try {
            if (object instanceof String) {
                return new String((String)object);
            }
            if (object instanceof Number) {
                return new BigDecimal(((Number)object).toString());
            }
            if (object instanceof Date) {
                return new Date(((Date)object).getTime());
            }
            if (object instanceof Timestamp) {
                return new Timestamp(((Timestamp)object).getTime());
            }
            if (object instanceof InputStream) {
                return new DataInputStream((InputStream)object);
            }
            if (object instanceof OutputStream) {
                return new DataOutputStream((OutputStream)object);
            }
            throw TbError.newSQLException(-90842, object.toString());
        }
        catch (Exception exception) {
            throw TbError.newSQLException(-90830, exception.getMessage());
        }
    }

    public Object[] getOriginalRow() {
        return this.originalCols;
    }

    public void insertRow() {
        this.isColumnChanged = null;
        this.isColumnChanged = new boolean[this.columnCount];
        System.arraycopy(this.currentCols, 0, this.originalCols, 0, this.columnCount);
        this.currentCols = null;
        this.currentCols = new Object[this.columnCount];
    }

    public boolean isColumnChanged(int n) {
        return this.isColumnChanged[n - 1];
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean isInserted() {
        return this.inserted;
    }

    boolean isNull(int n) throws SQLException {
        return this.isNull[n - 1];
    }

    public boolean isPopulationCompleted() {
        if (!this.inserted) {
            return false;
        }
        return this.insertedColumnCnt == this.columnCount;
    }

    public boolean isUpdated() {
        if (this.inserted || this.deleted) {
            return false;
        }
        for (int i = 0; i < this.columnCount; ++i) {
            if (!this.isColumnChanged[i]) continue;
            return true;
        }
        return false;
    }

    public void markDeleted(boolean bl) {
        this.deleted = bl;
    }

    public void markInserted(boolean bl) {
        this.inserted = bl;
    }

    void markNull(int n, boolean bl) throws SQLException {
        this.isNull[n - 1] = bl;
    }

    public void markUpdated(boolean bl) {
        this.updated = bl;
        if (!bl) {
            this.cancelUpdated();
        }
    }

    public void reset() {
        this.originalCols = null;
        this.currentCols = null;
        this.isColumnChanged = null;
        this.deleted = false;
        this.updated = false;
        this.inserted = false;
        this.columnCount = 0;
    }

    public void setColumn(int n, Object object) {
        if (this.inserted) {
            ++this.insertedColumnCnt;
        }
        this.originalCols[n - 1] = object;
    }

    public Collection<Object> toCollection() {
        Vector<Object> vector = new Vector<Object>(this.columnCount);
        for (int i = 1; i <= this.columnCount; ++i) {
            vector.add(this.isColumnChanged(i) ? this.getChangedColumn(i) : this.getColumn(i));
        }
        return vector;
    }

    public void updateObject(int n, Object object) {
        if (this.inserted) {
            ++this.insertedColumnCnt;
        }
        this.isColumnChanged[n - 1] = true;
        this.currentCols[n - 1] = object;
    }
}

