/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data;

import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.util.TbCommon;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;

public class TbRAW {
    private byte[] data;

    static byte hexTo4Bit(char c) throws SQLException {
        byte by = (byte)Character.digit(c, 16);
        if (by == -1) {
            throw new SQLException("invalid hexademical number: " + c);
        }
        return by;
    }

    public static byte[] hexString2Bytes(String string) throws SQLException {
        byte[] byArray;
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        int n2 = 0;
        int n3 = 0;
        if (n == 0) {
            return new byte[0];
        }
        if (n % 2 > 0) {
            byArray = new byte[(n + 1) / 2];
            byArray[n2++] = TbRAW.hexTo4Bit(cArray[n3++]);
        } else {
            byArray = new byte[n / 2];
        }
        while (n2 < byArray.length) {
            byArray[n2] = (byte)(TbRAW.hexTo4Bit(cArray[n3++]) << 4 | TbRAW.hexTo4Bit(cArray[n3++]));
            ++n2;
        }
        return byArray;
    }

    public static TbRAW newRAW(Object object) throws SQLException {
        TbRAW tbRAW = new TbRAW(object);
        return tbRAW;
    }

    public static TbRAW oldRAW(Object object) throws SQLException {
        TbRAW tbRAW;
        if (object instanceof String) {
            String string = (String)object;
            byte[] byArray = null;
            try {
                byArray = string.getBytes("ISO8859_1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw TbError.newSQLException(-590714);
            }
            tbRAW = new TbRAW(byArray);
        } else {
            tbRAW = new TbRAW(object);
        }
        return tbRAW;
    }

    public TbRAW() {
    }

    public TbRAW(byte[] byArray) {
        this.data = byArray;
    }

    public TbRAW(Object object) throws SQLException {
        this();
        if (object instanceof byte[]) {
            this.setShareBytes((byte[])object);
        } else if (object instanceof String) {
            this.setShareBytes(TbRAW.hexString2Bytes((String)object));
        } else {
            throw new SQLException("invalid parameter type.");
        }
    }

    public Object toJdbc() throws SQLException {
        return this.getBytes();
    }

    public boolean isConvertibleTo(Class clazz) {
        String string = clazz.getName();
        return string.compareTo("java.lang.String") == 0 || string.compareTo("java.io.InputStream") == 0 || string.compareTo("java.io.Reader") == 0;
    }

    public String stringValue() {
        String string = TbCommon.bytes2String(this.getBytes(), 0, (int)this.getLength());
        return string;
    }

    public Reader characterStreamValue() throws SQLException {
        int n = (int)this.getLength();
        char[] cArray = new char[n * 2];
        byte[] byArray = this.shareBytes();
        this.bytesToHexChars(byArray, n, cArray);
        CharArrayReader charArrayReader = new CharArrayReader(cArray);
        return charArrayReader;
    }

    public InputStream asciiStreamValue() throws SQLException {
        int n = (int)this.getLength();
        char[] cArray = new char[n * 2];
        byte[] byArray = this.shareBytes();
        this.bytesToHexChars(byArray, n, cArray);
        byte[] byArray2 = new byte[n * 2];
        for (int i = 0; i < n * 2; ++i) {
            byArray2[i] = (byte)cArray[i];
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
        return byteArrayInputStream;
    }

    public InputStream binaryStreamValue() throws SQLException {
        return this.getStream();
    }

    public Object makeJdbcArray(int n) {
        return new byte[n][];
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[this.data.length];
        System.arraycopy(this.data, 0, byArray, 0, this.data.length);
        return byArray;
    }

    public InputStream getStream() {
        return new ByteArrayInputStream(this.data);
    }

    public byte[] shareBytes() {
        return this.data;
    }

    public void setShareBytes(byte[] byArray) {
        this.data = byArray;
    }

    public void setBytes(byte[] byArray) {
        int n = byArray.length;
        this.data = new byte[n];
        System.arraycopy(byArray, 0, this.data, 0, n);
    }

    public long getLength() {
        if (null == this.data) {
            return 0L;
        }
        return this.data.length;
    }

    private void bytesToHexChars(byte[] byArray, int n, char[] cArray) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            cArray[n2++] = (char)this.rawToHex((byte)(byArray[i] >> 4 & 0xF));
            cArray[n2++] = (char)this.rawToHex((byte)(byArray[i] & 0xF));
        }
    }

    private byte rawToHex(byte by) {
        return (byte)((by = (byte)(by & 0xF)) >= 10 ? by - 10 + 65 : by + 48);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof TbRAW) {
            TbRAW tbRAW = (TbRAW)object;
            if (this.data == null && tbRAW.data == null) {
                return true;
            }
            if (this.data == null && tbRAW.data != null || this.data != null && tbRAW.data == null) {
                return false;
            }
            if (this.data.length != tbRAW.data.length) {
                return false;
            }
            for (int i = 0; i < this.data.length; ++i) {
                if (this.data[i] == tbRAW.data[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

