/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data;

import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.util.TbCommon;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.SQLException;

public class TbNumber {
    private static final int NUMBER_MAX_PREC = 38;
    private static final int EXP_BIAS_POS = 65;
    private static final int EXP_BIAS_NEG = 62;
    private static final int NUMBER_MAX_EXP = 62;
    private static final int NUMBER_MIN_EXP = -65;
    private static final int NUMBER_TOP = -16;
    private static final int NUMBER_BOT = 16;
    private static final int NUMBER_BASE = 100;
    private static final int NUMBER_MAX_LEN = 21;
    private static final int NUMBER_MASK_SIGN = 128;
    private static final int NUMBER_MASK_EXP = 127;
    private static final byte[] MAX_INTEGER = new byte[]{6, -59, -107, -81, -80, -92, -81};
    private static final byte[] MIN_INTEGER = new byte[]{7, 58, 107, 81, 80, 92, 80, -16};
    private static final byte[] MAX_LONG = new byte[]{11, -54, -119, -106, -95, -56, -125, -60, -74, -51, -70, -121};
    private static final byte[] MIN_LONG = new byte[]{12, 53, 119, 106, 95, 56, 125, 60, 74, 51, 70, 120, -16};
    private static char[][] coefToChar = new char[][]{{'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'9', '9'}, {'9', '8'}, {'9', '7'}, {'9', '6'}, {'9', '5'}, {'9', '4'}, {'9', '3'}, {'9', '2'}, {'9', '1'}, {'9', '0'}, {'8', '9'}, {'8', '8'}, {'8', '7'}, {'8', '6'}, {'8', '5'}, {'8', '4'}, {'8', '3'}, {'8', '2'}, {'8', '1'}, {'8', '0'}, {'7', '9'}, {'7', '8'}, {'7', '7'}, {'7', '6'}, {'7', '5'}, {'7', '4'}, {'7', '3'}, {'7', '2'}, {'7', '1'}, {'7', '0'}, {'6', '9'}, {'6', '8'}, {'6', '7'}, {'6', '6'}, {'6', '5'}, {'6', '4'}, {'6', '3'}, {'6', '2'}, {'6', '1'}, {'6', '0'}, {'5', '9'}, {'5', '8'}, {'5', '7'}, {'5', '6'}, {'5', '5'}, {'5', '4'}, {'5', '3'}, {'5', '2'}, {'5', '1'}, {'5', '0'}, {'4', '9'}, {'4', '8'}, {'4', '7'}, {'4', '6'}, {'4', '5'}, {'4', '4'}, {'4', '3'}, {'4', '2'}, {'4', '1'}, {'4', '0'}, {'3', '9'}, {'3', '8'}, {'3', '7'}, {'3', '6'}, {'3', '5'}, {'3', '4'}, {'3', '3'}, {'3', '2'}, {'3', '1'}, {'3', '0'}, {'2', '9'}, {'2', '8'}, {'2', '7'}, {'2', '6'}, {'2', '5'}, {'2', '4'}, {'2', '3'}, {'2', '2'}, {'2', '1'}, {'2', '0'}, {'1', '9'}, {'1', '8'}, {'1', '7'}, {'1', '6'}, {'1', '5'}, {'1', '4'}, {'1', '3'}, {'1', '2'}, {'1', '1'}, {'1', '0'}, {'0', '9'}, {'0', '8'}, {'0', '7'}, {'0', '6'}, {'0', '5'}, {'0', '4'}, {'0', '3'}, {'0', '2'}, {'0', '1'}, {'0', '0'}, {'0', '1'}, {'0', '2'}, {'0', '3'}, {'0', '4'}, {'0', '5'}, {'0', '6'}, {'0', '7'}, {'0', '8'}, {'0', '9'}, {'1', '0'}, {'1', '1'}, {'1', '2'}, {'1', '3'}, {'1', '4'}, {'1', '5'}, {'1', '6'}, {'1', '7'}, {'1', '8'}, {'1', '9'}, {'2', '0'}, {'2', '1'}, {'2', '2'}, {'2', '3'}, {'2', '4'}, {'2', '5'}, {'2', '6'}, {'2', '7'}, {'2', '8'}, {'2', '9'}, {'3', '0'}, {'3', '1'}, {'3', '2'}, {'3', '3'}, {'3', '4'}, {'3', '5'}, {'3', '6'}, {'3', '7'}, {'3', '8'}, {'3', '9'}, {'4', '0'}, {'4', '1'}, {'4', '2'}, {'4', '3'}, {'4', '4'}, {'4', '5'}, {'4', '6'}, {'4', '7'}, {'4', '8'}, {'4', '9'}, {'5', '0'}, {'5', '1'}, {'5', '2'}, {'5', '3'}, {'5', '4'}, {'5', '5'}, {'5', '6'}, {'5', '7'}, {'5', '8'}, {'5', '9'}, {'6', '0'}, {'6', '1'}, {'6', '2'}, {'6', '3'}, {'6', '4'}, {'6', '5'}, {'6', '6'}, {'6', '7'}, {'6', '8'}, {'6', '9'}, {'7', '0'}, {'7', '1'}, {'7', '2'}, {'7', '3'}, {'7', '4'}, {'7', '5'}, {'7', '6'}, {'7', '7'}, {'7', '8'}, {'7', '9'}, {'8', '0'}, {'8', '1'}, {'8', '2'}, {'8', '3'}, {'8', '4'}, {'8', '5'}, {'8', '6'}, {'8', '7'}, {'8', '8'}, {'8', '9'}, {'9', '0'}, {'9', '1'}, {'9', '2'}, {'9', '3'}, {'9', '4'}, {'9', '5'}, {'9', '6'}, {'9', '7'}, {'9', '8'}, {'9', '9'}};

    private static int convertCoef(byte[] byArray, int n, char[] cArray, int n2, int n3) {
        int n4;
        int n5 = 0;
        int n6 = byArray[n + 2];
        if (n6 < 0) {
            n6 += 256;
        }
        char[] cArray2 = coefToChar[n6];
        cArray[n2 + n5] = cArray2[0];
        if (cArray2[0] != '0') {
            // empty if block
        }
        int n7 = ++n5;
        ++n5;
        cArray[n2 + n7] = cArray2[1];
        int n8 = TbNumber.getSiglen(byArray, n);
        for (n4 = 1; n4 < n8; ++n4) {
            n6 = byArray[n + 2 + n4];
            if (n6 < 0) {
                n6 += 256;
            }
            cArray2 = coefToChar[n6];
            cArray[n2 + n5++] = cArray2[0];
            cArray[n2 + n5++] = cArray2[1];
        }
        if (cArray[n2 + n5 - 1] == '0') {
            --n5;
        }
        if (n3 > 0 && n3 < n5) {
            for (n4 = n2 + n5; n4 >= n3 + n2; --n4) {
                cArray[n4 + 1] = cArray[n4];
            }
            cArray[n2 + n3] = 46;
            ++n5;
        }
        return n5;
    }

    private static int convertExp(int n, int n2, char[] cArray) {
        int n3;
        boolean bl = false;
        int n4 = n = n < 0 ? -n : n;
        if (n >= 0 && n < 10) {
            cArray[n2++] = 48;
            bl = true;
        }
        String string = Integer.toString(n);
        for (n3 = 0; n3 < string.length(); ++n3) {
            cArray[n2 + n3] = string.charAt(n3);
        }
        return n3 + (bl ? 1 : 0);
    }

    private static byte digitEncode(boolean bl, int n) {
        return bl ? (byte)(128 + n) : (byte)(128 - n);
    }

    public static int fromInteger(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int[] nArray = new int[21];
        boolean bl = n2 >= 0;
        int n4 = 0;
        while (n2 != 0) {
            int n5 = n2 / 100;
            nArray[n4] = n2 - 100 * n5;
            n2 = n5;
            ++n4;
        }
        if (n4 == 0) {
            return TbNumber.toZero(byArray, n);
        }
        if (bl) {
            for (int i = 0; i < n4; ++i) {
                byArray[n + 2 + i] = (byte)(128 + nArray[n4 - i - 1]);
                if (nArray[n4 - i - 1] == 0) continue;
                n3 = i;
            }
            byArray[n + 1] = (byte)(0x80 | (byte)(65 + (n4 - 1)));
            n4 = n3 + 1;
        } else {
            for (int i = 0; i < n4; ++i) {
                byArray[n + 2 + i] = (byte)(128 - -nArray[n4 - i - 1]);
                if (nArray[n4 - i - 1] == 0) continue;
                n3 = i;
            }
            byArray[n + 1] = (byte)(62 - (n4 - 1));
            n4 = n3 + 1;
            byArray[n + 2 + n4] = -16;
            ++n4;
        }
        byArray[n] = (byte)(n4 + 1);
        return n4 + 2;
    }

    public static byte[] fromInteger(int n) throws SQLException {
        int n2 = 0;
        int[] nArray = new int[21];
        boolean bl = n >= 0;
        int n3 = 0;
        while (n != 0) {
            int n4 = n / 100;
            nArray[n3] = n - 100 * n4;
            n = n4;
            ++n3;
        }
        if (n3 == 0) {
            return TbNumber.toZero();
        }
        byte[] byArray = new byte[23];
        if (bl) {
            for (int i = 0; i < n3; ++i) {
                byArray[2 + i] = (byte)(128 + nArray[n3 - i - 1]);
                if (nArray[n3 - i - 1] == 0) continue;
                n2 = i;
            }
            byArray[1] = (byte)(0x80 | (byte)(65 + (n3 - 1)));
            n3 = n2 + 1;
        } else {
            for (int i = 0; i < n3; ++i) {
                byArray[2 + i] = (byte)(128 - -nArray[n3 - i - 1]);
                if (nArray[n3 - i - 1] == 0) continue;
                n2 = i;
            }
            byArray[1] = (byte)(62 - (n3 - 1));
            n3 = n2 + 1;
            byArray[2 + n3] = -16;
            ++n3;
        }
        byArray[0] = (byte)(n3 + 1);
        return byArray;
    }

    public static int fromLong(byte[] byArray, int n, long l) throws SQLException {
        int n2 = 0;
        int[] nArray = new int[21];
        boolean bl = l >= 0L;
        int n3 = 0;
        while (l != 0L) {
            long l2 = l / 100L;
            nArray[n3] = (int)(l - 100L * l2);
            l = l2;
            ++n3;
        }
        if (n3 == 0) {
            return TbNumber.toZero(byArray, n);
        }
        if (bl) {
            for (int i = 0; i < n3; ++i) {
                byArray[n + 2 + i] = (byte)(128 + nArray[n3 - i - 1]);
                if (nArray[n3 - i - 1] == 0) continue;
                n2 = i;
            }
            byArray[n + 1] = (byte)(0x80 | 65 + (n3 - 1));
            n3 = n2 + 1;
        } else {
            for (int i = 0; i < n3; ++i) {
                byArray[n + 2 + i] = (byte)(128 - -nArray[n3 - i - 1]);
                if (nArray[n3 - i - 1] == 0) continue;
                n2 = i;
            }
            byArray[n + 1] = (byte)(62 - (n3 - 1));
            n3 = n2 + 1;
            byArray[n + 2 + n3] = -16;
            ++n3;
        }
        byArray[n] = (byte)(n3 + 1);
        return n3 + 2;
    }

    public static byte[] fromLong(long l) throws SQLException {
        int n = 0;
        int[] nArray = new int[21];
        boolean bl = l >= 0L;
        int n2 = 0;
        while (l != 0L) {
            long l2 = l / 100L;
            nArray[n2] = (int)(l - 100L * l2);
            l = l2;
            ++n2;
        }
        if (n2 == 0) {
            return TbNumber.toZero();
        }
        byte[] byArray = new byte[23];
        if (bl) {
            for (int i = 0; i < n2; ++i) {
                byArray[2 + i] = (byte)(128 + nArray[n2 - i - 1]);
                if (nArray[n2 - i - 1] == 0) continue;
                n = i;
            }
            byArray[1] = (byte)(0x80 | 65 + (n2 - 1));
            n2 = n + 1;
        } else {
            for (int i = 0; i < n2; ++i) {
                byArray[2 + i] = (byte)(128 - -nArray[n2 - i - 1]);
                if (nArray[n2 - i - 1] == 0) continue;
                n = i;
            }
            byArray[1] = (byte)(62 - (n2 - 1));
            n2 = n + 1;
            byArray[2 + n2] = -16;
            ++n2;
        }
        byArray[0] = (byte)(n2 + 1);
        return byArray;
    }

    public static int fromString(byte[] byArray, int n, String string) throws SQLException {
        byte[] byArray2 = new byte[41];
        byte by = 0;
        StringReader stringReader = new StringReader(string);
        try {
            int n2;
            int n3;
            boolean bl;
            int n4;
            int n5 = 0;
            int n6 = -1;
            int n7 = 0;
            char c = (char)stringReader.read();
            boolean bl2 = true;
            if (c == '-') {
                bl2 = false;
                c = (char)stringReader.read();
            } else if (c == '+') {
                c = (char)stringReader.read();
            }
            while (c == '0') {
                c = (char)stringReader.read();
            }
            while (Character.isDigit(c)) {
                if (n5 < 40) {
                    byArray2[n5] = (byte)Character.getNumericValue(c);
                    if (c != '0') {
                        n6 = n5;
                    }
                } else if (n5 == 40) {
                    by = (byte)Character.getNumericValue(c);
                }
                ++n5;
                c = (char)stringReader.read();
            }
            int n8 = n5;
            if (c == '.') {
                c = (char)stringReader.read();
                if (n6 < 0) {
                    while (c == '0') {
                        ++n7;
                        c = (char)stringReader.read();
                    }
                }
                while (Character.isDigit(c)) {
                    if (n5 < 40) {
                        byArray2[n5] = (byte)Character.getNumericValue(c);
                        if (c != '0') {
                            n6 = n5;
                        }
                    } else if (n5 == 40) {
                        by = (byte)Character.getNumericValue(c);
                    }
                    ++n5;
                    c = (char)stringReader.read();
                }
            }
            int n9 = 0;
            boolean bl3 = false;
            if (c == 'e' | c == 'E') {
                c = (char)stringReader.read();
                if (c == '-') {
                    bl3 = true;
                    c = (char)stringReader.read();
                } else if (c == '+') {
                    c = (char)stringReader.read();
                }
                n9 = 0;
                while (Character.isDigit(c)) {
                    n9 = n9 * 10 + Character.getNumericValue(c);
                    c = (char)stringReader.read();
                }
            }
            if (n6 < 0) {
                return TbNumber.toZero(byArray, n);
            }
            int n10 = n4 = n8 > 0 ? n8 - 1 : -(n7 + 1);
            if (bl3) {
                n9 = -n9;
            }
            boolean bl4 = bl = ((n9 += n4) & 1) == 0;
            if (bl && n5 >= 40) {
                by = byArray2[39];
            }
            if ((n3 = n9 >> 1) > 62) {
                throw TbError.newSQLException(-90653, string);
            }
            if (n3 < -65) {
                throw TbError.newSQLException(-90654, string);
            }
            int n11 = 1 + (bl2 ? 0 : 1) + (n6 + 1 + 1 + (bl ? 1 : 0)) / 2;
            byArray[n] = (byte)n11;
            byArray[n + 1] = bl2 ? (byte)(0x80 | 65 + n3) : (byte)(62 - n3);
            boolean bl5 = bl;
            int n12 = 0;
            int n13 = 2;
            for (int i = 0; i <= n6; ++i) {
                if (bl5) {
                    byArray[n + n13++] = TbNumber.digitEncode(bl2, n12 + byArray2[i]);
                } else {
                    n12 = byArray2[i] * 10;
                }
                bl5 = !bl5;
            }
            if (bl5) {
                byArray[n + n13++] = TbNumber.digitEncode(bl2, n12);
            }
            if (!bl2) {
                byArray[n + n13++] = -16;
            }
            if (bl2 && n11 >= 21) {
                n11 = 21;
                byArray[n] = (byte)n11;
            } else if (!bl2 && n11 >= 22) {
                n11 = 22;
                byArray[n] = (byte)n11;
                byArray[n + 21 + 1] = -16;
            }
            if (by >= 5) {
                TbNumber.roundingAt41Prec(byArray, n, bl2, n11, n3, string);
            }
            int n14 = bl2 ? 0 : 1;
            for (n2 = n11 - n14; n2 >= 2 && byArray[n + n2] == -128; --n2) {
            }
            if (n2 < n11 - n14) {
                if (n2 < 2) {
                    byArray[n] = 1;
                    return 2;
                }
                byArray[n + n2 + 1] = -16;
                byArray[n] = (byte)(n2 + n14);
                return n2 + n14 + 1;
            }
            return n11 + 1;
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    public static byte[] fromString(String string) throws SQLException {
        byte[] byArray = new byte[41];
        byte by = 0;
        StringReader stringReader = new StringReader(string);
        try {
            int n;
            int n2;
            boolean bl;
            int n3;
            int n4 = 0;
            int n5 = -1;
            int n6 = 0;
            char c = (char)stringReader.read();
            boolean bl2 = true;
            if (c == '-') {
                bl2 = false;
                c = (char)stringReader.read();
            } else if (c == '+') {
                c = (char)stringReader.read();
            }
            while (c == '0') {
                c = (char)stringReader.read();
            }
            while (Character.isDigit(c)) {
                if (n4 < 40) {
                    byArray[n4] = (byte)Character.getNumericValue(c);
                    if (c != '0') {
                        n5 = n4;
                    }
                } else if (n4 == 40) {
                    by = (byte)Character.getNumericValue(c);
                }
                ++n4;
                c = (char)stringReader.read();
            }
            int n7 = n4;
            if (c == '.') {
                c = (char)stringReader.read();
                if (n5 < 0) {
                    while (c == '0') {
                        ++n6;
                        c = (char)stringReader.read();
                    }
                }
                while (Character.isDigit(c)) {
                    if (n4 < 40) {
                        byArray[n4] = (byte)Character.getNumericValue(c);
                        if (c != '0') {
                            n5 = n4;
                        }
                    } else if (n4 == 40) {
                        by = (byte)Character.getNumericValue(c);
                    }
                    ++n4;
                    c = (char)stringReader.read();
                }
            }
            int n8 = 0;
            boolean bl3 = false;
            if (c == 'e' | c == 'E') {
                c = (char)stringReader.read();
                if (c == '-') {
                    bl3 = true;
                    c = (char)stringReader.read();
                } else if (c == '+') {
                    c = (char)stringReader.read();
                }
                n8 = 0;
                while (Character.isDigit(c)) {
                    n8 = n8 * 10 + Character.getNumericValue(c);
                    c = (char)stringReader.read();
                }
            }
            if (n5 < 0) {
                return TbNumber.toZero();
            }
            int n9 = n3 = n7 > 0 ? n7 - 1 : -(n6 + 1);
            if (bl3) {
                n8 = -n8;
            }
            boolean bl4 = bl = ((n8 += n3) & 1) == 0;
            if (bl && n4 >= 40) {
                by = byArray[39];
            }
            if ((n2 = n8 >> 1) > 62) {
                throw TbError.newSQLException(-90653, string);
            }
            if (n2 < -65) {
                throw TbError.newSQLException(-90654, string);
            }
            int n10 = 1 + (bl2 ? 0 : 1) + (n5 + 1 + 1 + (bl ? 1 : 0)) / 2;
            byte[] byArray2 = new byte[n10 + 1];
            byArray2[0] = (byte)n10;
            byArray2[1] = bl2 ? (byte)(0x80 | 65 + n2) : (byte)(62 - n2);
            boolean bl5 = bl;
            int n11 = 0;
            int n12 = 2;
            for (int i = 0; i <= n5; ++i) {
                if (bl5) {
                    byArray2[n12++] = TbNumber.digitEncode(bl2, n11 + byArray[i]);
                } else {
                    n11 = byArray[i] * 10;
                }
                bl5 = !bl5;
            }
            if (bl5) {
                byArray2[n12++] = TbNumber.digitEncode(bl2, n11);
            }
            if (!bl2) {
                byArray2[n12++] = -16;
            }
            if (bl2 && n10 >= 21) {
                n10 = 21;
                byArray2[0] = (byte)n10;
            } else if (!bl2 && n10 >= 22) {
                n10 = 22;
                byArray2[0] = (byte)n10;
                byArray2[22] = -16;
            }
            if (by >= 5) {
                TbNumber.roundingAt41Prec(byArray2, 0, bl2, n10, n2, string);
            }
            int n13 = bl2 ? 0 : 1;
            for (n = n10 - n13; n >= 2 && byArray2[n] == -128; --n) {
            }
            if (n < n10 - n13) {
                if (n < 2) {
                    byArray2[0] = 1;
                } else {
                    byArray2[n + 1] = -16;
                    byArray2[0] = (byte)(n + n13);
                }
            }
            return byArray2;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static void roundingAt41Prec(byte[] byArray, int n, boolean bl, int n2, int n3, String string) throws SQLException {
        int n4;
        int n5 = 21;
        if (bl) {
            int n6 = TbNumber.getDecoPos(byArray[n + n5]) + 1;
            n4 = n6 >= 100 ? 1 : 0;
            byArray[n + n5--] = TbNumber.digitEncode(bl, n6 -= n4 * 100);
            if (n4 == 1) {
                while (n5 > 1) {
                    n6 = TbNumber.getDecoPos(byArray[n + n5]) + 1;
                    n4 = n6 >= 100 ? 1 : 0;
                    byArray[n + n5--] = TbNumber.digitEncode(bl, n6 -= n4 * 100);
                }
            }
        } else {
            int n7 = TbNumber.getDecoNeg(byArray[n + n5]) + 1;
            n4 = n7 >= 100 ? 1 : 0;
            byArray[n + n5--] = TbNumber.digitEncode(bl, n7 -= n4 * 100);
            if (n4 == 1) {
                while (n5 > 1) {
                    n7 = TbNumber.getDecoNeg(byArray[n + n5]) + 1;
                    n4 = n7 >= 100 ? 1 : 0;
                    byArray[n + n5--] = TbNumber.digitEncode(bl, n7 -= n4 * 100);
                }
            }
        }
        if (n4 == 1) {
            System.arraycopy(byArray, n + 2, byArray, n + 3, 19);
            byArray[n + 2] = TbNumber.digitEncode(bl, 1);
            byArray[n + 1] = bl ? (byte)(0x80 | 65 + TbNumber.getExpPos(byArray[n + 1]) + 1) : (byte)(62 - TbNumber.getExpNeg(byArray[n + 1]) - 1);
            if (!bl) {
                byArray[n + 21] = -16;
            }
            if (n3 + 1 > 62) {
                throw TbError.newSQLException(-90653, string);
            }
            if (n3 + 1 < -65) {
                throw TbError.newSQLException(-90654, string);
            }
        }
    }

    private static int getDecoNeg(byte by) {
        int n = 128 - by;
        return n < 0 ? n + 256 : n;
    }

    private static int getDecoPos(byte by) {
        int n = by - 128;
        return n < 0 ? n + 256 : n;
    }

    private static int getExpNeg(byte n) {
        int n2 = n < 0 ? n + 256 : n;
        return 62 - (n2 & 0x7F);
    }

    private static int getExpPos(byte n) {
        int n2 = n < 0 ? n + 256 : n;
        return (n2 & 0x7F) - 65;
    }

    public static String getNormalForm(byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        char[] cArray = null;
        if (byArray[n] == 1) {
            return "0";
        }
        boolean bl = TbNumber.isPositive(byArray[n + 1]);
        if (bl) {
            n6 = (TbNumber.getExpPos(byArray[n + 1]) << 1) + (TbNumber.getDecoPos(byArray[n + 2]) >= 10 ? 1 : 0);
            n5 = (TbNumber.getSiglen(byArray, n) << 1) - (TbNumber.getDecoPos(byArray[n + 2]) < 10 ? 1 : 0) - TbNumber.lastHalfFilledPos(byArray, n);
        } else {
            n6 = (TbNumber.getExpNeg(byArray[n + 1]) << 1) + (TbNumber.getDecoNeg(byArray[n + 2]) >= 10 ? 1 : 0);
            n5 = (TbNumber.getSiglen(byArray, n) << 1) - (TbNumber.getDecoNeg(byArray[n + 2]) < 10 ? 1 : 0) - TbNumber.lastHalfFilledNeg(byArray, n);
        }
        int n7 = n6 >= 0 ? (bl ? 0 : 1) + (n5 <= n6 + 1 ? n6 + 1 + 0 + 0 : n6 + 1 + 1 + (n5 - (n6 + 1))) + 1 : (bl ? 0 : 1) + 1 + (-n6 - 1) + n5 + 1;
        cArray = new char[n7 + 1];
        int n8 = 0;
        if (!bl) {
            cArray[n8++] = 45;
        }
        if ((n4 = n6 + 1) <= 0) {
            cArray[n8++] = 48;
            cArray[n8++] = 46;
            for (n3 = 0; n3 < -n4; ++n3) {
                cArray[n8++] = 48;
            }
        }
        int n9 = TbNumber.convertCoef(byArray, n, cArray, n8, n4);
        n8 += n9;
        if (n4 > n9) {
            for (n3 = 0; n3 < n4 - n9; ++n3) {
                cArray[n8++] = 48;
            }
        }
        return new String(cArray, 0, n8);
    }

    public static String getRoughSciForm(byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        if (byArray[n] == 1) {
            return "0E+00";
        }
        boolean bl = TbNumber.isPositive(byArray[n + 1]);
        if (bl) {
            n4 = (TbNumber.getExpPos(byArray[n + 1]) << 1) + (TbNumber.getDecoPos(byArray[n + 2]) >= 10 ? 1 : 0);
            n3 = (TbNumber.getSiglen(byArray, n) << 1) - (TbNumber.getDecoPos(byArray[n + 2]) < 10 ? 1 : 0) - TbNumber.lastHalfFilledPos(byArray, n);
        } else {
            n4 = (TbNumber.getExpNeg(byArray[n + 1]) << 1) + (TbNumber.getDecoNeg(byArray[n + 2]) >= 10 ? 1 : 0);
            n3 = (TbNumber.getSiglen(byArray, n) << 1) - (TbNumber.getDecoNeg(byArray[n + 2]) < 10 ? 1 : 0) - TbNumber.lastHalfFilledNeg(byArray, n);
        }
        int n5 = n4 >= 100 || n4 <= -100 ? 3 : 2;
        int n6 = (bl ? 0 : 1) + n3 + (n3 > 1 ? 1 : 0) + 1 + 1 + n5 + 1;
        char[] cArray = new char[n6];
        int n7 = 0;
        if (!bl) {
            cArray[n7++] = 45;
        }
        n7 += TbNumber.convertCoef(byArray, n, cArray, n7, 1);
        cArray[n7++] = 69;
        cArray[n7++] = n4 >= 0 ? 43 : 45;
        n7 += TbNumber.convertExp(n4, n7, cArray);
        return new String(cArray, 0, n7);
    }

    public static int getSiglen(byte[] byArray, int n) {
        int n2 = byArray[n + 1];
        if (n2 < 0) {
            n2 += 256;
        }
        return byArray[n] - 1 - ((~n2 & 0x80) >> 7);
    }

    public static boolean isOrdinary(byte[] byArray, int n) {
        return byArray[n] == 1 || byArray[n + 2] != -16 && byArray[n + 2] != 16;
    }

    private static boolean isPositive(byte by) {
        if (by < 0) {
            by = (byte)(by + 256);
        }
        return (by & 0x80) != 0;
    }

    public static boolean isValid(byte[] byArray, int n) {
        byte by = byArray[n];
        int n2 = byArray[n + 1];
        if (by > 23) {
            return false;
        }
        if (n2 < 0) {
            n2 += 256;
        }
        switch (by) {
            case 0: {
                break;
            }
            case 1: {
                if (n2 != 128) break;
                return true;
            }
            case 2: {
                if (byArray[n + 2] == 240 && (n2 == 255 || n2 == 127)) {
                    return true;
                }
                if (byArray[n + 2] == 16 && (n2 == 128 || n2 == 0)) {
                    return true;
                }
            }
            default: {
                if (n2 >= 128 && n2 <= 255) {
                    int n3 = by - 2;
                    for (int i = 0; i <= n3; ++i) {
                        int n4 = byArray[n + 2 + i];
                        if (n4 < 0) {
                            n4 += 256;
                        }
                        if (n4 >= 128 && n4 <= 227) continue;
                        return false;
                    }
                    return true;
                }
                if (n2 < 0 || n2 > 127) break;
                int n5 = by - 2;
                for (int i = 0; i < n5; ++i) {
                    int n6 = byArray[n + 2 + i];
                    if (n6 < 0) {
                        n6 += 256;
                    }
                    if (n6 >= 29 && n6 <= 128) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private static int lastHalfFilledNeg(byte[] byArray, int n) {
        int n2 = 128 - byArray[n + 2 + TbNumber.getSiglen(byArray, n) - 1];
        if (n2 < 0) {
            n2 += 256;
        }
        return n2 % 10 == 0 ? 1 : 0;
    }

    private static int lastHalfFilledPos(byte[] byArray, int n) {
        int n2 = byArray[n + 2 + TbNumber.getSiglen(byArray, n) - 1] - 128;
        if (n2 < 0) {
            n2 += 256;
        }
        return n2 % 10 == 0 ? 1 : 0;
    }

    private static boolean lessThanOrEqualTo(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = byArray[n] <= byArray2[n2] ? byArray[n] : byArray2[n2];
        for (int i = 1; i <= n3; ++i) {
            if ((byte)(128 + byArray[n + i]) < (byte)(128 + byArray2[n2 + i])) {
                return true;
            }
            if ((byte)(128 + byArray[n + i]) <= (byte)(128 + byArray2[n2 + i])) continue;
            return false;
        }
        return byArray[n] <= byArray2[n2];
    }

    public static BigDecimal toBigDecimal(byte[] byArray, int n, int n2) throws SQLException {
        if (!TbNumber.isOrdinary(byArray, n)) {
            throw TbError.newSQLException(-590705);
        }
        String string = TbNumber.getNormalForm(byArray, n, n2);
        return new BigDecimal(string);
    }

    public static double toDouble(byte[] byArray, int n, int n2) throws SQLException {
        String string = TbNumber.getRoughSciForm(byArray, n, n2);
        return Double.valueOf(string);
    }

    public static double toBinaryDouble(byte[] byArray, int n, int n2) throws SQLException {
        double d;
        if (TbCommon.isPositiveInfinityDoubleBytes(byArray, n, n2)) {
            return Double.POSITIVE_INFINITY;
        }
        if (TbCommon.isNegativeInfinityDoubleBytes(byArray, n, n2)) {
            return Double.NEGATIVE_INFINITY;
        }
        if (TbCommon.isMaxValueDoubleBytes(byArray, n, n2)) {
            return Double.MAX_VALUE;
        }
        if (TbCommon.isMinValueDoubleBytes(byArray, n, n2)) {
            return Double.MIN_VALUE;
        }
        if (TbCommon.isNanDoubleBytes(byArray, n, n2)) {
            return Double.NaN;
        }
        if (TbCommon.isNegativeZeroDoubleBytes(byArray, n, n2)) {
            return 0.0;
        }
        long l = TbCommon.bytes2Long(byArray, n, n2);
        if (l < 0L) {
            d = Double.longBitsToDouble(l);
            d *= -1.0;
        } else {
            d = l > 0L ? Double.longBitsToDouble(l ^= 0xFFFFFFFFFFFFFFFFL) : Double.longBitsToDouble(l);
        }
        return d;
    }

    public static float toBinaryFloat(byte[] byArray, int n, int n2) {
        float f;
        if (TbCommon.isPositiveInfinityFloatBytes(byArray, n, n2)) {
            return Float.POSITIVE_INFINITY;
        }
        if (TbCommon.isNegativeInfinityFloatBytes(byArray, n, n2)) {
            return Float.NEGATIVE_INFINITY;
        }
        if (TbCommon.isMaxValueFloatBytes(byArray, n, n2)) {
            return Float.MAX_VALUE;
        }
        if (TbCommon.isMinValueFloatBytes(byArray, n, n2)) {
            return Float.MIN_VALUE;
        }
        if (TbCommon.isNanFloatBytes(byArray, n, n2)) {
            return Float.NaN;
        }
        if (TbCommon.isNegativeZeroFloatBytes(byArray, n, n2)) {
            return 0.0f;
        }
        int n3 = TbCommon.bytes2Int(byArray, n, n2);
        if (n3 < 0) {
            f = Float.intBitsToFloat(n3);
            f *= -1.0f;
        } else {
            f = n3 > 0 ? Float.intBitsToFloat(n3 ^= 0xFFFFFFFF) : Float.intBitsToFloat(n3);
        }
        return f;
    }

    public static int toInteger(byte[] byArray, int n, int n2) throws SQLException {
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        if (byArray[n] == 1) {
            return 0;
        }
        if (!TbNumber.isOrdinary(byArray, n)) {
            throw TbError.newSQLException(-590705);
        }
        if (!TbNumber.lessThanOrEqualTo(MIN_INTEGER, 0, byArray, n)) {
            throw TbError.newSQLException(-90654);
        }
        if (!TbNumber.lessThanOrEqualTo(byArray, n, MAX_INTEGER, 0)) {
            throw TbError.newSQLException(-90653);
        }
        boolean bl = TbNumber.isPositive(byArray[n + 1]);
        if (bl) {
            n5 = TbNumber.getExpPos(byArray[n + 1]);
            n4 = TbNumber.getSiglen(byArray, n);
            n4 = n4 > n5 + 1 ? n5 + 1 : n4;
            for (n3 = 0; n3 < n4; ++n3) {
                n6 = n6 * 100 + TbNumber.getDecoPos(byArray[n + 2 + n3]);
            }
        } else {
            n5 = TbNumber.getExpNeg(byArray[n + 1]);
            n4 = TbNumber.getSiglen(byArray, n);
            n4 = n4 > n5 + 1 ? n5 + 1 : n4;
            for (n3 = 0; n3 < n4; ++n3) {
                n6 = n6 * 100 + TbNumber.getDecoNeg(byArray[n + 2 + n3]);
            }
        }
        for (n3 = 0; n3 < n5 + 1 - n4; ++n3) {
            n6 *= 100;
        }
        return bl ? n6 : -n6;
    }

    public static long toLong(byte[] byArray, int n, int n2) throws SQLException {
        int n3;
        int n4;
        int n5;
        long l = 0L;
        if (byArray[n] == 1) {
            return 0L;
        }
        if (!TbNumber.isOrdinary(byArray, n)) {
            throw TbError.newSQLException(-590705);
        }
        if (!TbNumber.lessThanOrEqualTo(MIN_LONG, 0, byArray, n)) {
            throw TbError.newSQLException(-90654);
        }
        if (!TbNumber.lessThanOrEqualTo(byArray, n, MAX_LONG, 0)) {
            throw TbError.newSQLException(-90653);
        }
        boolean bl = TbNumber.isPositive(byArray[n + 1]);
        if (bl) {
            n5 = TbNumber.getExpPos(byArray[n + 1]);
            n4 = TbNumber.getSiglen(byArray, n);
            n4 = n4 > n5 + 1 ? n5 + 1 : n4;
            for (n3 = 0; n3 < n4; ++n3) {
                l = l * 100L + (long)TbNumber.getDecoPos(byArray[n + 2 + n3]);
            }
        } else {
            n5 = TbNumber.getExpNeg(byArray[n + 1]);
            n4 = TbNumber.getSiglen(byArray, n);
            n4 = n4 > n5 + 1 ? n5 + 1 : n4;
            for (n3 = 0; n3 < n4; ++n3) {
                l = l * 100L + (long)TbNumber.getDecoNeg(byArray[n + 2 + n3]);
            }
        }
        for (n3 = 0; n3 < n5 + 1 - n4; ++n3) {
            l *= 100L;
        }
        return bl ? l : -l;
    }

    private static byte[] toZero() {
        return new byte[]{1, -128};
    }

    private static int toZero(byte[] byArray, int n) {
        byArray[n] = 1;
        byArray[n + 1] = -128;
        return 2;
    }

    private TbNumber() {
    }
}

