/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data;

public class StreamBuffer {
    private byte[] rawBytes;
    private int initSize;
    private int curSize;
    private int curDataSize;

    public StreamBuffer(int n) {
        this.rawBytes = new byte[n];
        this.initSize = n;
        this.curSize = n;
        this.curDataSize = 0;
    }

    public StreamBuffer(byte[] byArray) {
        this.rawBytes = byArray;
        this.initSize = byArray.length;
        this.curSize = byArray.length;
        this.curDataSize = 0;
    }

    public void copyMultiBytes(int n, int n2, byte[] byArray) {
        this.makeBufferAvailable(n);
        System.arraycopy(byArray, n2, this.rawBytes, this.curDataSize, n);
        this.moveOffset(n);
    }

    public void copySingleByte(byte by) {
        this.makeBufferAvailable(1);
        this.rawBytes[this.curDataSize++] = by;
    }

    public void delete() {
        this.initSize = 0;
        this.reset();
    }

    public int getCurDataSize() {
        return this.curDataSize;
    }

    public byte[] getRawBytes() {
        return this.rawBytes;
    }

    public int getRemained() {
        return this.curSize - this.curDataSize;
    }

    public int getSize() {
        return this.curSize;
    }

    public void growDoubleUp(int n) {
        int n2 = n > this.curSize ? n + this.curSize : this.curSize * 2;
        byte[] byArray = this.rawBytes;
        this.rawBytes = new byte[n2];
        System.arraycopy(byArray, 0, this.rawBytes, 0, this.curDataSize);
        byArray = null;
        this.curSize = n2;
    }

    public void init() {
        this.curDataSize = 0;
        if (this.rawBytes == null) {
            this.resize(this.curSize);
        }
    }

    public void init(int n) {
        if (this.curSize < n) {
            this.resize(n);
        } else {
            this.init();
        }
    }

    public void makeBufferAvailable(int n) {
        if (this.curDataSize + n > this.curSize) {
            this.growDoubleUp(n);
        }
    }

    public void moveOffset(int n) {
        this.curDataSize += n;
    }

    public void putData(int n, byte by) {
        this.makeBufferAvailable(n);
        for (int i = 0; i < n; ++i) {
            this.rawBytes[this.curDataSize + i] = by;
        }
        this.moveOffset(n);
    }

    public void reset() {
        this.rawBytes = null;
        this.curSize = 0;
        this.curDataSize = 0;
    }

    public void resize(int n) {
        this.rawBytes = new byte[n];
        this.curSize = n;
        this.curDataSize = 0;
    }

    public void setCurDataSize(int n) {
        this.curDataSize = n;
    }
}

