/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data;

import com.tmax.tibero.jdbc.TbAnydata;
import com.tmax.tibero.jdbc.data.TbDate;
import com.tmax.tibero.jdbc.data.TbTimestamp;
import com.tmax.tibero.jdbc.err.TbError;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;

public class DataType {
    public static final int NONE = 0;
    public static final int NUMBER = 1;
    public static final int CHAR = 2;
    public static final int VARCHAR = 3;
    public static final int RAW = 4;
    public static final int DATE = 5;
    public static final int TIME = 6;
    public static final int TIMESTAMP = 7;
    public static final int TIMESTAMP_TZ = 21;
    public static final int TIMESTAMP_LTZ = 22;
    public static final int ITV_YTM = 8;
    public static final int ITV_DTS = 9;
    public static final int LONG = 10;
    public static final int LONGRAW = 11;
    public static final int BLOB = 12;
    public static final int CLOB = 13;
    public static final int BFILE = 14;
    public static final int ROWID = 15;
    public static final int CURSOR = 16;
    public static final int UNKNOWN = 17;
    public static final int NCHAR = 18;
    public static final int NVARCHAR = 19;
    public static final int NCLOB = 20;
    public static final int BIN_FLOAT = 23;
    public static final int BIN_DOUBLE = 24;
    public static final int BOOLEAN = 25;
    public static final int PLS_INT = 26;
    public static final int BIN_INT = 27;
    public static final int RECORD = 28;
    public static final int VARRAY = 29;
    public static final int TABLE = 30;
    public static final int IDX_BY_TBL = 31;
    public static final int OBJECT = 32;
    public static final int REF = 33;
    public static final int JSON = 34;
    public static final int LGEOMETRY = 1;
    public static final int LXML = 2;
    public static final int LPIVOT = 3;

    private DataType() {
    }

    public static void checkValidDataType(int n) throws SQLException {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: {
                break;
            }
            default: {
                throw TbError.newSQLException(-590703, Integer.toString(n));
            }
        }
    }

    public static int getDataType(int n) throws SQLException {
        switch (n) {
            case -7: 
            case 1: {
                return 2;
            }
            case -4: 
            case -3: 
            case -2: {
                return 4;
            }
            case -1: 
            case 12: {
                return 3;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return 1;
            }
            case 91: 
            case 92: {
                return 5;
            }
            case 93: {
                return 7;
            }
            case 2013: 
            case 2014: {
                return 21;
            }
            case 2004: {
                return 12;
            }
            case 2005: {
                return 13;
            }
            case -17: 
            case -10: 
            case 2012: {
                return 16;
            }
            case 101: {
                return 24;
            }
            case 100: {
                return 23;
            }
            case -15: {
                return 18;
            }
            case -9: {
                return 19;
            }
            case 2011: {
                return 20;
            }
            case 2009: {
                return 13;
            }
            case 0: {
                return 3;
            }
            case 2003: {
                return 29;
            }
            case 2002: {
                return 32;
            }
            case -2003: {
                return 30;
            }
            case 2006: {
                return 33;
            }
        }
        throw TbError.newSQLException(-590704, Integer.toString(n));
    }

    public static int toIntDataType(String string) throws SQLException {
        if (string.equals("CHAR")) {
            return 2;
        }
        if (string.equals("VARCHAR") || string.equals("VARCHAR2")) {
            return 3;
        }
        if (string.equals("NUMBER")) {
            return 1;
        }
        if (string.equals("DATE")) {
            return 5;
        }
        if (string.equals("TIME")) {
            return 6;
        }
        if (string.equals("TIMESTAMP")) {
            return 7;
        }
        if (string.equals("INTERVAL YEAR TO MONTH")) {
            return 8;
        }
        if (string.equals("INTERVAL DAY TO SECOND")) {
            return 9;
        }
        if (string.equals("RAW")) {
            return 4;
        }
        if (string.equals("GEOMETRY")) {
            return 12;
        }
        if (string.equals("BLOB")) {
            return 12;
        }
        if (string.equals("XMLTYPE")) {
            return 13;
        }
        if (string.equals("CLOB")) {
            return 13;
        }
        if (string.equals("BINARY_DOUBLE")) {
            return 24;
        }
        if (string.equals("BINARY_FLOAT")) {
            return 23;
        }
        if (string.equals("BFILE")) {
            return 14;
        }
        if (string.equals("LONG")) {
            return 10;
        }
        if (string.equals("LONG RAW")) {
            return 11;
        }
        if (string.equals("ROWID")) {
            return 15;
        }
        if (string.equals("NCHAR")) {
            return 18;
        }
        if (string.equals("NVARCHAR")) {
            return 19;
        }
        if (string.equals("NCLOB")) {
            return 20;
        }
        if (string.equals("CURSOR")) {
            return 16;
        }
        if (string.equals("VARRAY")) {
            return 29;
        }
        if (string.equals("STRUCT")) {
            return 28;
        }
        if (string.equals("TABLE")) {
            return 30;
        }
        return 32;
    }

    public static String getDataTypeClassName(int n) throws SQLException {
        switch (n) {
            case 1: {
                return "java.math.BigDecimal";
            }
            case 24: {
                return "java.lang.Double";
            }
            case 23: {
                return "java.lang.Float";
            }
            case 2: 
            case 3: 
            case 10: 
            case 18: 
            case 19: {
                return "java.lang.String";
            }
            case 5: {
                return "java.sql.Date";
            }
            case 6: {
                return "java.sql.Time";
            }
            case 7: 
            case 21: 
            case 22: {
                return "java.sql.Timestamp";
            }
            case 4: 
            case 11: {
                return "byte[]";
            }
            case 15: {
                return "com.tmax.tibero.jdbc.TbRowId";
            }
            case 12: 
            case 34: {
                return "java.sql.Blob";
            }
            case 20: {
                return "java.sql.NClob";
            }
            case 13: {
                return "java.sql.Clob";
            }
            case 16: {
                return "java.sql.ResultSet";
            }
            case 9: {
                return "com.tmax.tibero.jdbc.TbIntervalDts";
            }
            case 8: {
                return "com.tmax.tibero.jdbc.TbIntervalYtm";
            }
            case 29: {
                return "java.sql.Array";
            }
            case 28: 
            case 32: {
                return "java.lang.Object";
            }
            case 30: {
                return "java.sql.Array";
            }
            case 33: {
                return "java.sql.Ref";
            }
        }
        throw TbError.newSQLException(-590703, Integer.toString(n));
    }

    public static String getDBTypeName(int n) throws SQLException {
        return DataType.getDBTypeName(n, 0);
    }

    public static String getDBTypeName(int n, int n2) throws SQLException {
        switch (n) {
            case 2: {
                return "CHAR";
            }
            case 3: {
                return "VARCHAR2";
            }
            case 1: {
                return "NUMBER";
            }
            case 5: {
                return "DATE";
            }
            case 6: {
                return "TIME";
            }
            case 21: {
                return "TIMESTAMP WITH TIME ZONE";
            }
            case 22: {
                return "TIMESTAMP WITH LOCAL TIME ZONE";
            }
            case 7: {
                return "TIMESTAMP";
            }
            case 8: {
                return "INTERVAL YEAR TO MONTH";
            }
            case 9: {
                return "INTERVAL DAY TO SECOND";
            }
            case 4: {
                return "RAW";
            }
            case 12: {
                if (1 == n2) {
                    return "GEOMETRY";
                }
                if (3 == n2) {
                    return "PIVOT";
                }
                return "BLOB";
            }
            case 13: {
                if (2 == n2) {
                    return "XMLTYPE";
                }
                return "CLOB";
            }
            case 24: {
                return "BINARY_DOUBLE";
            }
            case 23: {
                return "BINARY_FLOAT";
            }
            case 14: {
                return "BFILE";
            }
            case 10: {
                return "LONG";
            }
            case 11: {
                return "LONG RAW";
            }
            case 15: {
                return "ROWID";
            }
            case 18: {
                return "NCHAR";
            }
            case 19: {
                return "NVARCHAR";
            }
            case 20: {
                return "NCLOB";
            }
            case 16: {
                return "CURSOR";
            }
            case 29: {
                return "VARRAY";
            }
            case 28: {
                return "STRUCT";
            }
            case 32: {
                return "OBJECT";
            }
            case 30: {
                return "TABLE";
            }
            case 33: {
                return "REF";
            }
            case 34: {
                return "JSON";
            }
        }
        throw TbError.newSQLException(-590703, Integer.toString(n));
    }

    public static int getSqlType(int n) throws SQLException {
        return DataType.getSqlType(n, 0);
    }

    public static int getSqlType(int n, int n2) throws SQLException {
        return DataType.getSqlType(n, 0, true);
    }

    public static int getSqlType(int n, int n2, boolean bl) throws SQLException {
        switch (n) {
            case 0: {
                return 0;
            }
            case 18: {
                return -15;
            }
            case 2: {
                return 1;
            }
            case 19: {
                return -9;
            }
            case 3: {
                return 12;
            }
            case 1: {
                return 2;
            }
            case 24: {
                return 101;
            }
            case 23: {
                return 100;
            }
            case 5: {
                if (bl) {
                    return 93;
                }
                return 91;
            }
            case 6: {
                return 92;
            }
            case 7: 
            case 21: 
            case 22: {
                return 93;
            }
            case 8: 
            case 9: {
                return 1111;
            }
            case 15: {
                return 1;
            }
            case 4: {
                return -3;
            }
            case 12: {
                if (1 == n2) {
                    return 26;
                }
                if (3 == n2) {
                    return 27;
                }
                return 2004;
            }
            case 20: {
                return 2011;
            }
            case 13: {
                if (2 == n2) {
                    return 2009;
                }
                return 2005;
            }
            case 10: {
                return -1;
            }
            case 11: {
                return -4;
            }
            case 16: {
                return -17;
            }
            case 29: {
                return 2003;
            }
            case 30: {
                return -2003;
            }
            case 28: 
            case 32: {
                return 2002;
            }
            case 33: {
                return 2006;
            }
            case 34: {
                return 2004;
            }
        }
        throw TbError.newSQLException(-590703, Integer.toString(n));
    }

    public static int getSqlType(Object object) throws SQLException {
        if (object == null) {
            return 1;
        }
        if (object instanceof String) {
            return 12;
        }
        if (object instanceof BigDecimal) {
            return 2;
        }
        if (object instanceof BigInteger) {
            return 2;
        }
        if (object instanceof Integer) {
            return 4;
        }
        if (object instanceof Short) {
            return 5;
        }
        if (object instanceof Long) {
            return -5;
        }
        if (object instanceof Float) {
            return 7;
        }
        if (object instanceof Double) {
            return 8;
        }
        if (object instanceof byte[]) {
            return -3;
        }
        if (object instanceof Date || object instanceof TbDate) {
            return 91;
        }
        if (object instanceof Time) {
            return 92;
        }
        if (object instanceof Timestamp || object instanceof TbTimestamp) {
            return 93;
        }
        if (object instanceof LocalDate) {
            return 91;
        }
        if (object instanceof LocalDateTime) {
            return 93;
        }
        if (object instanceof LocalTime) {
            return 92;
        }
        if (object instanceof OffsetTime) {
            return 2013;
        }
        if (object instanceof OffsetDateTime) {
            return 2014;
        }
        if (object instanceof Boolean) {
            return -7;
        }
        if (object instanceof NClob) {
            return 2011;
        }
        if (object instanceof Clob) {
            return 2005;
        }
        if (object instanceof Blob) {
            return 2004;
        }
        if (object instanceof Array) {
            return 2003;
        }
        if (object instanceof Struct || object instanceof SQLData || object instanceof TbAnydata) {
            return 2002;
        }
        if (object instanceof Ref) {
            return 2006;
        }
        if (object instanceof URL) {
            return 70;
        }
        if (object instanceof SQLXML) {
            return 2009;
        }
        if (object instanceof RowId) {
            return -8;
        }
        throw TbError.newSQLException(-590703, object.toString());
    }

    public static boolean isCharacterCategory(int n) {
        return n == 2 || n == 3;
    }

    public static boolean isDateCategory(int n) {
        return n == 5 || n == 6 || n == 7;
    }

    public static boolean isLobCategory(int n) {
        return n == 13 || n == 12 || n == 20;
    }

    public static boolean isLocatorCategory(int n) {
        return n == 13 || n == 12 || n == 20 || n == 10 || n == 11 || n == 34;
    }

    public static boolean isLongCategory(int n) {
        return n == 10 || n == 11;
    }

    public static boolean isNationalCategory(int n) {
        return n == 18 || n == 19;
    }

    public static boolean isNumberCategory(int n) {
        return n == 1;
    }

    public static boolean isBinaryDoubleCategory(int n) {
        return n == 24;
    }

    public static boolean isBinaryFloatCategory(int n) {
        return n == 23;
    }

    public static boolean isUDTCategory(int n) {
        return n == 32 || n == 28 || n == 29 || n == 30 || n == 31;
    }
}

