/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.TbArrayDescriptor;
import com.tmax.tibero.jdbc.TbStructDescriptor;
import com.tmax.tibero.jdbc.data.UdtAttrMeta;
import com.tmax.tibero.jdbc.data.UdtHierarchyInfo;
import com.tmax.tibero.jdbc.data.UdtInfo;
import com.tmax.tibero.jdbc.data.UdtMeta;
import com.tmax.tibero.jdbc.driver.TbConnection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public abstract class TbTypeDescriptor {
    public static final String UDT_INFO_SQLTYPENAME = "SYS.UDT_INFO_T";
    public static final String ATTR_META_SQLTYPENAME = "SYS.ATTR_META_T";
    public static final String ATTR_IDX_ARRAY_SQLTYPENAME = "SYS.ATTR_IDX_ARR";
    public static final String HIERARCHY_INFO_SQLTYPENAME = "SYS.HIERARCHY_INFO_T";
    public static final String ATTR_META_ARRAY_SQLTYPENAME = "SYS.ATTR_META_ARR";
    public static final String HIERARCHY_INFO_ARRAY_SQLTYPENAME = "SYS.HIERARCHY_INFO_ARR";
    public static final String UDT_META_SQLTYPENAME = "SYS.UDT_META_T";
    public static final String SQLTYPENAME_XMLTYPE = "SYS.XMLTYPE";
    public static final String SQLTYPENAME_ANYDATA = "SYS.ANYDATA";
    public static final String UDT_INFO_OID = "00000000000000000000000000000003";
    public static final String ATTR_META_OID = "00000000000000000000000000000004";
    public static final String ATTR_IDX_ARRAY_OID = "00000000000000000000000000000005";
    public static final String HIERARCHY_INFO_OID = "00000000000000000000000000000006";
    public static final String ATTR_META_ARRAY_OID = "00000000000000000000000000000007";
    public static final String HIERARCHY_INFO_ARRAY_OID = "00000000000000000000000000000008";
    public static final String UDT_META_OID = "00000000000000000000000000000009";
    public static final String OID_XMLTYPE = "00000000000000000000000000000001";
    public static final String OID_ANYDATA = "0000000000000000000000000000000A";
    public static final String _DESC_OID_PREFIX = "/O";
    public static List<String> preDefinedOIDList = new ArrayList<String>();
    public static List<String> preDefinedTypeNameList = new ArrayList<String>();
    private static Map<String, Class<?>> udtMeta2ClsMap;
    private String sqlTypeName;
    private String schemaName;
    private String packageName;
    private String typeName;
    private int dataType;
    private String hexEncodedOID;
    private int tobjID;
    private int versionNo;

    void init(int n, String string, String string2) throws SQLException {
        this.dataType = n;
        this.hexEncodedOID = string;
        this.sqlTypeName = string2;
        this.parseSQLTypeName(string2);
    }

    public static List<TbTypeDescriptor> genPredefUDTDescs(TbConnection tbConnection) {
        ArrayList<TbTypeDescriptor> arrayList = new ArrayList<TbTypeDescriptor>(7);
        try {
            arrayList.add(new TbStructDescriptor(32, UDT_INFO_OID, UDT_INFO_SQLTYPENAME, new int[]{3, 3, 3, 3, 1, 1, 1, 4}, new String[8], new String[8], tbConnection));
            arrayList.add(new TbStructDescriptor(32, ATTR_META_OID, ATTR_META_SQLTYPENAME, new int[]{3, 1, 1, 1, 1, 3}, new String[6], new String[6], tbConnection));
            arrayList.add(new TbArrayDescriptor(29, ATTR_IDX_ARRAY_OID, ATTR_IDX_ARRAY_SQLTYPENAME, 1, null, 1500, tbConnection));
            arrayList.add(new TbStructDescriptor(32, HIERARCHY_INFO_OID, HIERARCHY_INFO_SQLTYPENAME, new int[]{32, 29, 4}, new String[]{UDT_INFO_SQLTYPENAME, ATTR_IDX_ARRAY_SQLTYPENAME, null}, new String[]{UDT_INFO_OID, ATTR_IDX_ARRAY_OID, null}, tbConnection));
            arrayList.add(new TbArrayDescriptor(29, ATTR_META_ARRAY_OID, ATTR_META_ARRAY_SQLTYPENAME, 32, ATTR_META_SQLTYPENAME, 1500, tbConnection));
            arrayList.add(new TbArrayDescriptor(29, HIERARCHY_INFO_ARRAY_OID, HIERARCHY_INFO_ARRAY_SQLTYPENAME, 32, HIERARCHY_INFO_SQLTYPENAME, 1500, tbConnection));
            arrayList.add(new TbStructDescriptor(32, UDT_META_OID, UDT_META_SQLTYPENAME, new int[]{1, 32, 29, 29, 1, 1}, new String[]{null, UDT_INFO_SQLTYPENAME, ATTR_META_ARRAY_SQLTYPENAME, HIERARCHY_INFO_ARRAY_SQLTYPENAME, null, null}, new String[]{null, UDT_INFO_OID, ATTR_META_ARRAY_OID, HIERARCHY_INFO_ARRAY_OID, null, null}, tbConnection));
            if (tbConnection != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    TbTypeDescriptor tbTypeDescriptor = (TbTypeDescriptor)arrayList.get(i);
                    tbConnection.putDescriptor(_DESC_OID_PREFIX + tbTypeDescriptor.getOID(), tbTypeDescriptor);
                    tbConnection.putDescriptor(tbTypeDescriptor.getSQLTypeName(), tbTypeDescriptor);
                }
            }
        }
        catch (Exception exception) {
            arrayList.clear();
        }
        return arrayList;
    }

    public static Map<String, Class<?>> getUdtMeta2ClsMap() {
        if (udtMeta2ClsMap.size() == 0) {
            udtMeta2ClsMap.put(UDT_INFO_SQLTYPENAME, UdtInfo.class);
            udtMeta2ClsMap.put(ATTR_META_SQLTYPENAME, UdtAttrMeta.class);
            udtMeta2ClsMap.put(HIERARCHY_INFO_SQLTYPENAME, UdtHierarchyInfo.class);
            udtMeta2ClsMap.put(UDT_META_SQLTYPENAME, UdtMeta.class);
        }
        return udtMeta2ClsMap;
    }

    public String getSQLTypeName() {
        return this.sqlTypeName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int getDataType() {
        return this.dataType;
    }

    public String getOID() {
        return this.hexEncodedOID;
    }

    public int getVersionNo() {
        return this.versionNo;
    }

    public int getTobjID() {
        return this.tobjID;
    }

    public void setVersionNo(int n) {
        this.versionNo = n;
    }

    public void setTobjID(int n) {
        this.tobjID = n;
    }

    private int parseSQLTypeName(String string) throws SQLException {
        String string2 = ".";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int n = stringTokenizer.countTokens();
        if (n == 2) {
            this.schemaName = stringTokenizer.nextToken().toUpperCase();
            this.typeName = stringTokenizer.nextToken().toUpperCase();
            this.packageName = null;
        } else if (n == 3) {
            this.schemaName = stringTokenizer.nextToken().toUpperCase();
            this.packageName = stringTokenizer.nextToken().toUpperCase();
            this.typeName = stringTokenizer.nextToken().toUpperCase();
        } else {
            throw new SQLException("Invalid type name : " + string);
        }
        return n;
    }

    public static String[] splitSQLTypeName(String string) {
        String[] stringArray = null;
        String string2 = "[.]{1}";
        stringArray = string.split(string2);
        return stringArray;
    }

    protected void setOID(String string) {
        this.hexEncodedOID = string;
    }

    static {
        preDefinedOIDList.add("/O00000000000000000000000000000003");
        preDefinedOIDList.add("/O00000000000000000000000000000004");
        preDefinedOIDList.add("/O00000000000000000000000000000005");
        preDefinedOIDList.add("/O00000000000000000000000000000006");
        preDefinedOIDList.add("/O00000000000000000000000000000007");
        preDefinedOIDList.add("/O00000000000000000000000000000008");
        preDefinedOIDList.add("/O00000000000000000000000000000009");
        preDefinedOIDList.add("/O00000000000000000000000000000001");
        preDefinedTypeNameList.add(UDT_INFO_SQLTYPENAME);
        preDefinedTypeNameList.add(ATTR_META_SQLTYPENAME);
        preDefinedTypeNameList.add(ATTR_IDX_ARRAY_SQLTYPENAME);
        preDefinedTypeNameList.add(HIERARCHY_INFO_SQLTYPENAME);
        preDefinedTypeNameList.add(ATTR_META_ARRAY_SQLTYPENAME);
        preDefinedTypeNameList.add(HIERARCHY_INFO_ARRAY_SQLTYPENAME);
        preDefinedTypeNameList.add(UDT_META_SQLTYPENAME);
        preDefinedTypeNameList.add(SQLTYPENAME_XMLTYPE);
        udtMeta2ClsMap = new HashMap();
    }
}

