/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.event;

import com.tmax.tibero.event.ChannelEventManager;
import com.tmax.tibero.event.EventHandler;
import com.tmax.tibero.event.EventSubscriber;
import com.tmax.tibero.event.handler.SystemEventHandler;
import com.tmax.tibero.jdbc.driver.Registration;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import java.io.IOException;
import java.net.Socket;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class EventManager {
    private static final String ChannelEventManagerThreadName = "ChannelEventManager";
    public static final int CONNECTION_REGISTERED_OK = 55;
    private static Hashtable<Integer, EventHandler> eventHandlerMap = null;
    private static ChannelEventManager channelEventManager = null;
    private static ConcurrentHashMap<TbConnection, Socket> connectionSocketMap = null;
    private static ConcurrentHashMap<Integer, SocketChannel> eventSocketMap = null;
    private static Thread channelEventThread;
    private static boolean isRunning;
    private static Hashtable<Integer, Registration> registrations;
    private static Set<Integer> systemEventRegIdSet;
    private static ConcurrentHashMap<Integer, EventSubscriber> subscriberMap;
    private static int regId;

    public static synchronized void boot() throws Exception {
        if (!isRunning) {
            EventManager.setEventHandlerMap(new Hashtable<Integer, EventHandler>());
            EventManager.setChannelEventManager(new ChannelEventManager());
            EventManager.setconnectionSocketMap(new ConcurrentHashMap<TbConnection, Socket>());
            EventManager.setEventSocketMap(new ConcurrentHashMap<Integer, SocketChannel>());
            EventManager.registerDefaultEventHandler();
            EventManager.startChannelEventManager();
            EventManager.setIsRunning(true);
        }
    }

    public static synchronized void down() throws Exception {
        if (isRunning) {
            eventHandlerMap = null;
            channelEventManager = null;
            connectionSocketMap = null;
            eventSocketMap = null;
            isRunning = false;
            channelEventThread.interrupt();
        }
    }

    public void finalize() throws Exception {
        EventManager.down();
    }

    public static boolean getIsRunning() {
        return isRunning;
    }

    protected static void setIsRunning(Boolean bl) {
        isRunning = bl;
    }

    protected static void setEventHandlerMap(Hashtable<Integer, EventHandler> hashtable) {
        eventHandlerMap = hashtable;
    }

    protected static void setEventSocketMap(ConcurrentHashMap<Integer, SocketChannel> concurrentHashMap) {
        eventSocketMap = concurrentHashMap;
    }

    protected static void setChannelEventManager(ChannelEventManager channelEventManager) {
        EventManager.channelEventManager = channelEventManager;
    }

    protected static void setconnectionSocketMap(ConcurrentHashMap<TbConnection, Socket> concurrentHashMap) {
        connectionSocketMap = concurrentHashMap;
    }

    public static void startChannelEventManager() throws InterruptedException {
        channelEventThread = new Thread(channelEventManager);
        channelEventThread.setName(ChannelEventManagerThreadName);
        channelEventThread.start();
    }

    public static synchronized EventHandler getEventHandlerMap(int n) {
        return eventHandlerMap.get(n);
    }

    protected static void registerDefaultEventHandler() throws Exception {
        Hashtable hashtable = (Hashtable)eventHandlerMap.clone();
        hashtable.put(0, new SystemEventHandler());
        eventHandlerMap = hashtable;
    }

    public static void registerConnection(TbConnection tbConnection, Socket socket) {
        connectionSocketMap.remove(tbConnection);
        connectionSocketMap.put(tbConnection, socket);
    }

    public static void unregisterConnection(TbConnection tbConnection) {
        connectionSocketMap.remove(tbConnection);
    }

    public static void registerEventSocket(int n, SocketChannel socketChannel) {
        eventSocketMap.put(n, socketChannel);
    }

    public static void unregisterEventSocket(int n) {
        eventSocketMap.remove(n);
    }

    public static void registerSubscriber(EventSubscriber eventSubscriber) {
        subscriberMap.put(eventSubscriber.id, eventSubscriber);
    }

    public static void unregisterSubscriber(EventSubscriber eventSubscriber) {
        subscriberMap.remove(eventSubscriber.id);
        try {
            EventManager.release();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static synchronized void release() throws Exception {
        if (subscriberMap.isEmpty() && registrations.isEmpty()) {
            EventManager.down();
        }
    }

    public static Socket getSocket(TbConnection tbConnection) {
        return connectionSocketMap.get(tbConnection);
    }

    public static synchronized void addRegistration(Registration registration) throws Exception {
        registration.setRegID(++regId);
        systemEventRegIdSet.add(regId);
        Hashtable hashtable = (Hashtable)registrations.clone();
        hashtable.put(registration.getRegID(), registration);
        registrations = hashtable;
    }

    public static synchronized void removeRegistration(Registration registration) throws Exception {
        Hashtable hashtable = (Hashtable)registrations.clone();
        Object v = hashtable.remove(registration.getRegID());
        systemEventRegIdSet.remove(registration.getRegID());
        registrations = hashtable;
        EventManager.release();
    }

    public static Collection<EventSubscriber> getSubscribers() {
        return subscriberMap.values();
    }

    public static synchronized Registration getRegistration(int n) {
        return registrations.get(n);
    }

    public static boolean hasEventPort(int n) {
        return eventSocketMap.contains(n);
    }

    public static void removePort(int n) throws SQLException {
        if (eventSocketMap.contains(n)) {
            try {
                eventSocketMap.get(n).close();
            }
            catch (IOException iOException) {
                throw TbError.newSQLException(-90409, iOException.getMessage());
            }
            eventSocketMap.remove(n);
        }
    }

    public static void registerSocket(int n, SocketChannel socketChannel) throws ClosedChannelException {
        eventSocketMap.put(n, socketChannel);
        channelEventManager.register(socketChannel);
    }

    public static Integer[] getSystemEventRegIDs() {
        return systemEventRegIdSet.toArray(new Integer[0]);
    }

    static {
        isRunning = false;
        registrations = new Hashtable();
        systemEventRegIdSet = Collections.synchronizedSet(new HashSet());
        subscriberMap = new ConcurrentHashMap();
        regId = 0;
    }
}

