/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.util;

import com.tmax.tibero.jdbc.data.BigLiteral;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.util.TbSQLTypeScanner;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.ArrayList;

public class TbSQLParser {
    private String originalSql;
    private int length;
    private StringBuffer parsedSql;
    private StringBuffer token;
    private char chr;
    private int index;
    private int openParenCnt;
    private boolean isString;
    private static final byte[] IDEOGRAPHIC_SPACE = new byte[]{-29, -128, -128};

    private void appendFunctionName(String string) throws SQLException {
        this.parsedSql.append(string);
        this.skipWhitespace();
        this.processSQL();
    }

    private void appendFunctionPrefix(String string) throws SQLException {
        this.skipWhitespace();
        if (this.index < this.length && (this.chr = this.originalSql.charAt(this.index)) == '(') {
            ++this.index;
        } else {
            String string2 = new String(this.index + ": '(' is expected");
            throw TbError.newSQLException(-90632, string2);
        }
        this.parsedSql.append(string);
        this.skipWhitespace();
        this.processSQL();
    }

    private void checkCurrentChar(char c) throws SQLException {
        this.chr = this.originalSql.charAt(this.index - 1);
        if (this.chr != c) {
            String string = new String(this.index + ": '" + c + "' is expected");
            throw TbError.newSQLException(-90632, string);
        }
    }

    public static String getBigLiteral(String string, int n, ArrayList<BigLiteral> arrayList) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = 0;
        char[] cArray = new char[string.length() + 1];
        string.getChars(0, string.length(), cArray, 0);
        while (true) {
            if (cArray[n2] == '-' && cArray[n2 + 1] == '-') {
                stringBuffer.append(cArray[n2++]);
                stringBuffer.append(cArray[n2++]);
                while (cArray[n2] != '\n') {
                    if (cArray[n2] == '\u0000') {
                        return stringBuffer.toString();
                    }
                    stringBuffer.append(cArray[n2++]);
                }
                stringBuffer.append(cArray[n2++]);
                continue;
            }
            if (cArray[n2] == '\"') {
                stringBuffer.append(cArray[n2++]);
                while (cArray[n2] != '\"') {
                    if (cArray[n2] == '\u0000') {
                        return stringBuffer.toString();
                    }
                    stringBuffer.append(cArray[n2++]);
                }
                stringBuffer.append(cArray[n2++]);
                continue;
            }
            if (cArray[n2] == '\'' && cArray[n2 + 1] == '\'') {
                stringBuffer.append(cArray[n2++]);
                stringBuffer.append(cArray[n2++]);
            } else if (cArray[n2] == '\'') {
                int n4 = ++n2;
                StringBuffer stringBuffer2 = new StringBuffer();
                while (cArray[n2] != '\'') {
                    if (cArray[n2] == '\u0000') {
                        stringBuffer.append('\'');
                        stringBuffer.append(stringBuffer2);
                        return stringBuffer.toString();
                    }
                    stringBuffer2.append(cArray[n2++]);
                    while (cArray[n2] == '\'' && cArray[n2 + 1] == '\'') {
                        stringBuffer2.append(cArray[n2++]);
                        stringBuffer2.append(cArray[n2++]);
                    }
                }
                if (n2 - n4 > 65535 / n) {
                    BigLiteral bigLiteral = new BigLiteral(n3++, string.substring(n4, n2));
                    arrayList.add(bigLiteral);
                    stringBuffer.append('?');
                } else {
                    stringBuffer.append('\'');
                    stringBuffer.append(stringBuffer2);
                    stringBuffer.append('\'');
                }
                ++n2;
                continue;
            }
            if (cArray[n2] == '/' && cArray[n2 + 1] == '*') {
                stringBuffer.append(cArray[n2++]);
                stringBuffer.append(cArray[n2++]);
                while (cArray[n2] != '*' || cArray[n2 + 1] != '/') {
                    if (cArray[n2] == '\u0000') {
                        return stringBuffer.toString();
                    }
                    stringBuffer.append(cArray[n2++]);
                }
                stringBuffer.append(cArray[n2++]);
                stringBuffer.append(cArray[n2++]);
                continue;
            }
            if (cArray[n2] == '\u0000') {
                return stringBuffer.toString();
            }
            if (cArray[n2] == '?' || cArray[n2] == ':' && cArray[n2 + 1] != '=') {
                stringBuffer.append(cArray[n2++]);
                ++n3;
                continue;
            }
            stringBuffer.append(cArray[n2++]);
        }
    }

    public static int getParamCount(String string, int n) {
        if (TbSQLTypeScanner.isDDLStmt(n)) {
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        char[] cArray = new char[string.length() + 1];
        string.getChars(0, string.length(), cArray, 0);
        while (true) {
            if (cArray[n2] == '-' && cArray[n2 + 1] == '-') {
                n2 += 2;
                while (cArray[n2] != '\n') {
                    if (cArray[n2] == '\u0000') {
                        return n3;
                    }
                    ++n2;
                }
                ++n2;
                continue;
            }
            if (cArray[n2] == '\"') {
                ++n2;
                while (cArray[n2] != '\"') {
                    if (cArray[n2] == '\u0000') {
                        return n3;
                    }
                    ++n2;
                }
                ++n2;
                continue;
            }
            if (cArray[n2] == '\'') {
                ++n2;
                while (cArray[n2] != '\'') {
                    if (cArray[n2] == '\u0000') {
                        return n3;
                    }
                    ++n2;
                }
                ++n2;
                continue;
            }
            if (cArray[n2] == '/' && cArray[n2 + 1] == '*') {
                n2 += 2;
                while (cArray[n2] != '*' || cArray[n2 + 1] != '/') {
                    if (cArray[n2] == '\u0000') {
                        return n3;
                    }
                    ++n2;
                }
                n2 += 2;
                continue;
            }
            if (!TbSQLTypeScanner.isPSMStmt(n) && string.regionMatches(true, n2, "returning", 0, 9) && n2 > 1 && n2 + 9 < cArray.length && Character.isWhitespace(cArray[n2 - 1]) && Character.isWhitespace(cArray[n2 + 9]) || bl) {
                int n4 = n2;
                if (!bl) {
                    n4 = n2 += 9;
                }
                while (cArray[n2] != ';') {
                    if (cArray[n2] == '\u0000') {
                        return n3;
                    }
                    if (!bl && string.regionMatches(true, n2, "into", 0, 3)) {
                        bl = true;
                        n2 = n4;
                        break;
                    }
                    ++n2;
                }
                ++n2;
                if (!bl) continue;
            }
            if (cArray[n2] == '\u0000') {
                return n3;
            }
            if (cArray[n2] == '?' || cArray[n2] == ':' && cArray[n2 + 1] != '=') {
                ++n3;
            }
            ++n2;
        }
    }

    public static String[] getParamNames(String string) {
        int n = 0;
        char[] cArray = new char[string.length() + 1];
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        string.getChars(0, string.length(), cArray, 0);
        block0: while (true) {
            if (cArray[n] == '-' && cArray[n + 1] == '-') {
                n += 2;
                while (cArray[n] != '\n') {
                    if (cArray[n] == '\u0000') {
                        return arrayList.toArray(new String[0]);
                    }
                    ++n;
                }
                ++n;
                continue;
            }
            if (cArray[n] == '\"') {
                ++n;
                while (cArray[n] != '\"') {
                    if (cArray[n] == '\u0000') {
                        return arrayList.toArray(new String[0]);
                    }
                    ++n;
                }
                ++n;
                continue;
            }
            if (cArray[n] == '\'') {
                ++n;
                while (cArray[n] != '\'') {
                    if (cArray[n] == '\u0000') {
                        return arrayList.toArray(new String[0]);
                    }
                    ++n;
                }
                ++n;
                continue;
            }
            if (cArray[n] == '/' && cArray[n + 1] == '*') {
                n += 2;
                while (cArray[n] != '*' || cArray[n + 1] != '/') {
                    if (cArray[n] == '\u0000') {
                        return arrayList.toArray(new String[0]);
                    }
                    ++n;
                }
                n += 2;
                continue;
            }
            if (cArray[n] == '\u0000') {
                return arrayList.toArray(new String[0]);
            }
            if (cArray[n] == '?') {
                arrayList.add("?");
            } else if (cArray[n] == ':' && cArray[n + 1] != '=') {
                ++n;
                stringBuffer.delete(0, stringBuffer.length());
                while (true) {
                    if (cArray[n] == '\u0000') {
                        return arrayList.toArray(new String[0]);
                    }
                    if (!Character.isLetterOrDigit(cArray[n]) && cArray[n] != '_') {
                        if (stringBuffer.length() <= 0) continue block0;
                        arrayList.add(stringBuffer.toString());
                        continue block0;
                    }
                    stringBuffer.append(cArray[n]);
                    ++n;
                }
            }
            ++n;
        }
    }

    public static String getRowIdAddedRefetchSql(String string, int n) throws SQLException {
        if (string == null) {
            throw TbError.newSQLException(-90608, "null");
        }
        if (n <= 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select * from (").append(string).append(") ");
        if (n > 0) {
            stringBuffer.append(" WHERE _ROWID_CHAR0_ = ? ");
        }
        for (int i = 1; i < n; ++i) {
            stringBuffer.append(" OR _ROWID_CHAR0_ = ? ");
        }
        return stringBuffer.toString();
    }

    private void init() {
        this.index = 0;
        this.openParenCnt = 0;
        this.isString = false;
    }

    private void makeToken() {
        while (this.index < this.length && (Character.isJavaIdentifierPart(this.chr = this.originalSql.charAt(this.index)) || this.chr == '?')) {
            this.token.append(this.chr);
            ++this.index;
        }
    }

    public String parse(String string) throws SQLException {
        this.init();
        this.parsedSql = new StringBuffer(string.length());
        this.token = new StringBuffer(32);
        this.originalSql = string;
        this.length = this.originalSql.length();
        this.processSQL();
        return this.parsedSql.substring(0, this.parsedSql.length());
    }

    private void processCall() throws SQLException {
        this.parsedSql.append("CALL");
        this.processSQL();
    }

    private void processDate() throws SQLException {
        this.parsedSql.append("TO_DATE (");
        this.skipWhitespace();
        this.processSQL();
        this.parsedSql.append(", 'YYYY-MM-DD')");
    }

    private void processEscape() throws SQLException {
        this.parsedSql.append("ESCAPE ");
        this.skipWhitespace();
        this.processSQL();
    }

    private void processFunction() throws SQLException {
        this.parsedSql.append("?");
        this.processSQL();
    }

    private void processOuterJoin() throws SQLException {
        this.parsedSql.append(" ( ");
        this.skipWhitespace();
        this.processSQL();
        this.parsedSql.append(" ) ");
    }

    private void processScalarFunction() throws SQLException {
        this.token.delete(0, this.token.length());
        this.skipWhitespace();
        this.makeToken();
        String string = this.token.substring(0, this.token.length()).toUpperCase().intern();
        if ("ABS".equalsIgnoreCase(string) || "ACOS".equalsIgnoreCase(string) || "ASIN".equalsIgnoreCase(string) || "ATAN".equalsIgnoreCase(string) || "ATAN2".equalsIgnoreCase(string) || "COS".equalsIgnoreCase(string) || "EXP".equalsIgnoreCase(string) || "FLOOR".equalsIgnoreCase(string) || "MOD".equalsIgnoreCase(string) || "POWER".equalsIgnoreCase(string) || "ROUND".equalsIgnoreCase(string) || "SIGN".equalsIgnoreCase(string) || "SIN".equalsIgnoreCase(string) || "SQRT".equalsIgnoreCase(string) || "TAN".equalsIgnoreCase(string) || "ASCII".equalsIgnoreCase(string) || "CHAR_LENGTH".equalsIgnoreCase(string) || "CHARACTER_LENGTH".equalsIgnoreCase(string) || "CONCAT".equalsIgnoreCase(string) || "LENGTH".equalsIgnoreCase(string) || "LTRIM".equalsIgnoreCase(string) || "REPLACE".equalsIgnoreCase(string) || "RTRIM".equalsIgnoreCase(string) || "EXTRACT".equalsIgnoreCase(string)) {
            this.appendFunctionName(string);
        } else if ("CEILING".equalsIgnoreCase(string)) {
            this.appendFunctionName("CEIL");
        } else if ("LOG".equalsIgnoreCase(string)) {
            this.appendFunctionName("LN");
        } else if ("LOG10".equalsIgnoreCase(string)) {
            this.appendFunctionPrefix("LOG ( 10, ");
        } else if ("PI".equalsIgnoreCase(string)) {
            this.appendFunctionPrefix("( 3.141592653589793238462643383279502884197169399375 ");
        } else if ("TRUNCATE".equalsIgnoreCase(string)) {
            this.appendFunctionName("TRUNC");
        } else if ("CHAR".equalsIgnoreCase(string)) {
            this.appendFunctionName("CHR");
        } else if ("INSERT".equalsIgnoreCase(string)) {
            int n;
            ArrayList<StringBuffer> arrayList = this.processArguments();
            int n2 = n = arrayList == null ? 0 : arrayList.size();
            if (n != 4) {
                String string2 = new String("The number of arguments is wrong. expected=4, actual=" + n);
                throw TbError.newSQLException(-90632, string2);
            }
            this.parsedSql.append("SUBSTR(").append(arrayList.get(0)).append(", 1, (").append(arrayList.get(1)).append(")-1) || ").append(arrayList.get(3)).append(" || SUBSTR(").append(arrayList.get(0)).append(", (").append(arrayList.get(1)).append(")+(").append(arrayList.get(2)).append("))");
            this.processSQL();
        } else if ("LCASE".equalsIgnoreCase(string)) {
            this.appendFunctionName("LOWER");
        } else if ("LEFT".equalsIgnoreCase(string)) {
            int n;
            ArrayList<StringBuffer> arrayList = this.processArguments();
            int n3 = n = arrayList == null ? 0 : arrayList.size();
            if (n != 2) {
                String string3 = new String("The number of arguments is wrong. expected=2, actual=" + n);
                throw TbError.newSQLException(-90632, string3);
            }
            this.parsedSql.append("SUBSTR(").append(arrayList.get(0)).append(", 1,").append(arrayList.get(1)).append(')');
            this.processSQL();
        } else if ("LOCATE".equalsIgnoreCase(string)) {
            int n;
            ArrayList<StringBuffer> arrayList = this.processArguments();
            int n4 = n = arrayList == null ? 0 : arrayList.size();
            if (n != 2) {
                String string4 = new String("The number of arguments is wrong. expected=2, actual=" + n);
                throw TbError.newSQLException(-90632, string4);
            }
            this.parsedSql.append("INSTR(").append(arrayList.get(1)).append(", ").append(arrayList.get(0)).append(')');
            this.processSQL();
        } else if ("REPEAT".equalsIgnoreCase(string)) {
            int n;
            ArrayList<StringBuffer> arrayList = this.processArguments();
            int n5 = n = arrayList == null ? 0 : arrayList.size();
            if (n != 2) {
                String string5 = new String("The number of arguments is wrong. expected=2, actual=" + n);
                throw TbError.newSQLException(-90632, string5);
            }
            this.parsedSql.append("RPAD(").append(arrayList.get(0)).append(", ").append(arrayList.get(1)).append(" * LENGTH(").append(arrayList.get(0)).append("), ").append(arrayList.get(0)).append(')');
            this.processSQL();
        } else if ("RIGHT".equalsIgnoreCase(string)) {
            int n;
            ArrayList<StringBuffer> arrayList = this.processArguments();
            int n6 = n = arrayList == null ? 0 : arrayList.size();
            if (n != 2) {
                String string6 = new String("The number of arguments is wrong. expected=2, actual=" + n);
                throw TbError.newSQLException(-90632, string6);
            }
            this.parsedSql.append("SUBSTR(").append(arrayList.get(0)).append(", - ").append(arrayList.get(1)).append(')');
            this.processSQL();
        } else if ("SPACE".equalsIgnoreCase(string)) {
            this.appendFunctionPrefix("LPAD(' ', ");
        } else if ("SUBSTRING".equalsIgnoreCase(string)) {
            this.appendFunctionName("SUBSTR");
        } else if ("UCASE".equalsIgnoreCase(string)) {
            this.appendFunctionName("UPPER");
        } else if ("CURDATE".equalsIgnoreCase(string) || "CURRENT_DATE".equalsIgnoreCase(string)) {
            this.appendFunctionPrefix("(CURRENT_DATE");
        } else if ("CURRENT_TIME".equalsIgnoreCase(string)) {
            this.appendFunctionPrefix("(CURRENT_TIME");
        } else if ("CURTIME".equalsIgnoreCase(string) || "CURRENT_TIMESTAMP".equalsIgnoreCase(string) || "NOW".equalsIgnoreCase(string)) {
            this.appendFunctionPrefix("(CURRENT_TIMESTAMP");
        } else if ("DAYOFMONTH".equalsIgnoreCase(string)) {
            this.appendFunctionPrefix("EXTRACT ( DAY FROM ");
        } else if ("HOUR".equalsIgnoreCase(string)) {
            this.appendFunctionPrefix("EXTRACT ( HOUR FROM ");
        } else if ("MINUTE".equalsIgnoreCase(string)) {
            this.appendFunctionPrefix("EXTRACT ( MINUTE FROM ");
        } else if ("MONTH".equalsIgnoreCase(string)) {
            this.appendFunctionPrefix("EXTRACT ( MONTH FROM ");
        } else if ("SECOND".equalsIgnoreCase(string)) {
            this.appendFunctionPrefix("EXTRACT ( SECOND FROM ");
        } else if ("YEAR".equalsIgnoreCase(string)) {
            this.appendFunctionPrefix("EXTRACT ( YEAR FROM ");
        } else if ("DATABASE".equalsIgnoreCase(string)) {
            this.appendFunctionPrefix("USERENV('DB_NAME'");
        } else if ("IFNULL".equalsIgnoreCase(string)) {
            this.appendFunctionName("NVL");
        } else if ("USER".equalsIgnoreCase(string)) {
            this.appendFunctionPrefix("(USER");
        } else if ("CONVERT".equalsIgnoreCase(string)) {
            int n;
            ArrayList<StringBuffer> arrayList = this.processArguments();
            int n7 = n = arrayList == null ? 0 : arrayList.size();
            if (n != 2) {
                String string7 = new String("The number of arguments is wrong. expected=2, actual=" + n);
                throw TbError.newSQLException(-90632, string7);
            }
            String string8 = arrayList.get(1).toString().trim();
            String string9 = null;
            if ("SQL_VARCHAR".equalsIgnoreCase(string8) || "SQL_CHAR".equalsIgnoreCase(string8)) {
                string9 = "TO_CHAR";
            } else if ("SQL_INTEGER".equalsIgnoreCase(string8) || "SQL_NUMERIC".equalsIgnoreCase(string8) || "SQL_DECIMAL".equalsIgnoreCase(string8)) {
                string9 = "TO_NUMBER";
            } else if ("SQL_DATE".equalsIgnoreCase(string8)) {
                string9 = "TO_DATE";
            } else if ("SQL_TIME".equalsIgnoreCase(string8)) {
                string9 = "TO_TIME";
            } else if ("SQL_TIMESTAMP".equalsIgnoreCase(string8)) {
                string9 = "TO_TIMESTAMP";
            } else {
                String string10 = new String("NOT implemented option: \"" + string8 + "\"");
                throw TbError.newSQLException(-90632, string10);
            }
            this.parsedSql.append(string9).append('(').append(arrayList.get(0)).append(')');
            this.processSQL();
        } else {
            String string11 = new String("unsuppoted SQL92 Token: \"" + string + "\"");
            throw TbError.newSQLException(-90632, string11);
        }
    }

    private void processSQL() throws SQLException {
        block7: while (this.index < this.length) {
            this.chr = this.originalSql.charAt(this.index++);
            char c = '\u0000';
            if (this.isString) {
                this.parsedSql.append(this.chr);
                if (this.chr != '\'') continue;
                this.isString = false;
                continue;
            }
            switch (this.chr) {
                case '\'': {
                    this.parsedSql.append(this.chr);
                    this.isString = true;
                    continue block7;
                }
                case '{': {
                    ++this.openParenCnt;
                    this.token.delete(0, this.token.length());
                    this.skipWhitespace();
                    this.makeToken();
                    this.processToken();
                    this.checkCurrentChar('}');
                    continue block7;
                }
                case '}': {
                    --this.openParenCnt;
                    if (this.openParenCnt < 0) {
                        String string = new String(this.index + ": Unnecessary '" + this.chr + "' exists");
                        throw TbError.newSQLException(-90632, string);
                    }
                    return;
                }
                case '/': {
                    if (this.index < this.length && (c = this.originalSql.charAt(this.index)) == '*') {
                        this.parsedSql.append(this.chr).append(c);
                        ++this.index;
                        while (this.index < this.length && ((this.chr = this.originalSql.charAt(this.index)) != '*' || (c = this.originalSql.charAt(this.index + 1)) != '/')) {
                            this.parsedSql.append(this.chr);
                            ++this.index;
                        }
                        this.chr = this.originalSql.charAt(this.index++);
                        this.parsedSql.append(this.chr);
                        this.chr = this.originalSql.charAt(this.index++);
                        this.parsedSql.append(this.chr);
                        continue block7;
                    }
                    this.parsedSql.append(this.chr);
                    continue block7;
                }
                case '-': {
                    if (this.index < this.length && (c = this.originalSql.charAt(this.index)) == '-') {
                        this.parsedSql.append(this.chr).append(c);
                        ++this.index;
                        while (this.index < this.length && (this.chr = this.originalSql.charAt(this.index)) != '\n') {
                            this.parsedSql.append(this.chr);
                            ++this.index;
                        }
                        this.parsedSql.append(this.chr);
                        ++this.index;
                        continue block7;
                    }
                    this.parsedSql.append(this.chr);
                    continue block7;
                }
            }
            this.parsedSql.append(this.chr);
        }
    }

    private ArrayList<StringBuffer> processArguments() throws SQLException {
        this.skipWhitespace();
        if (this.index < this.length && (this.chr = this.originalSql.charAt(this.index)) == '(') {
            ++this.index;
        } else {
            String string = new String(this.index + ": '(' is expected");
            throw TbError.newSQLException(-90632, string);
        }
        ArrayList<StringBuffer> arrayList = new ArrayList<StringBuffer>();
        StringBuffer stringBuffer = this.parsedSql;
        this.parsedSql = new StringBuffer();
        int n = 0;
        block9: while (this.index < this.length) {
            char c = this.originalSql.charAt(this.index++);
            if (this.isString) {
                this.parsedSql.append(c);
                if (c != '\'') continue;
                this.isString = false;
                continue;
            }
            switch (c) {
                case '\'': {
                    this.parsedSql.append(c);
                    this.isString = true;
                    continue block9;
                }
                case '{': {
                    ++this.openParenCnt;
                    this.token.delete(0, this.token.length());
                    this.skipWhitespace();
                    this.makeToken();
                    this.processToken();
                    this.checkCurrentChar('}');
                    continue block9;
                }
                case ',': {
                    if (n != 0) {
                        this.parsedSql.append(c);
                        continue block9;
                    }
                    arrayList.add(this.parsedSql);
                    this.parsedSql = new StringBuffer();
                    continue block9;
                }
                case '(': {
                    ++n;
                    this.skipWhitespace();
                    this.makeToken();
                    this.processToken();
                    this.checkCurrentChar(')');
                    continue block9;
                }
                case ')': {
                    if (n == 0) {
                        arrayList.add(this.parsedSql);
                        break block9;
                    }
                    if (n <= 0) continue block9;
                    --n;
                    continue block9;
                }
                case '/': {
                    char c2;
                    if (this.index < this.length && (c2 = this.originalSql.charAt(this.index)) == '*') {
                        this.parsedSql.append(c).append(c2);
                        ++this.index;
                        while (this.index < this.length && ((c = this.originalSql.charAt(this.index)) != '*' || (c2 = this.originalSql.charAt(this.index + 1)) != '/')) {
                            this.parsedSql.append(c);
                            ++this.index;
                        }
                        c = this.originalSql.charAt(this.index++);
                        this.parsedSql.append(c);
                        c = this.originalSql.charAt(this.index++);
                        this.parsedSql.append(c);
                        continue block9;
                    }
                    this.parsedSql.append(c);
                    continue block9;
                }
                case '-': {
                    char c2;
                    if (this.index < this.length && (c2 = this.originalSql.charAt(this.index)) == '-') {
                        this.parsedSql.append(c).append(c2);
                        ++this.index;
                        while (this.index < this.length && (c = this.originalSql.charAt(this.index)) != '\n') {
                            this.parsedSql.append(c);
                            ++this.index;
                        }
                        this.parsedSql.append(c);
                        ++this.index;
                        continue block9;
                    }
                    this.parsedSql.append(c);
                    continue block9;
                }
                default: {
                    this.parsedSql.append(c);
                    continue block9;
                }
            }
        }
        this.parsedSql = stringBuffer;
        return arrayList;
    }

    private void processTime() throws SQLException {
        this.parsedSql.append("TO_DATE (");
        this.skipWhitespace();
        this.processSQL();
        this.parsedSql.append(", 'HH24:MI:SS')");
    }

    private void processTimestamp() throws SQLException {
        this.parsedSql.append("TO_TIMESTAMP (");
        this.skipWhitespace();
        this.processSQL();
        this.parsedSql.append(", 'YYYY-MM-DD HH24:MI:SS.FF')");
    }

    private void processToken() throws SQLException {
        String string = this.token.substring(0, this.token.length());
        if (string.equalsIgnoreCase("?")) {
            this.processFunction();
        } else if (string.equalsIgnoreCase("CALL")) {
            this.processCall();
        } else if (string.equalsIgnoreCase("TS")) {
            this.processTimestamp();
        } else if (string.equalsIgnoreCase("T")) {
            this.processTime();
        } else if (string.equalsIgnoreCase("D")) {
            this.processDate();
        } else if (string.equalsIgnoreCase("ESCAPE")) {
            this.processEscape();
        } else if (string.equalsIgnoreCase("FN")) {
            this.processScalarFunction();
        } else if (string.equalsIgnoreCase("OJ")) {
            this.processOuterJoin();
        } else {
            String string2 = new String(this.index + ": \"" + this.token + "\" token is not supported");
            throw TbError.newSQLException(-90632, string2);
        }
    }

    public static String replace(String string) {
        int n = 0;
        char[] cArray = new char[string.length() + 1];
        StringBuffer stringBuffer = new StringBuffer(string.length());
        string.getChars(0, string.length(), cArray, 0);
        while (true) {
            if (cArray[n] == '-' && cArray[n + 1] == '-') {
                stringBuffer.append(cArray[n]);
                stringBuffer.append(cArray[n + 1]);
                n += 2;
                while (cArray[n] != '\n') {
                    if (cArray[n] == '\u0000') {
                        return stringBuffer.toString();
                    }
                    stringBuffer.append(cArray[n]);
                    ++n;
                }
                stringBuffer.append(cArray[n]);
                ++n;
                continue;
            }
            if (cArray[n] == '\"') {
                stringBuffer.append(cArray[n]);
                ++n;
                while (cArray[n] != '\"') {
                    if (cArray[n] == '\u0000') {
                        return stringBuffer.toString();
                    }
                    stringBuffer.append(cArray[n]);
                    ++n;
                }
                stringBuffer.append(cArray[n]);
                ++n;
                continue;
            }
            if (cArray[n] == '\'') {
                stringBuffer.append(cArray[n]);
                ++n;
                while (cArray[n] != '\'') {
                    if (cArray[n] == '\u0000') {
                        return stringBuffer.toString();
                    }
                    stringBuffer.append(cArray[n]);
                    ++n;
                }
                stringBuffer.append(cArray[n]);
                ++n;
                continue;
            }
            if (cArray[n] == '/' && cArray[n + 1] == '*') {
                stringBuffer.append(cArray[n]);
                stringBuffer.append(cArray[n + 1]);
                n += 2;
                while (cArray[n] != '*' || cArray[n + 1] != '/') {
                    if (cArray[n] == '\u0000') {
                        return stringBuffer.toString();
                    }
                    stringBuffer.append(cArray[n]);
                    ++n;
                }
                stringBuffer.append(cArray[n]);
                stringBuffer.append(cArray[n + 1]);
                n += 2;
                continue;
            }
            if (cArray[n] == '\u0000') {
                return stringBuffer.toString();
            }
            if (cArray[n] == '?' && Character.isDigit(cArray[n + 1])) {
                int n2 = n;
                n += 2;
                while (Character.isDigit(cArray[n])) {
                    ++n;
                }
                if (Character.isLetter(cArray[n])) {
                    stringBuffer.append(string.substring(n2, n));
                    continue;
                }
                stringBuffer.append(":");
                stringBuffer.append(string.substring(n2 + 1, n));
                continue;
            }
            stringBuffer.append(cArray[n]);
            ++n;
        }
    }

    public static String replaceIDEOGraphicSpace(String string) {
        char c;
        try {
            c = new String(IDEOGRAPHIC_SPACE, "utf8").charAt(0);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
        if (string == null || string.indexOf(c) < 0) {
            return string;
        }
        int n = 0;
        char[] cArray = new char[string.length() + 1];
        StringBuffer stringBuffer = new StringBuffer(string.length());
        string.getChars(0, string.length(), cArray, 0);
        while (true) {
            if (cArray[n] == '-' && cArray[n + 1] == '-') {
                stringBuffer.append(cArray[n]);
                stringBuffer.append(cArray[n + 1]);
                n += 2;
                while (cArray[n] != '\n') {
                    if (cArray[n] == '\u0000') {
                        return stringBuffer.toString();
                    }
                    stringBuffer.append(cArray[n]);
                    ++n;
                }
                stringBuffer.append(cArray[n]);
                ++n;
                continue;
            }
            if (cArray[n] == '\"') {
                stringBuffer.append(cArray[n]);
                ++n;
                while (cArray[n] != '\"') {
                    if (cArray[n] == '\u0000') {
                        return stringBuffer.toString();
                    }
                    stringBuffer.append(cArray[n]);
                    ++n;
                }
                stringBuffer.append(cArray[n]);
                ++n;
                continue;
            }
            if (cArray[n] == '\'') {
                stringBuffer.append(cArray[n]);
                ++n;
                while (cArray[n] != '\'') {
                    if (cArray[n] == '\u0000') {
                        return stringBuffer.toString();
                    }
                    stringBuffer.append(cArray[n]);
                    ++n;
                }
                stringBuffer.append(cArray[n]);
                ++n;
                continue;
            }
            if (cArray[n] == '/' && cArray[n + 1] == '*') {
                stringBuffer.append(cArray[n]);
                stringBuffer.append(cArray[n + 1]);
                n += 2;
                while (cArray[n] != '*' || cArray[n + 1] != '/') {
                    if (cArray[n] == '\u0000') {
                        return stringBuffer.toString();
                    }
                    stringBuffer.append(cArray[n]);
                    ++n;
                }
                stringBuffer.append(cArray[n]);
                stringBuffer.append(cArray[n + 1]);
                n += 2;
                continue;
            }
            if (cArray[n] == '\u0000') {
                return stringBuffer.toString();
            }
            if (cArray[n] == c) {
                stringBuffer.append(" ");
                ++n;
                continue;
            }
            stringBuffer.append(cArray[n]);
            ++n;
        }
    }

    private void skipWhitespace() {
        while (this.index < this.length) {
            this.chr = this.originalSql.charAt(this.index);
            if (this.chr != ' ' && this.chr != '\t' && this.chr != '\r' && this.chr != '\n') break;
            this.parsedSql.append(this.chr);
            ++this.index;
        }
    }
}

