/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.rowset;

import com.tmax.tibero.jdbc.TbBlob;
import com.tmax.tibero.jdbc.TbClobBase;
import com.tmax.tibero.jdbc.TbDriver;
import com.tmax.tibero.jdbc.TbNClob;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.rowset.TbCachedRowSetReader;
import com.tmax.tibero.jdbc.rowset.TbCachedRowSetWriter;
import com.tmax.tibero.jdbc.rowset.TbRow;
import com.tmax.tibero.jdbc.rowset.TbRowSet;
import com.tmax.tibero.jdbc.rowset.TbRowSetMetaData;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetInternal;
import javax.sql.RowSetMetaData;
import javax.sql.RowSetReader;
import javax.sql.RowSetWriter;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.RowSetWarning;
import javax.sql.rowset.spi.SyncFactory;
import javax.sql.rowset.spi.SyncFactoryException;
import javax.sql.rowset.spi.SyncProvider;
import javax.sql.rowset.spi.SyncProviderException;

public class TbCachedRowSet
extends TbRowSet
implements RowSetInternal,
Serializable,
CachedRowSet {
    private static final long serialVersionUID = -3966681529200633668L;
    private Connection conn;
    private ResultSet rs;
    private boolean isConnectionOpened = false;
    private RowSetMetaData rowsetMetaData;
    private Vector<TbRow> rows = new Vector();
    protected int currentRowIndex = 0;
    private int columnCount = 0;
    protected int rowCount = 0;
    private RowSetReader reader;
    private RowSetWriter writer;
    private String[] columnNames;
    private boolean isOnUpdate = false;
    private int updateRowIndex;
    private boolean isOnInsert = false;
    private int insertRowIndex;
    private TbRow temporaryRow;
    private int pageSize = 0;
    private int currentPageIndex = 0;
    private boolean prevColumnWasNull = false;
    private boolean isInitializedDriver = false;
    private boolean isPopulateCompleted = false;
    private int[] keyColumns;
    private String tableName;
    private RowSetWarning rowsetWarnings;
    private SyncProvider syncProvider;
    private static final String DEFAULT_SYNC_PROVIDER = "com.sun.rowset.providers.RIOptimisticProvider";

    public TbCachedRowSet() throws SQLException {
        try {
            this.syncProvider = SyncFactory.getInstance(DEFAULT_SYNC_PROVIDER);
        }
        catch (SyncFactoryException syncFactoryException) {
            throw TbError.newSQLException(-90820, syncFactoryException.getMessage());
        }
        this.setReader(new TbCachedRowSetReader());
        this.setWriter(new TbCachedRowSetWriter());
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        if (this.rowsetType == 1003) {
            throw TbError.newSQLException(-590758);
        }
        if (n == 0 || Math.abs(n) > this.rowCount) {
            return false;
        }
        this.currentRowIndex = n >= 0 ? n : this.rowCount + n + 1;
        this.notifyCursorMoved();
        return true;
    }

    @Override
    public void acceptChanges() throws SyncProviderException {
        try {
            this.getWriter().writeData(this);
        }
        catch (SQLException sQLException) {
            throw new SyncProviderException(sQLException.getMessage());
        }
    }

    @Override
    public void acceptChanges(Connection connection) throws SyncProviderException {
        this.conn = connection;
        this.isConnectionOpened = true;
        this.acceptChanges();
    }

    @Override
    public void afterLast() throws SQLException {
        this.currentRowIndex = this.rowCount + 1;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.currentRowIndex = 0;
    }

    public void cancelRowDelete() throws SQLException {
        if (!this.getCurrentRow().isDeleted()) {
            throw TbError.newSQLException(-90858);
        }
        this.getCurrentRow().markDeleted(false);
        this.notifyRowChanged();
    }

    public void cancelRowInsert() throws SQLException {
        if (this.getCurrentRow().isInserted()) {
            this.rows.remove(--this.currentRowIndex);
            --this.rowCount;
        } else {
            throw TbError.newSQLException(-90862);
        }
        this.notifyRowChanged();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        if (!this.getCurrentRow().isUpdated()) {
            throw TbError.newSQLException(-90863);
        }
        this.isOnUpdate = false;
        this.getCurrentRow().markUpdated(false);
        this.notifyRowChanged();
    }

    private void checkColumnIndex(int n) throws SQLException {
        if (this.readOnly) {
            throw TbError.newSQLException(-90825);
        }
        if (n < 1 || n > this.columnCount) {
            throw TbError.newSQLException(-90834, Integer.toString(n));
        }
    }

    @Override
    public void close() throws SQLException {
        this.release();
        this.isClosed = true;
    }

    @Override
    public boolean columnUpdated(int n) throws SQLException {
        if (this.isOnInsert) {
            throw TbError.newSQLException(-90851);
        }
        return this.getCurrentRow().isColumnChanged(n);
    }

    @Override
    public boolean columnUpdated(String string) throws SQLException {
        return this.columnUpdated(this.findColumn(string));
    }

    @Override
    public void commit() throws SQLException {
        this.getConnection().commit();
    }

    @Override
    public CachedRowSet createCopy() throws SQLException {
        TbCachedRowSet tbCachedRowSet = (TbCachedRowSet)this.createShared();
        int n = this.rows.size();
        tbCachedRowSet.rows = new Vector(n);
        for (int i = 0; i < n; ++i) {
            tbCachedRowSet.rows.add(this.rows.elementAt(i).createCopy());
        }
        return tbCachedRowSet;
    }

    @Override
    public CachedRowSet createCopyNoConstraints() throws SQLException {
        TbCachedRowSet tbCachedRowSet = (TbCachedRowSet)this.createCopy();
        tbCachedRowSet.initialize();
        tbCachedRowSet.listeners = new Vector();
        try {
            tbCachedRowSet.unsetMatchColumn(tbCachedRowSet.getMatchColumnIndexes());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            tbCachedRowSet.unsetMatchColumn(tbCachedRowSet.getMatchColumnNames());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return tbCachedRowSet;
    }

    @Override
    public CachedRowSet createCopySchema() throws SQLException {
        TbCachedRowSet tbCachedRowSet = (TbCachedRowSet)this.createCopy();
        tbCachedRowSet.rows = null;
        tbCachedRowSet.rowCount = 0;
        tbCachedRowSet.currentPageIndex = 0;
        return tbCachedRowSet;
    }

    @Override
    public RowSet createShared() throws SQLException {
        int n;
        TbCachedRowSet tbCachedRowSet = new TbCachedRowSet();
        tbCachedRowSet.rows = this.rows;
        tbCachedRowSet.setDataSourceName(this.getDataSourceName());
        tbCachedRowSet.setUsername(this.getUsername());
        tbCachedRowSet.setPassword(this.getPassword());
        tbCachedRowSet.setUrl(this.getUrl());
        tbCachedRowSet.setTypeMap((Map)this.getTypeMap());
        tbCachedRowSet.setMaxFieldSize(this.getMaxFieldSize());
        tbCachedRowSet.setMaxRows(this.getMaxRows());
        tbCachedRowSet.setQueryTimeout(this.getQueryTimeout());
        tbCachedRowSet.setFetchSize(this.getFetchSize());
        tbCachedRowSet.setEscapeProcessing(this.getEscapeProcessing());
        tbCachedRowSet.setConcurrency(this.getConcurrency());
        tbCachedRowSet.setReadOnly(this.readOnly);
        tbCachedRowSet.rowsetType = this.getType();
        tbCachedRowSet.setFetchDirection(this.getFetchDirection());
        tbCachedRowSet.setCommand(this.getCommand());
        tbCachedRowSet.setTransactionIsolation(this.getTransactionIsolation());
        tbCachedRowSet.currentRowIndex = this.currentRowIndex;
        tbCachedRowSet.columnCount = this.columnCount;
        tbCachedRowSet.rowCount = this.rowCount;
        tbCachedRowSet.showDeleted = this.showDeleted;
        tbCachedRowSet.syncProvider = this.syncProvider;
        tbCachedRowSet.currentPageIndex = this.currentPageIndex;
        tbCachedRowSet.pageSize = this.pageSize;
        tbCachedRowSet.tableName = this.tableName != null ? new String(this.tableName) : null;
        tbCachedRowSet.keyColumns = this.keyColumns != null ? (int[])this.keyColumns.clone() : null;
        int n2 = this.listeners.size();
        for (n = 0; n < n2; ++n) {
            tbCachedRowSet.listeners.add(this.listeners.elementAt(n));
        }
        tbCachedRowSet.rowsetMetaData = new TbRowSetMetaData(this.rowsetMetaData);
        n2 = this.params.size();
        for (n = 0; n < n2; ++n) {
            tbCachedRowSet.params.add(this.params.elementAt(n));
        }
        tbCachedRowSet.columnNames = new String[this.columnNames.length];
        System.arraycopy(this.columnNames, 0, tbCachedRowSet.columnNames, 0, this.columnNames.length);
        return tbCachedRowSet;
    }

    @Override
    public void deleteRow() throws SQLException {
        this.getCurrentRow().markDeleted(true);
        this.notifyRowChanged();
    }

    @Override
    public synchronized void execute() throws SQLException {
        this.isConnectionOpened = false;
        this.reader.readData(this);
    }

    @Override
    public synchronized void execute(Connection connection) throws SQLException {
        this.conn = connection;
        this.execute();
    }

    @Override
    public int findColumn(String string) throws SQLException {
        int n = 0;
        string = string.toUpperCase();
        for (n = 0; n < this.columnCount && !this.columnNames[n].equals(string); ++n) {
        }
        if (n == this.columnCount) {
            throw TbError.newSQLException(-90835, string);
        }
        return n + 1;
    }

    @Override
    public boolean first() throws SQLException {
        return this.absolute(1);
    }

    @Override
    public Array getArray(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof Array) {
            return (Array)object;
        }
        throw TbError.newSQLException(-90836, object.toString());
    }

    @Override
    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        InputStream inputStream = this.getStream(n);
        return inputStream != null ? inputStream : null;
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        Number number = this.getNumeric(n);
        if (number == null || number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof Number) {
            return new BigDecimal(number.doubleValue());
        }
        throw TbError.newSQLException(-90836, number.toString());
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return this.getBigDecimal(n);
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        InputStream inputStream = this.getStream(n);
        return inputStream != null ? inputStream : null;
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof TbBlob) {
            return (Blob)object;
        }
        throw TbError.newSQLException(-90836, object.toString());
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue() != 0.0;
        }
        throw TbError.newSQLException(-90836, object.toString());
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    @Override
    public byte getByte(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return 0;
        }
        if (object instanceof Number) {
            return ((Number)object).byteValue();
        }
        if (object instanceof String) {
            return ((String)object).getBytes()[0];
        }
        if (object instanceof TbBlob) {
            TbBlob tbBlob = (TbBlob)object;
            return tbBlob.getBytes(0L, 1)[0];
        }
        if (object instanceof TbClobBase) {
            TbClobBase tbClobBase = (TbClobBase)object;
            return tbClobBase.getSubString(0L, 1).getBytes()[0];
        }
        throw TbError.newSQLException(-90836, object.toString());
    }

    @Override
    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof String) {
            return ((String)object).getBytes();
        }
        if (object instanceof Number) {
            return ((Number)object).toString().getBytes();
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).toString().getBytes();
        }
        if (object instanceof TbBlob) {
            TbBlob tbBlob = (TbBlob)object;
            return tbBlob.getBytes(0L, (int)tbBlob.length());
        }
        if (object instanceof TbClobBase) {
            TbClobBase tbClobBase = (TbClobBase)object;
            return tbClobBase.getSubString(0L, (int)tbClobBase.length()).getBytes();
        }
        throw TbError.newSQLException(-90836, object.toString());
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        return this.getCharacterStreamInternal(n);
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStreamInternal(this.findColumn(string));
    }

    private Reader getCharacterStreamInternal(int n) throws SQLException {
        InputStream inputStream = this.getAsciiStream(n);
        if (inputStream == null) {
            return null;
        }
        try {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while ((n2 = inputStream.read()) != -1) {
                stringBuffer.append((char)n2);
            }
            char[] cArray = new char[stringBuffer.length()];
            stringBuffer.getChars(0, stringBuffer.length(), cArray, 0);
            return new CharArrayReader(cArray);
        }
        catch (IOException iOException) {
            throw TbError.newSQLException(-90829, iOException.getMessage());
        }
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof TbClobBase) {
            return (Clob)object;
        }
        throw TbError.newSQLException(-90836, object.toString());
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.conn == null || this.conn.isClosed()) {
            String string = this.getUsername();
            String string2 = this.getPassword();
            String string3 = this.getUrl();
            String string4 = this.getDataSourceName();
            if (string4 != null && !string4.equals("")) {
                try {
                    Object object;
                    InitialContext initialContext = null;
                    try {
                        object = System.getProperties();
                        initialContext = new InitialContext((Hashtable<?, ?>)object);
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    if (initialContext == null) {
                        initialContext = new InitialContext();
                    }
                    object = (DataSource)initialContext.lookup(string4);
                    if (this.username == null || string2 == null) {
                        this.conn = object.getConnection();
                    }
                    this.conn = object.getConnection(this.username, string2);
                }
                catch (NamingException namingException) {
                    throw TbError.newSQLException(-90828, namingException.getMessage());
                }
            } else if (string3 != null && !string3.equals("")) {
                if (!this.isInitializedDriver) {
                    DriverManager.registerDriver(new TbDriver());
                    this.isInitializedDriver = true;
                }
                if (string.equals("") || string2.equals("")) {
                    throw TbError.newSQLException(-90854, "(" + string + "," + string2 + ")");
                }
                this.conn = DriverManager.getConnection(string3, string, string2);
            } else {
                throw TbError.newSQLException(-90852);
            }
        }
        return this.conn;
    }

    protected TbRow getCurrentRow() throws SQLException {
        if (this.currentRowIndex < 1 || this.currentRowIndex > this.rowCount) {
            throw TbError.newSQLException(-90847, "(" + this.currentRowIndex + "," + this.rowCount + ")");
        }
        return this.rows.elementAt(this.currentRowIndex - 1);
    }

    @Override
    public String getCursorName() throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public Date getDate(int n) throws SQLException {
        return this.getDateInternal(n, null);
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.getDateInternal(n, calendar);
    }

    @Override
    public Date getDate(String string) throws SQLException {
        return this.getDateInternal(this.findColumn(string), null);
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDateInternal(this.findColumn(string), calendar);
    }

    private Date getDateInternal(int n, Calendar calendar) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof Time) {
            return new Date(((Time)object).getTime());
        }
        if (object instanceof Date) {
            if (calendar == null) {
                calendar = Calendar.getInstance();
            }
            calendar.setTime((Date)object);
            return new Date(calendar.getTime().getTime());
        }
        throw TbError.newSQLException(-90836, object.toString());
    }

    @Override
    public double getDouble(int n) throws SQLException {
        Number number = this.getNumeric(n);
        return number != null ? number.doubleValue() : 0.0;
    }

    @Override
    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    @Override
    public float getFloat(int n) throws SQLException {
        Number number = this.getNumeric(n);
        return number != null ? number.floatValue() : 0.0f;
    }

    @Override
    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    @Override
    public int getHoldability() throws SQLException {
        return 1;
    }

    @Override
    public int getInt(int n) throws SQLException {
        Number number = this.getNumeric(n);
        return number != null ? number.intValue() : 0;
    }

    @Override
    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    @Override
    public int[] getKeyColumns() throws SQLException {
        return this.keyColumns;
    }

    @Override
    public long getLong(int n) throws SQLException {
        Number number = this.getNumeric(n);
        return number != null ? number.longValue() : 0L;
    }

    @Override
    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.rowsetMetaData;
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        return this.getCharacterStreamInternal(n);
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        return this.getCharacterStreamInternal(this.findColumn(string));
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof TbNClob) {
            return (NClob)object;
        }
        throw TbError.newSQLException(-90836, object.toString());
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        return this.getNClob(this.findColumn(string));
    }

    @Override
    public String getNString(int n) throws SQLException {
        return this.getStringInternal(n);
    }

    @Override
    public String getNString(String string) throws SQLException {
        return this.getStringInternal(this.findColumn(string));
    }

    private synchronized Number getNumeric(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof BigDecimal || object instanceof Number) {
            return (Number)object;
        }
        if (object instanceof Boolean) {
            return new Integer((Boolean)object != false ? 1 : 0);
        }
        if (!(object instanceof String)) {
            throw TbError.newSQLException(-90836, object.toString());
        }
        try {
            return new BigDecimal((String)object);
        }
        catch (NumberFormatException numberFormatException) {
            throw TbError.newSQLException(-90829, ((String)object).toString());
        }
    }

    @Override
    public Object getObject(int n) throws SQLException {
        Object object = null;
        object = !this.isUpdated(n) ? this.getCurrentRow().getColumn(n) : this.getCurrentRow().getChangedColumn(n);
        this.prevColumnWasNull = object == null;
        return object;
    }

    @Override
    public Object getObject(int n, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(n);
    }

    @Override
    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    @Override
    public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }

    @Override
    public ResultSet getOriginal() throws SQLException {
        TbCachedRowSet tbCachedRowSet = new TbCachedRowSet();
        tbCachedRowSet.rowsetMetaData = this.rowsetMetaData;
        tbCachedRowSet.columnCount = this.columnCount;
        tbCachedRowSet.rowCount = this.rowCount;
        tbCachedRowSet.currentRowIndex = 0;
        tbCachedRowSet.setType(1004);
        tbCachedRowSet.setConcurrency(1008);
        tbCachedRowSet.setReader(null);
        tbCachedRowSet.setWriter(null);
        TbRow tbRow = null;
        Iterator<TbRow> iterator = this.rows.iterator();
        while (iterator.hasNext()) {
            tbRow = new TbRow(this.columnCount, iterator.next().getOriginalRow());
            tbCachedRowSet.rows.add(tbRow);
        }
        return tbCachedRowSet;
    }

    @Override
    public ResultSet getOriginalRow() throws SQLException {
        TbCachedRowSet tbCachedRowSet = new TbCachedRowSet();
        tbCachedRowSet.rowsetMetaData = this.rowsetMetaData;
        tbCachedRowSet.columnCount = this.columnCount;
        tbCachedRowSet.rowCount = 1;
        tbCachedRowSet.currentRowIndex = 0;
        tbCachedRowSet.setReader(null);
        tbCachedRowSet.setWriter(null);
        TbRow tbRow = new TbRow(this.rowsetMetaData.getColumnCount(), this.getCurrentRow().getOriginalRow());
        tbCachedRowSet.rows.add(tbRow);
        return tbCachedRowSet;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    public RowSetReader getReader() throws SQLException {
        return this.reader;
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof Ref) {
            return (Ref)object;
        }
        throw TbError.newSQLException(-90836, object.toString());
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    @Override
    public int getRow() throws SQLException {
        if (this.currentRowIndex > this.rowCount) {
            return this.rowCount;
        }
        return this.currentRowIndex;
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof RowId) {
            return (RowId)object;
        }
        throw TbError.newSQLException(-90836, object.toString());
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        return this.getRowId(this.findColumn(string));
    }

    @Override
    public RowSetWarning getRowSetWarnings() throws SQLException {
        return this.rowsetWarnings;
    }

    @Override
    public short getShort(int n) throws SQLException {
        Number number = this.getNumeric(n);
        return number != null ? number.shortValue() : (short)0;
    }

    @Override
    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof SQLXML) {
            return (SQLXML)object;
        }
        throw TbError.newSQLException(-90836, object.toString());
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        return this.getSQLXML(this.findColumn(string));
    }

    @Override
    public Statement getStatement() throws SQLException {
        if (this.rs == null) {
            throw TbError.newSQLException(-90859);
        }
        return this.rs.getStatement();
    }

    private synchronized InputStream getStream(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof InputStream) {
            return (InputStream)object;
        }
        if (object instanceof String) {
            return new ByteArrayInputStream(((String)object).getBytes());
        }
        if (object instanceof byte[]) {
            return new ByteArrayInputStream((byte[])object);
        }
        if (object instanceof TbClobBase) {
            return ((TbClobBase)object).getAsciiStream();
        }
        if (object instanceof TbBlob) {
            return ((TbBlob)object).getBinaryStream();
        }
        if (!(object instanceof Reader)) {
            try {
                int n2 = 0;
                BufferedReader bufferedReader = new BufferedReader((Reader)object);
                PipedInputStream pipedInputStream = new PipedInputStream();
                PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);
                while ((n2 = bufferedReader.read()) != -1) {
                    pipedOutputStream.write(n2);
                }
                pipedOutputStream.close();
                return pipedInputStream;
            }
            catch (IOException iOException) {
                throw TbError.newSQLException(-90829, iOException.getMessage());
            }
        }
        throw TbError.newSQLException(-90836, object.toString());
    }

    @Override
    public String getString(int n) throws SQLException {
        return this.getStringInternal(n);
    }

    @Override
    public String getString(String string) throws SQLException {
        return this.getStringInternal(this.findColumn(string));
    }

    private String getStringInternal(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Number || object instanceof BigDecimal) {
            return object.toString();
        }
        if (object instanceof Date) {
            return ((Date)object).toString();
        }
        if (object instanceof Timestamp) {
            return ((Date)object).toString();
        }
        if (object instanceof byte[]) {
            return new String((byte[])object);
        }
        if (object instanceof TbClobBase) {
            TbClobBase tbClobBase = (TbClobBase)object;
            return tbClobBase.getSubString(0L, (int)tbClobBase.length());
        }
        if (object instanceof TbBlob) {
            TbBlob tbBlob = (TbBlob)object;
            return new String(tbBlob.getBytes(0L, (int)tbBlob.length()));
        }
        if (object instanceof URL) {
            return ((URL)object).toString();
        }
        if (!(object instanceof Reader)) {
            throw TbError.newSQLException(-90836, object.toString());
        }
        try {
            Reader reader = (Reader)object;
            char[] cArray = new char[1024];
            int n2 = 0;
            StringBuffer stringBuffer = new StringBuffer(1024);
            while ((n2 = reader.read(cArray)) > 0) {
                stringBuffer.append(cArray, 0, n2);
            }
            return stringBuffer.substring(0, stringBuffer.length());
        }
        catch (IOException iOException) {
            throw TbError.newSQLException(-90829, iOException.getMessage());
        }
    }

    @Override
    public SyncProvider getSyncProvider() throws SQLException {
        return this.syncProvider;
    }

    @Override
    public String getTableName() throws SQLException {
        return this.tableName;
    }

    @Override
    public Time getTime(int n) throws SQLException {
        return this.getTimeInternal(n, null);
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.getTimeInternal(n, calendar);
    }

    @Override
    public Time getTime(String string) throws SQLException {
        return this.getTimeInternal(this.findColumn(string), null);
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTimeInternal(this.findColumn(string), calendar);
    }

    private Time getTimeInternal(int n, Calendar calendar) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof Time) {
            return (Time)object;
        }
        if (object instanceof java.util.Date) {
            if (calendar == null) {
                calendar = Calendar.getInstance();
            }
            calendar.setTime((Date)object);
            return new Time(calendar.getTime().getTime());
        }
        throw TbError.newSQLException(-90836, object.toString());
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        return this.getTimestampInternal(n, null);
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.getTimestampInternal(n, calendar);
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestampInternal(this.findColumn(string), null);
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestampInternal(this.findColumn(string), calendar);
    }

    private Timestamp getTimestampInternal(int n, Calendar calendar) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof Timestamp) {
            return (Timestamp)object;
        }
        if (object instanceof Date) {
            if (calendar == null) {
                calendar = Calendar.getInstance();
            }
            calendar.setTime((Date)object);
            return new Timestamp(((java.util.Date)object).getTime());
        }
        throw TbError.newSQLException(-90836, object.toString());
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int n) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    @Override
    public URL getURL(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof URL) {
            return (URL)object;
        }
        throw TbError.newSQLException(-90836, object.toString());
    }

    @Override
    public URL getURL(String string) throws SQLException {
        return this.getURL(this.findColumn(string));
    }

    public RowSetWriter getWriter() throws SQLException {
        return this.writer;
    }

    @Override
    public void insertRow() throws SQLException {
        if (!this.isOnInsert) {
            throw TbError.newSQLException(-90822);
        }
        if (!this.temporaryRow.isPopulationCompleted()) {
            throw TbError.newSQLException(-90865);
        }
        this.temporaryRow.insertRow();
        this.rows.insertElementAt(this.temporaryRow, this.insertRowIndex - 1);
        this.isOnInsert = false;
        ++this.rowCount;
        this.notifyRowChanged();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.rowCount > 0 && this.currentRowIndex == this.rowCount + 1;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.rowCount > 0 && this.currentRowIndex == 0;
    }

    boolean isConnectionOpened() {
        return this.isConnectionOpened;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.currentRowIndex == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.currentRowIndex == this.rowCount;
    }

    private final boolean isUpdated(int n) throws SQLException {
        if (n < 1 || n > this.columnCount) {
            throw TbError.newSQLException(-90834, Integer.toString(n));
        }
        return this.getCurrentRow().isColumnChanged(n);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isInstance(this);
    }

    @Override
    public boolean last() throws SQLException {
        return this.absolute(-1);
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.isOnInsert = false;
        this.isOnUpdate = false;
        this.absolute(this.currentRowIndex);
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.temporaryRow = new TbRow(this.columnCount, true);
        this.isOnInsert = true;
        this.insertRowIndex = this.isAfterLast() ? this.currentRowIndex : this.currentRowIndex + 1;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.rowCount < 0) {
            return false;
        }
        if (this.fetchDirection == 1000 || this.fetchDirection == 1002) {
            if (this.currentRowIndex + 1 <= this.rowCount) {
                ++this.currentRowIndex;
                if (!this.showDeleted && this.getCurrentRow().isDeleted()) {
                    return this.next();
                }
                this.notifyCursorMoved();
                return true;
            }
            this.currentRowIndex = this.rowCount + 1;
            return false;
        }
        if (this.fetchDirection == 1001) {
            if (this.currentRowIndex - 1 > 0) {
                --this.currentRowIndex;
                if (!this.showDeleted && this.getCurrentRow().isDeleted()) {
                    return this.next();
                }
                this.notifyCursorMoved();
                return true;
            }
            this.currentRowIndex = 0;
            return false;
        }
        return false;
    }

    @Override
    public boolean nextPage() throws SQLException {
        if (this.fetchDirection == 1001 && this.rs != null && this.rs.getType() == 1003) {
            throw TbError.newSQLException(-90850);
        }
        if (this.rows.size() == 0 && !this.isPopulateCompleted) {
            throw TbError.newSQLException(-90853);
        }
        this.populate(this.rs);
        ++this.currentPageIndex;
        return !this.isPopulateCompleted;
    }

    @Override
    protected synchronized void notifyCursorMoved() {
        if (this.isOnInsert) {
            this.isOnInsert = false;
            this.temporaryRow.markUpdated(false);
            this.warnings.setNextWarning(new SQLWarning("Insertion is canceled because of the cursor"));
        } else if (this.isOnUpdate) {
            try {
                this.isOnUpdate = false;
                int n = this.currentRowIndex;
                this.currentRowIndex = this.updateRowIndex;
                this.getCurrentRow().markUpdated(false);
                this.currentRowIndex = n;
                this.warnings.setNextWarning(new SQLWarning("All Updates are canceled because of the cursor"));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        super.notifyCursorMoved();
    }

    @Override
    public void populate(ResultSet resultSet) throws SQLException {
        int n;
        if (this.rows == null) {
            this.rows = new Vector(100, 10);
        }
        this.rowsetMetaData = new TbRowSetMetaData(resultSet.getMetaData());
        this.columnCount = this.rowsetMetaData.getColumnCount();
        this.columnNames = new String[this.columnCount];
        for (n = 0; n < this.columnCount; ++n) {
            this.columnNames[n] = this.rowsetMetaData.getColumnName(n + 1);
        }
        n = this.fetchDirection == 1000 || this.fetchDirection == 1002 ? 1 : 0;
        this.rowCount = 0;
        int n2 = this.maxRows == 0 && this.pageSize == 0 ? Integer.MAX_VALUE : (this.maxRows == 0 || this.pageSize == 0 ? Math.max(this.maxRows, this.pageSize) : Math.min(this.maxRows, this.pageSize));
        if (resultSet.getType() != 1003 && this.rows.size() == 0 && n == 0) {
            resultSet.afterLast();
        }
        while (this.rowCount < n2 && (n != 0 ? resultSet.next() : resultSet.previous())) {
            TbRow tbRow = new TbRow(this.columnCount);
            for (int i = 1; i <= this.columnCount; ++i) {
                tbRow.setColumn(i, resultSet.getObject(i));
                tbRow.markNull(i, resultSet.wasNull());
            }
            if (n != 0) {
                this.rows.add(tbRow);
            } else {
                this.rows.add(1, tbRow);
            }
            ++this.rowCount;
        }
        if (n != 0 && resultSet.isAfterLast() || n == 0 && resultSet.isBeforeFirst()) {
            this.isPopulateCompleted = true;
        }
        this.conn = null;
        this.notifyRowSetChanged();
    }

    @Override
    public void populate(ResultSet resultSet, int n) throws SQLException {
        if (n < 0) {
            throw TbError.newSQLException(-90847, Integer.toString(n));
        }
        if (resultSet == null) {
            throw TbError.newSQLException(-90823);
        }
        if (resultSet.getType() == 1003) {
            int n2 = 0;
            for (n2 = 0; resultSet.next() && n2 < n; ++n2) {
            }
            if (n2 < n) {
                throw TbError.newSQLException(-90868);
            }
        } else {
            resultSet.absolute(n);
        }
        this.populate(resultSet);
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.rowCount < 0) {
            return false;
        }
        if (this.fetchDirection == 1001) {
            if (this.currentRowIndex + 1 <= this.rowCount) {
                ++this.currentRowIndex;
                if (!this.showDeleted && this.getCurrentRow().isDeleted()) {
                    return this.previous();
                }
                this.notifyCursorMoved();
                return true;
            }
            this.currentRowIndex = this.rowCount + 1;
            return false;
        }
        if (this.fetchDirection == 1000 || this.fetchDirection == 1002) {
            if (this.currentRowIndex - 1 > 0) {
                --this.currentRowIndex;
                if (!this.showDeleted && this.getCurrentRow().isDeleted()) {
                    return this.previous();
                }
                this.notifyCursorMoved();
                return true;
            }
            this.currentRowIndex = 0;
            return false;
        }
        return false;
    }

    @Override
    public boolean previousPage() throws SQLException {
        if (this.rs != null && this.rs.getType() == 1003) {
            throw TbError.newSQLException(-90850);
        }
        if (this.rows.size() == 0 && !this.isPopulateCompleted) {
            throw TbError.newSQLException(-90853);
        }
        if (this.fetchDirection == 1001) {
            this.rs.relative(this.pageSize * 2);
        } else {
            this.rs.relative(-2 * this.pageSize);
        }
        this.populate(this.rs);
        if (this.currentPageIndex > 0) {
            --this.currentPageIndex;
        }
        return this.currentPageIndex != 0;
    }

    @Override
    public void refreshRow() throws SQLException {
        TbRow tbRow = this.getCurrentRow();
        if (tbRow.isUpdated()) {
            tbRow.cancelUpdated();
        }
    }

    @Override
    public boolean relative(int n) throws SQLException {
        return this.absolute(this.currentRowIndex + n);
    }

    @Override
    public void release() throws SQLException {
        this.rows = null;
        this.rows = new Vector();
        if (this.conn != null && !this.conn.isClosed()) {
            this.conn.close();
        }
        this.rowCount = 0;
        this.currentRowIndex = 0;
        this.notifyRowSetChanged();
    }

    @Override
    public void restoreOriginal() throws SQLException {
        boolean bl = false;
        for (int i = 0; i < this.rowCount; ++i) {
            TbRow tbRow = this.rows.elementAt(i);
            if (tbRow.isInserted()) {
                this.rows.remove(i);
                --this.rowCount;
                --i;
                bl = true;
                continue;
            }
            if (tbRow.isUpdated()) {
                tbRow.markUpdated(false);
                bl = true;
                continue;
            }
            if (!tbRow.isDeleted()) continue;
            tbRow.markDeleted(false);
            bl = true;
        }
        if (!bl) {
            throw TbError.newSQLException(-90857);
        }
        this.notifyRowSetChanged();
        this.currentRowIndex = 0;
    }

    @Override
    public void rollback() throws SQLException {
        this.getConnection().rollback();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        Connection connection = this.getConnection();
        boolean bl = connection.getAutoCommit();
        connection.setAutoCommit(false);
        try {
            connection.rollback(savepoint);
            connection.setAutoCommit(bl);
        }
        catch (SQLException sQLException) {
            connection.setAutoCommit(bl);
            throw sQLException;
        }
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return this.getCurrentRow().isDeleted();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return this.getCurrentRow().isInserted();
    }

    @Override
    public void rowSetPopulated(RowSetEvent rowSetEvent, int n) throws SQLException {
        if (n < 0 || n < this.getFetchSize()) {
            throw TbError.newSQLException(-90848, Integer.toString(n));
        }
        if (this.size() % n == 0) {
            this.rowsetEvent = new RowSetEvent(this);
            this.notifyRowSetChanged();
        }
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return this.getCurrentRow().isUpdated();
    }

    protected void setConnection(Connection connection) throws SQLException {
        this.conn = connection;
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        if (this.rowsetType == 1005) {
            throw TbError.newSQLException(-590759);
        }
        switch (n) {
            case 1000: 
            case 1002: {
                this.currentRowIndex = 0;
                break;
            }
            case 1001: {
                if (this.rowsetType == 1003) {
                    throw TbError.newSQLException(-590760);
                }
                this.currentRowIndex = this.rowCount + 1;
                break;
            }
            default: {
                throw TbError.newSQLException(-90838, Integer.toString(n));
            }
        }
        super.setFetchDirection(n);
    }

    @Override
    public void setKeyColumns(int[] nArray) throws SQLException {
        int n = 0;
        if (this.rowsetMetaData != null) {
            n = this.rowsetMetaData.getColumnCount();
            if (nArray == null || nArray.length > n) {
                throw TbError.newSQLException(-90839);
            }
        }
        int n2 = nArray.length;
        this.keyColumns = new int[n2];
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] <= 0 || nArray[i] > n) {
                throw TbError.newSQLException(-90834, Integer.toString(nArray[i]));
            }
            this.keyColumns[i] = nArray[i];
        }
    }

    @Override
    public void setMetaData(RowSetMetaData rowSetMetaData) throws SQLException {
        this.rowsetMetaData = rowSetMetaData;
        if (rowSetMetaData != null) {
            this.columnCount = rowSetMetaData.getColumnCount();
        }
    }

    public void setOriginal() throws SQLException {
        int n = 1;
        do {
            boolean bl;
            if (bl = this.setOriginalInternal(n)) continue;
            ++n;
        } while (n <= this.rowCount);
        this.notifyRowSetChanged();
        this.currentRowIndex = 0;
    }

    private boolean setOriginalInternal(int n) throws SQLException {
        if (n < 1 || n > this.rowCount) {
            throw TbError.newSQLException(-90837);
        }
        boolean bl = false;
        TbRow tbRow = this.rows.elementAt(n - 1);
        if (tbRow.isDeleted()) {
            this.rows.remove(n - 1);
            --this.rowCount;
            bl = true;
        } else {
            if (tbRow.isInserted()) {
                tbRow.markInserted(false);
            }
            if (tbRow.isUpdated()) {
                tbRow.commitChangedColumns();
            }
        }
        return bl;
    }

    @Override
    public void setOriginalRow() throws SQLException {
        if (this.isOnInsert) {
            throw TbError.newSQLException(-90851);
        }
        this.setOriginalInternal(this.currentRowIndex);
    }

    @Override
    public void setPageSize(int n) throws SQLException {
        if (n < 0 || this.maxRows > 0 && n > this.maxRows) {
            throw TbError.newSQLException(-90843, Integer.toString(n));
        }
        this.pageSize = n;
    }

    public void setReader(RowSetReader rowSetReader) throws SQLException {
        this.reader = rowSetReader;
    }

    @Override
    public void setSyncProvider(String string) throws SQLException {
        this.syncProvider = SyncFactory.getInstance(string);
        this.reader = this.syncProvider.getRowSetReader();
        this.writer = this.syncProvider.getRowSetWriter();
    }

    @Override
    public void setTableName(String string) throws SQLException {
        this.tableName = string;
    }

    public void setWriter(RowSetWriter rowSetWriter) throws SQLException {
        this.writer = rowSetWriter;
    }

    @Override
    public int size() {
        return this.rowCount;
    }

    public Collection<Collection<Object>> toCollection() throws SQLException {
        Map<Integer, Collection<Object>> map = Collections.synchronizedMap(new TreeMap());
        try {
            for (int i = 0; i < this.rowCount; ++i) {
                map.put(new Integer(i), this.rows.elementAt(i).toCollection());
            }
        }
        catch (Exception exception) {
            map = null;
            throw TbError.newSQLException(-90831);
        }
        return map.values();
    }

    public Collection<Object> toCollection(int n) throws SQLException {
        if (n < 1 || n > this.columnCount) {
            throw TbError.newSQLException(-90834, Integer.toString(n));
        }
        Vector<Object> vector = new Vector<Object>(this.rowCount);
        for (int i = 0; i < this.rowCount; ++i) {
            TbRow tbRow = this.rows.elementAt(i);
            Object object = tbRow.isColumnChanged(i) ? tbRow.getChangedColumn(i) : tbRow.getColumn(i);
            vector.add(object);
        }
        return vector;
    }

    public Collection<Object> toCollection(String string) throws SQLException {
        return this.toCollection(this.findColumn(string));
    }

    @Override
    public void undoDelete() throws SQLException {
        this.cancelRowDelete();
    }

    @Override
    public void undoInsert() throws SQLException {
        this.cancelRowInsert();
    }

    @Override
    public void undoUpdate() throws SQLException {
        this.cancelRowUpdates();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            return clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            throw TbError.newSQLException(-90657);
        }
    }

    @Override
    public void updateArray(int n, Array array) throws SQLException {
        this.updateObject(n, (Object)array);
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        this.updateArray(this.findColumn(string), array);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        this.updateAsciiStream(n, inputStream, Integer.MAX_VALUE);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            char[] cArray = new char[n2];
            int n3 = 0;
            while ((n3 += inputStreamReader.read(cArray, n3, n2 - n3)) < n2) {
            }
            this.updateObject(n, (Object)new CharArrayReader(cArray));
            cArray = null;
        }
        catch (IOException iOException) {
            throw TbError.newSQLException(-90829, iOException.getMessage());
        }
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        if (l > Integer.MAX_VALUE) {
            throw TbError.newSQLException(-90656, Long.toString(l));
        }
        this.updateAsciiStream(n, inputStream, (int)l);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, l);
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.updateObject(n, (Object)bigDecimal);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(n, inputStream, Integer.MAX_VALUE);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            byte[] byArray = new byte[n2];
            int n3 = 0;
            while ((n3 += inputStream.read(byArray, n3, n2 - n3)) < n2) {
            }
            this.updateObject(n, (Object)new ByteArrayInputStream(byArray));
            byArray = null;
        }
        catch (IOException iOException) {
            throw TbError.newSQLException(-90829, iOException.getMessage());
        }
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        if (l > Integer.MAX_VALUE) {
            throw TbError.newSQLException(-90656, Long.toString(l));
        }
        this.updateBinaryStream(n, inputStream, (int)l);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, l);
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        this.updateObject(n, (Object)blob);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(n, inputStream);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        this.updateBinaryStream(n, inputStream, l);
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        this.updateBlob(this.findColumn(string), blob);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, l);
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.updateObject(n, (Object)new Boolean(bl));
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
        this.updateObject(n, (Object)new Byte(by));
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.updateObject(n, (Object)byArray);
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        this.updateCharacterStream(n, reader, Integer.MAX_VALUE);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        try {
            char[] cArray = new char[n2];
            int n3 = 0;
            while ((n3 += reader.read(cArray, n3, n2 - n3)) < n2) {
            }
            this.updateObject(n, (Object)new CharArrayReader(cArray));
            cArray = null;
        }
        catch (IOException iOException) {
            throw TbError.newSQLException(-90829, iOException.getMessage());
        }
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        if (l > Integer.MAX_VALUE) {
            throw TbError.newSQLException(-90656, Long.toString(l));
        }
        this.updateCharacterStream(n, reader, (int)l);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, l);
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        this.updateObject(n, (Object)clob);
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException {
        this.updateCharacterStream(n, reader);
    }

    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException {
        this.updateCharacterStream(n, reader, l);
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        this.updateClob(this.findColumn(string), clob);
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader);
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, l);
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
        this.updateObject(n, (Object)date);
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        this.updateObject(n, (Object)new Double(d));
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        this.updateObject(n, (Object)new Float(f));
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        this.updateObject(n, (Object)new Integer(n2));
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        this.updateObject(n, (Object)new Long(l));
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        this.updateCharacterStream(n, reader);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.updateCharacterStream(n, reader, l);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, l);
    }

    @Override
    public void updateNClob(int n, NClob nClob) throws SQLException {
        this.updateObject(n, (Object)nClob);
    }

    @Override
    public void updateNClob(int n, Reader reader) throws SQLException {
        this.updateCharacterStream(n, reader);
    }

    @Override
    public void updateNClob(int n, Reader reader, long l) throws SQLException {
        this.updateCharacterStream(n, reader, l);
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        this.updateNClob(this.findColumn(string), nClob);
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader);
    }

    @Override
    public void updateNClob(String string, Reader reader, long l) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, l);
    }

    @Override
    public void updateNString(int n, String string) throws SQLException {
        this.updateObject(n, (Object)string);
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        this.updateNString(this.findColumn(string), string2);
    }

    @Override
    public void updateNull(int n) throws SQLException {
        this.updateObject(n, null);
    }

    @Override
    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        this.checkColumnIndex(n);
        if (this.isOnInsert) {
            this.temporaryRow.updateObject(n, object);
        } else if (!this.isBeforeFirst() && !this.isAfterLast()) {
            this.isOnUpdate = true;
            this.updateRowIndex = this.currentRowIndex;
            this.getCurrentRow().updateObject(n, object);
        } else {
            throw TbError.newSQLException(-90855);
        }
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        if (!(object instanceof Number)) {
            throw TbError.newSQLException(-90836, object.toString());
        }
        this.updateObject(n, (Object)new BigDecimal(new BigInteger(((Number)object).toString()), n2));
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
        this.updateObject(n, (Object)ref);
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        this.updateRef(this.findColumn(string), ref);
    }

    @Override
    public void updateRow() throws SQLException {
        if (!this.isOnUpdate) {
            throw TbError.newSQLException(-90824);
        }
        this.isOnUpdate = false;
        this.getCurrentRow().markUpdated(true);
        this.notifyRowChanged();
    }

    @Override
    public void updateRowId(int n, RowId rowId) throws SQLException {
        this.updateObject(n, (Object)rowId);
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        this.updateRowId(this.findColumn(string), rowId);
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
        this.updateObject(n, (Object)new Short(s));
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    @Override
    public void updateSQLXML(int n, SQLXML sQLXML) throws SQLException {
        this.updateObject(n, (Object)sQLXML);
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        this.updateSQLXML(this.findColumn(string), sQLXML);
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
        this.updateObject(n, (Object)string);
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    @Override
    public void updateTime(int n, Time time) throws SQLException {
        this.updateObject(n, (Object)time);
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.updateObject(n, (Object)timestamp);
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.prevColumnWasNull;
    }
}

