/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.ext;

import com.tmax.tibero.jdbc.TbBlob;
import com.tmax.tibero.jdbc.TbClob;
import com.tmax.tibero.jdbc.TbConnection;
import com.tmax.tibero.jdbc.TbNClob;
import com.tmax.tibero.jdbc.TbSQLInfo;
import com.tmax.tibero.jdbc.TbSQLInfo2;
import com.tmax.tibero.jdbc.data.ServerInfo;
import com.tmax.tibero.jdbc.dpl.TbDirPathMetaData;
import com.tmax.tibero.jdbc.dpl.TbDirPathStream;
import com.tmax.tibero.jdbc.driver.TbCallableStatement;
import com.tmax.tibero.jdbc.driver.TbPreparedStatement;
import com.tmax.tibero.jdbc.driver.TbResultSet;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.ext.TbConnectionEventHandler;
import com.tmax.tibero.jdbc.ext.TbLogicalCallableStatement;
import com.tmax.tibero.jdbc.ext.TbLogicalPreparedStatement;
import com.tmax.tibero.jdbc.ext.TbXAException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class TbLogicalConnection
extends TbConnection {
    private TbConnectionEventHandler eventHandler = null;
    private com.tmax.tibero.jdbc.driver.TbConnection physicalConn = null;
    private boolean closed = true;
    private boolean useXA = false;
    private boolean reseted = true;
    private HashMap<StatementEventListener, StatementEventListener> listenerMap = new HashMap();

    public TbLogicalConnection(TbConnectionEventHandler tbConnectionEventHandler, com.tmax.tibero.jdbc.driver.TbConnection tbConnection, boolean bl) throws SQLException {
        this.eventHandler = tbConnectionEventHandler;
        this.physicalConn = tbConnection;
        this.useXA = bl;
        if (tbConnection.isClosed()) {
            this.closed = true;
            throw TbError.newSQLException(-90643);
        }
        this.closed = false;
        if (!this.physicalConn.isSessionClosed()) {
            this.physicalConn.resetSession();
            this.physicalConn.reuse();
            this.eventHandler.notifyClosedEvent();
        }
        this.addStatementEventListener(new StatementEventListener(){

            @Override
            public void statementClosed(StatementEvent statementEvent) {
                try {
                    statementEvent.getStatement().close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }

            @Override
            public void statementErrorOccurred(StatementEvent statementEvent) {
            }
        });
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            this.physicalConn.clearWarnings();
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.closed = true;
        this.physicalConn.resetSession();
        this.physicalConn.reuse();
        this.eventHandler.notifyClosedEvent();
    }

    @Override
    public void commit() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        if (this.isUseXA() && this.getTxnMode() == 2) {
            throw TbError.newSQLException(-90602);
        }
        try {
            this.physicalConn.commit();
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        try {
            if (!this.isPhysConnClosed() && this.isUseXA() && this.physicalConn instanceof XAResource) {
                ((XAResource)((Object)this.physicalConn)).commit(xid, bl);
            }
        }
        catch (SQLException sQLException) {
            throw new TbXAException(sQLException.getMessage());
        }
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public Blob createBlob() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.createBlob();
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.createClob();
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.createNClob();
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.createSQLXML();
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.createStatement();
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.createStatement(n, n2);
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public void end(Xid xid, int n) throws XAException {
        try {
            if (!this.isPhysConnClosed() && this.isUseXA() && this.physicalConn instanceof XAResource) {
                ((XAResource)((Object)this.physicalConn)).end(xid, n);
            }
        }
        catch (SQLException sQLException) {
            throw new TbXAException(sQLException.getMessage());
        }
    }

    public void forget(Xid xid) throws TbXAException {
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.getAutoCommit();
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.getCatalog();
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.getClientInfo();
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.getClientInfo(string);
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public TbConnectionEventHandler getEventHandler() {
        return this.eventHandler;
    }

    @Override
    public int getHoldability() throws SQLException {
        return 1;
    }

    @Override
    public TbSQLInfo getLastExecutedSqlinfo() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.getLastExecutedSqlinfo();
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public TbSQLInfo2 getLastExecutedSqlinfo2() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.getLastExecutedSqlinfo2();
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.getMetaData();
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    com.tmax.tibero.jdbc.driver.TbConnection getPhysicalConnection() {
        return this.physicalConn;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.getTransactionIsolation();
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public int getTxnMode() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        return this.physicalConn.getTxnMode();
    }

    public Map getTypeMap() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.getTypeMap();
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.getWarnings();
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public boolean isPhysConnClosed() throws SQLException {
        return this.physicalConn.isClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.isReadOnly();
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public boolean isUseXA() {
        return this.useXA;
    }

    @Override
    public boolean isValid(int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.isValid(n);
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isInstance(this);
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.nativeSQL(string);
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public int prepare(Xid xid) throws XAException {
        try {
            if (!this.isPhysConnClosed() && this.isUseXA() && this.physicalConn instanceof XAResource) {
                return ((XAResource)((Object)this.physicalConn)).prepare(xid);
            }
        }
        catch (SQLException sQLException) {
            throw new TbXAException("prepare failed " + sQLException.getMessage());
        }
        throw new TbXAException("prepare failed");
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            TbLogicalCallableStatement tbLogicalCallableStatement;
            TbLogicalCallableStatement tbLogicalCallableStatement2 = null;
            TbCallableStatement tbCallableStatement = (TbCallableStatement)this.physicalConn.prepareCall(string);
            tbLogicalCallableStatement2 = tbLogicalCallableStatement = new TbLogicalCallableStatement(this, tbCallableStatement);
            return tbLogicalCallableStatement2;
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            TbLogicalCallableStatement tbLogicalCallableStatement;
            TbLogicalCallableStatement tbLogicalCallableStatement2 = null;
            TbCallableStatement tbCallableStatement = (TbCallableStatement)this.physicalConn.prepareCall(string, n, n2);
            tbLogicalCallableStatement2 = tbLogicalCallableStatement = new TbLogicalCallableStatement(this, tbCallableStatement);
            return tbLogicalCallableStatement2;
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            TbLogicalPreparedStatement tbLogicalPreparedStatement;
            TbLogicalPreparedStatement tbLogicalPreparedStatement2 = null;
            TbPreparedStatement tbPreparedStatement = (TbPreparedStatement)this.physicalConn.prepareStatement(string);
            tbLogicalPreparedStatement2 = tbLogicalPreparedStatement = new TbLogicalPreparedStatement(this, tbPreparedStatement);
            return tbLogicalPreparedStatement2;
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, boolean bl) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            TbLogicalPreparedStatement tbLogicalPreparedStatement;
            TbLogicalPreparedStatement tbLogicalPreparedStatement2 = null;
            TbPreparedStatement tbPreparedStatement = (TbPreparedStatement)this.physicalConn.prepareStatement(string, bl);
            tbLogicalPreparedStatement2 = tbLogicalPreparedStatement = new TbLogicalPreparedStatement(this, tbPreparedStatement);
            return tbLogicalPreparedStatement2;
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            TbLogicalPreparedStatement tbLogicalPreparedStatement;
            TbLogicalPreparedStatement tbLogicalPreparedStatement2 = null;
            TbPreparedStatement tbPreparedStatement = (TbPreparedStatement)this.physicalConn.prepareStatement(string, n);
            tbLogicalPreparedStatement2 = tbLogicalPreparedStatement = new TbLogicalPreparedStatement(this, tbPreparedStatement);
            return tbLogicalPreparedStatement2;
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            TbLogicalPreparedStatement tbLogicalPreparedStatement;
            TbLogicalPreparedStatement tbLogicalPreparedStatement2 = null;
            TbPreparedStatement tbPreparedStatement = (TbPreparedStatement)this.physicalConn.prepareStatement(string, n, n2);
            tbLogicalPreparedStatement2 = tbLogicalPreparedStatement = new TbLogicalPreparedStatement(this, tbPreparedStatement);
            return tbLogicalPreparedStatement2;
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            TbLogicalPreparedStatement tbLogicalPreparedStatement;
            TbLogicalPreparedStatement tbLogicalPreparedStatement2 = null;
            TbPreparedStatement tbPreparedStatement = (TbPreparedStatement)this.physicalConn.prepareStatement(string, nArray);
            tbLogicalPreparedStatement2 = tbLogicalPreparedStatement = new TbLogicalPreparedStatement(this, tbPreparedStatement);
            return tbLogicalPreparedStatement2;
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            TbLogicalPreparedStatement tbLogicalPreparedStatement;
            TbLogicalPreparedStatement tbLogicalPreparedStatement2 = null;
            TbPreparedStatement tbPreparedStatement = (TbPreparedStatement)this.physicalConn.prepareStatement(string, stringArray);
            tbLogicalPreparedStatement2 = tbLogicalPreparedStatement = new TbLogicalPreparedStatement(this, tbPreparedStatement);
            return tbLogicalPreparedStatement2;
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public Xid[] recover(int n) throws XAException {
        try {
            if (!this.isPhysConnClosed() && this.isUseXA() && this.physicalConn instanceof XAResource) {
                return ((XAResource)((Object)this.physicalConn)).recover(n);
            }
        }
        catch (SQLException sQLException) {
            throw new TbXAException("recover failed " + sQLException.getMessage());
        }
        throw new TbXAException("recover failed");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public void reset() {
        this.eventHandler = null;
        this.physicalConn = null;
    }

    @Override
    public void rollback() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        if (this.isUseXA() && this.getTxnMode() == 2) {
            throw TbError.newSQLException(-90602);
        }
        try {
            this.physicalConn.rollback();
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        if (this.isUseXA() && this.getTxnMode() == 2) {
            throw TbError.newSQLException(-90602);
        }
        try {
            this.physicalConn.rollback(savepoint);
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public void rollback(Xid xid) throws XAException {
        try {
            if (!this.isPhysConnClosed() && this.isUseXA() && this.physicalConn instanceof XAResource) {
                ((XAResource)((Object)this.physicalConn)).rollback(xid);
            }
        }
        catch (SQLException sQLException) {
            throw new TbXAException(sQLException.getMessage());
        }
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        if (this.isUseXA() && this.getTxnMode() == 2) {
            if (bl) {
                throw TbError.newSQLException(-90602);
            }
        } else {
            try {
                this.physicalConn.setAutoCommit(bl);
            }
            catch (SQLException sQLException) {
                this.eventHandler.notifyExceptionEvent(sQLException);
                throw sQLException;
            }
        }
    }

    @Override
    public void setCatalog(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            this.physicalConn.setCatalog(string);
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        if (this.isClosed()) {
            throw new SQLClientInfoException(TbError.getMsg(-90603), null, -90603, null);
        }
        try {
            this.physicalConn.setClientInfo(properties);
        }
        catch (SQLClientInfoException sQLClientInfoException) {
            this.eventHandler.notifyExceptionEvent(sQLClientInfoException);
            throw sQLClientInfoException;
        }
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        if (this.isClosed()) {
            throw new SQLClientInfoException(TbError.getMsg(-90603), null, -90603, null);
        }
        try {
            this.physicalConn.setClientInfo(string, string2);
        }
        catch (SQLClientInfoException sQLClientInfoException) {
            this.eventHandler.notifyExceptionEvent(sQLClientInfoException);
            throw sQLClientInfoException;
        }
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            this.physicalConn.setReadOnly(bl);
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        if (this.isUseXA() && this.getTxnMode() == 2) {
            throw TbError.newSQLException(-90602);
        }
        return this.physicalConn.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        if (this.isUseXA() && this.getTxnMode() == 2) {
            throw TbError.newSQLException(-90602);
        }
        return this.physicalConn.setSavepoint(string);
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            this.physicalConn.setTransactionIsolation(n);
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public void setTxnMode(int n) {
        this.physicalConn.setTxnMode(n);
    }

    public void setTypeMap(Map map) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            this.physicalConn.setTypeMap(map);
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public void start(Xid xid, int n) throws XAException {
        try {
            if (!this.isPhysConnClosed() && this.isUseXA() && this.physicalConn instanceof XAResource) {
                ((XAResource)((Object)this.physicalConn)).start(xid, n);
            }
        }
        catch (SQLException sQLException) {
            throw new TbXAException(sQLException.getMessage());
        }
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            return clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            throw TbError.newSQLException(-90657);
        }
    }

    public void addStatementEventListener(StatementEventListener statementEventListener) {
        if (this.physicalConn.isPooledConnection()) {
            this.listenerMap.put(statementEventListener, statementEventListener);
        }
    }

    public void removeaStatementEventListener(StatementEventListener statementEventListener) {
        if (this.physicalConn.isPooledConnection()) {
            this.listenerMap.remove(statementEventListener);
        }
    }

    public HashMap<StatementEventListener, StatementEventListener> getStatementEventListeners() {
        return this.listenerMap;
    }

    @Override
    public void addWarning(SQLWarning sQLWarning) {
        this.physicalConn.addWarning(sQLWarning);
    }

    @Override
    public void closeCursor(TbResultSet tbResultSet, int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        this.physicalConn.closeCursor(tbResultSet, n);
    }

    @Override
    public TbBlob createTbBlob() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        return this.physicalConn.createTbBlob();
    }

    @Override
    public TbClob createTbClob() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        return this.physicalConn.createTbClob();
    }

    @Override
    public TbDirPathStream createDirPathStream(TbDirPathMetaData tbDirPathMetaData) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public TbNClob createTbNClob() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        return this.physicalConn.createTbNClob();
    }

    @Override
    public String getNlsDate() {
        return this.physicalConn.getNlsDate();
    }

    @Override
    public String getNlsTimestamp() {
        return this.physicalConn.getNlsTimestamp();
    }

    @Override
    public int getSerialNo() {
        return this.physicalConn.getSerialNo();
    }

    @Override
    public int getServerCharSet() {
        return this.physicalConn.getServerCharSet();
    }

    @Override
    public ServerInfo getServerInfo() {
        return this.physicalConn.getServerInfo();
    }

    @Override
    public int getServerNCharSet() {
        return this.physicalConn.getServerNCharSet();
    }

    @Override
    public int getSessionId() {
        return this.physicalConn.getSessionId();
    }

    @Override
    public boolean isPooledConnection() {
        return false;
    }

    @Override
    public boolean isSessionClosed() {
        return this.physicalConn.isSessionClosed();
    }

    @Override
    public void resetSession() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        this.physicalConn.resetSession();
    }
}

