/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.ext;

import com.tmax.tibero.jdbc.TbCallableStatement;
import com.tmax.tibero.jdbc.TbResultSet;
import com.tmax.tibero.jdbc.data.BindItem;
import com.tmax.tibero.jdbc.data.ParamContainer;
import com.tmax.tibero.jdbc.data.TbDate;
import com.tmax.tibero.jdbc.data.TbTimestamp;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.ext.TbLogicalConnection;
import com.tmax.tibero.jdbc.ext.TbStatementEventHandler;
import com.tmax.tibero.jdbc.msg.TbPivotInfo;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.sql.PooledConnection;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;

public class TbLogicalCallableStatement
extends TbCallableStatement
implements TbStatementEventHandler {
    private TbLogicalConnection logicalConn = null;
    private boolean closed = true;
    protected com.tmax.tibero.jdbc.driver.TbCallableStatement physicalStmt = null;
    protected HashMap<StatementEventListener, StatementEventListener> stmtEventMap = null;

    public TbLogicalCallableStatement(TbLogicalConnection tbLogicalConnection, com.tmax.tibero.jdbc.driver.TbCallableStatement tbCallableStatement) throws SQLException {
        this.logicalConn = tbLogicalConnection;
        this.stmtEventMap = this.logicalConn.getStatementEventListeners();
        this.physicalStmt = tbCallableStatement;
        if (tbCallableStatement.isClosed()) {
            this.closed = true;
            throw TbError.newSQLException(-90658);
        }
        this.closed = false;
    }

    @Override
    public void addBatch() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.addBatch();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void addBatch(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.addBatch(string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void addPivotData(byte[] byArray) {
        if (this.physicalStmt != null) {
            this.physicalStmt.addPivotData(byArray);
        }
    }

    @Override
    public void cancel() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.cancel();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        this.physicalStmt.clearBatch();
    }

    @Override
    public void clearParameters() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.clearParameters();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.clearWarnings();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.closed = true;
        this.physicalStmt.resetForCache();
        this.notifyClosedEvent();
    }

    @Override
    public void closeInternal() throws SQLException {
        if (this.physicalStmt != null) {
            this.physicalStmt.closeInternal();
        }
    }

    @Override
    public boolean execute() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.execute();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public boolean execute(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.execute(string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public boolean execute(String string, int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.execute(string, n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.execute(string, nArray);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.execute(string, stringArray);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.executeBatch();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.executeQuery();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.executeQuery(string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.executeUpdate();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.executeUpdate(string, n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.executeUpdate(string, nArray);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.executeUpdate(string, stringArray);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public Array getArray(int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getArray(n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public Array getArray(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getArray(string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getBigDecimal(n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getBigDecimal(n, n2);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getBigDecimal(string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getBlob(n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getBlob(string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getBoolean(n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getBoolean(string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public byte getByte(int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getByte(n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public byte getByte(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getByte(string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getBytes(n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getBytes(string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getCharacterStream(n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getCharacterStream(string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getClob(n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getClob(string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        return this.logicalConn;
    }

    @Override
    public Date getDate(int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getDate(n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getDate(n, calendar);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public Date getDate(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getDate(string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getDate(string, calendar);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public double getDouble(int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getDouble(n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public double getDouble(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getDouble(string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getFetchDirection();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getFetchDirection();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public float getFloat(int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getFloat(n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public float getFloat(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getFloat(string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getGeneratedKeys();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public int getInt(int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getInt(n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public int getInt(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getInt(string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public long getLong(int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getLong(n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public long getLong(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getLong(string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getMaxFieldSize();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getMaxRows();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getMetaData();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getMoreResults();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public boolean getMoreResults(int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getMoreResults();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getNCharacterStream(n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getNCharacterStream(string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getNClob(n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getNClob(string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public String getNString(int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getNString(n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public String getNString(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getNString(string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public Object getObject(int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getObject(n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public Object getObject(int n, Map<String, Class<?>> map) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getObject(n, map);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public Object getObject(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getObject(string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getObject(string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public String getOriginalSql() {
        if (this.physicalStmt != null) {
            return this.physicalStmt.getOriginalSql();
        }
        return null;
    }

    @Override
    public BindItem getOutItems(int n) {
        if (this.physicalStmt != null) {
            return this.physicalStmt.getOutItems(n);
        }
        return null;
    }

    @Override
    public ParamContainer getParamContainer() {
        if (this.physicalStmt != null) {
            return this.physicalStmt.getParamContainer();
        }
        return null;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getParameterMetaData();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public Vector<byte[]> getPivotData() {
        if (this.physicalStmt != null) {
            return this.physicalStmt.getPivotData();
        }
        return null;
    }

    @Override
    public Vector<byte[]> getPivotData(int n) throws SQLException {
        if (this.physicalStmt != null) {
            return this.physicalStmt.getPivotData(n);
        }
        return null;
    }

    @Override
    public TbPivotInfo[] getPivotInfo() {
        if (this.physicalStmt != null) {
            return this.physicalStmt.getPivotInfo();
        }
        return null;
    }

    @Override
    public TbPivotInfo[] getPivotInfo(int n) throws SQLException {
        if (this.physicalStmt != null) {
            return this.physicalStmt.getPivotInfo(n);
        }
        return null;
    }

    @Override
    public byte[] getPPID() {
        if (this.physicalStmt != null) {
            return this.physicalStmt.getPPID();
        }
        return null;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getQueryTimeout();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getRef(n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getRef(string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getResultSet();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        return this.physicalStmt.getResultSetConcurrency();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getResultSetHoldability();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getResultSetType();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getRowId(n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getRowId(string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public short getShort(int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getShort(n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public short getShort(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getShort(string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public int getSqlType() {
        if (this.physicalStmt != null) {
            return this.physicalStmt.getSqlType();
        }
        return 0;
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getSQLXML(n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getSQLXML(string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public String getString(int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getString(n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public String getString(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getString(string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public Struct getStruct(int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getStruct(n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public TbDate getTbDate(int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getTbDate(n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public TbDate getTbDate(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getTbDate(string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public TbTimestamp getTbTimestamp(int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getTbTimestamp(n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public TbTimestamp getTbTimestamp(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getTbTimestamp(string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public Time getTime(int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getTime(n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getTime(n, calendar);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public Time getTime(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getTime(string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getTime(string, calendar);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getTimestamp(n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getTimestamp(n, calendar);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getTimestamp(string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getTimestamp(string, calendar);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getUpdateCount();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public URL getURL(int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getURL(n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public URL getURL(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getURL(string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getWarnings();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.isPoolable();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isInstance(this);
    }

    @Override
    public void notifyClosedEvent() {
        if (this.physicalStmt != null && this.stmtEventMap != null) {
            Iterator<StatementEventListener> iterator = this.stmtEventMap.keySet().iterator();
            while (iterator.hasNext()) {
                StatementEventListener statementEventListener = this.stmtEventMap.get(iterator.next());
                statementEventListener.statementClosed(new StatementEvent((PooledConnection)((Object)this.logicalConn.getEventHandler()), this));
            }
        }
    }

    @Override
    public void notifyExceptionEvent(PreparedStatement preparedStatement, Exception exception) {
        if (this.physicalStmt != null && this.stmtEventMap != null) {
            Iterator<StatementEventListener> iterator = this.stmtEventMap.keySet().iterator();
            while (iterator.hasNext()) {
                StatementEventListener statementEventListener = this.stmtEventMap.get(iterator.next());
                statementEventListener.statementErrorOccurred(new StatementEvent((PooledConnection)((Object)this.logicalConn.getEventHandler()), this, (SQLException)exception));
            }
        }
    }

    @Override
    public void registerOutParameter(int n, int n2) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.registerOutParameter(n, n2);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.registerOutParameter(n, n2, n3);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.registerOutParameter(n, n2, string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void registerOutParameter(String string, int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.registerOutParameter(string, n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void registerOutParameter(String string, int n, int n2) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.registerOutParameter(string, n, n2);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void registerOutParameter(String string, int n, String string2) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.registerOutParameter(string, n, string2);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void resetForCache() {
        if (this.physicalStmt != null) {
            this.physicalStmt.resetForCache();
        }
    }

    @Override
    public void setArray(int n, Array array) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setArray(n, array);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setAsciiStream(n, inputStream);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setAsciiStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setAsciiStream(n, inputStream, l);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setAsciiStream(string, inputStream);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setAsciiStream(string, inputStream, n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setAsciiStream(string, inputStream, l);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBigDecimal(n, bigDecimal);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBigDecimal(string, bigDecimal);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setBinaryDouble(int n, double d) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBinaryDouble(n, d);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setBinaryFloat(int n, float f) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBinaryFloat(n, f);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBinaryStream(n, inputStream);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBinaryStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBinaryStream(n, inputStream, l);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBinaryStream(string, inputStream);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBinaryStream(string, inputStream, n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBinaryStream(string, inputStream, l);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setBlob(int n, Blob blob) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBlob(n, blob);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setBlob(int n, InputStream inputStream) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBlob(n, inputStream);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBlob(n, inputStream, l);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setBlob(String string, Blob blob) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBlob(string, blob);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setBlob(String string, InputStream inputStream) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBlob(string, inputStream);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setBlob(String string, InputStream inputStream, long l) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBlob(string, inputStream, l);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setBoolean(int n, boolean bl) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBoolean(n, bl);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setBoolean(String string, boolean bl) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBoolean(string, bl);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setByte(int n, byte by) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setByte(n, by);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setByte(String string, byte by) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setByte(string, by);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setBytes(int n, byte[] byArray) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBytes(n, byArray);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setBytes(int n, int n2, byte[] byArray) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBytes(n, n2, byArray);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setBytes(String string, byte[] byArray) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBytes(string, byArray);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setCharacterStream(int n, Reader reader) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setCharacterStream(n, reader);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setCharacterStream(n, reader, n2);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setCharacterStream(n, reader, l);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setCharacterStream(String string, Reader reader) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setCharacterStream(string, reader);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setCharacterStream(string, reader, n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setCharacterStream(String string, Reader reader, long l) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setCharacterStream(string, reader, l);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setClob(int n, Clob clob) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setClob(n, clob);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setClob(int n, Reader reader) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setClob(n, reader);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setClob(int n, Reader reader, long l) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setClob(n, reader, l);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setClob(String string, Clob clob) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setClob(string, clob);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setClob(String string, Reader reader) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setClob(string, reader);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setClob(String string, Reader reader, long l) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setClob(string, reader, l);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setCursorName(string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setDate(int n, Date date) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setDate(n, date);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setDate(n, date, calendar);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setDate(String string, Date date) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setDate(string, date);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setDate(string, date, calendar);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setDouble(int n, double d) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setDouble(n, d);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setDouble(String string, double d) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setDouble(string, d);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setEscapeProcessing(bl);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setFetchDirection(n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setFetchSize(n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setFixedCHAR(int n, String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setFixedCHAR(n, string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setFloat(int n, float f) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setFloat(n, f);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setFloat(String string, float f) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setFloat(string, f);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setInt(int n, int n2) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setInt(n, n2);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setInt(String string, int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setInt(string, n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setLong(int n, long l) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setLong(n, l);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setLong(String string, long l) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setLong(string, l);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setMaxFieldSize(int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setMaxFieldSize(n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setMaxRows(int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setMaxRows(n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNCharacterStream(n, reader);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNCharacterStream(n, reader, l);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setNCharacterStream(String string, Reader reader) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNCharacterStream(string, reader);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setNCharacterStream(String string, Reader reader, long l) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNCharacterStream(string, reader, l);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setNClob(int n, Clob clob) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNClob(n, clob);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setNClob(int n, NClob nClob) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNClob(n, nClob);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setNClob(int n, Reader reader) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNClob(n, reader);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setNClob(int n, Reader reader, long l) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNClob(n, reader, l);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setNClob(String string, NClob nClob) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNClob(string, nClob);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setNClob(String string, Reader reader) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNClob(string, reader);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setNClob(String string, Reader reader, long l) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNClob(string, reader, l);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setNString(int n, String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNString(n, string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setNString(String string, String string2) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNString(string, string2);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setNull(int n, int n2) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNull(n, n2);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setNull(int n, int n2, String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNull(n, n2, string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setNull(String string, int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNull(string, n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setNull(String string, int n, String string2) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNull(string, n, string2);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setObject(int n, Object object) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setObject(n, object);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setObject(int n, Object object, int n2) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setObject(n, object, n2);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setObject(n, object, n2, n3);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setObject(String string, Object object) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setObject(string, object);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setObject(String string, Object object, int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setObject(string, object, n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setObject(string, object, n, n2);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setOutParam(int n, int n2, byte[] byArray, TbResultSet tbResultSet) throws SQLException {
        if (this.physicalStmt != null) {
            this.physicalStmt.setOutParam(n, n2, byArray, tbResultSet);
        }
    }

    @Override
    public void setPivotInfo(TbPivotInfo[] tbPivotInfoArray) {
        if (this.physicalStmt != null) {
            this.physicalStmt.setPivotInfo(tbPivotInfoArray);
        }
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setPoolable(bl);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setQueryTimeout(int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setQueryTimeout(n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setRef(int n, Ref ref) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setRef(n, ref);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setRowId(int n, RowId rowId) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setRowId(n, rowId);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setRowId(String string, RowId rowId) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setRowId(string, rowId);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setShort(int n, short s) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setShort(n, s);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setShort(String string, short s) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setShort(string, s);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setSQLXML(n, sQLXML);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setSQLXML(String string, SQLXML sQLXML) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setSQLXML(string, sQLXML);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setString(int n, String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setString(n, string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setString(String string, String string2) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setString(string, string2);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setTbDate(int n, TbDate tbDate) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setTbDate(n, tbDate);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setTbDate(String string, TbDate tbDate) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setTbDate(string, tbDate);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setTbTimestamp(int n, TbTimestamp tbTimestamp) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setTbTimestamp(n, tbTimestamp);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setTbTimestamp(String string, TbTimestamp tbTimestamp) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setTbTimestamp(string, tbTimestamp);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setTime(int n, Time time) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setTime(n, time);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setTime(n, time, calendar);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setTime(String string, Time time) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setTime(string, time);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setTime(string, time, calendar);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setTimestamp(n, timestamp);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setTimestamp(n, timestamp, calendar);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setTimestamp(string, timestamp);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setTimestamp(string, timestamp, calendar);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setUnicodeStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    @Deprecated
    public void setUnicodeStream(String string, InputStream inputStream, int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setUnicodeStream(string, inputStream, n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setURL(int n, URL uRL) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setURL(n, uRL);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setURL(String string, URL uRL) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setURL(string, uRL);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            return clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            throw TbError.newSQLException(-90657);
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.wasNull();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }
}

