/*
 * Decompiled with CFR 0.152.
 */
package nl.captcha.audio;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import nl.captcha.audio.Mixer;
import nl.captcha.audio.Sample;
import nl.captcha.audio.noise.NoiseProducer;
import nl.captcha.audio.noise.RandomNoiseProducer;
import nl.captcha.audio.producer.RandomNumberVoiceProducer;
import nl.captcha.audio.producer.VoiceProducer;
import nl.captcha.text.producer.NumbersAnswerProducer;
import nl.captcha.text.producer.TextProducer;

public final class AudioCaptcha {
    public static final String NAME = "audioCaptcha";
    private static final Random RAND = new SecureRandom();
    private Builder _builder;

    private AudioCaptcha(Builder builder) {
        this._builder = builder;
    }

    public boolean isCorrect(String answer) {
        return answer.equals(this._builder._answer);
    }

    public String getAnswer() {
        return this._builder._answer;
    }

    public Sample getChallenge() {
        return this._builder._challenge;
    }

    public String toString() {
        return this._builder.toString();
    }

    /* synthetic */ AudioCaptcha(Builder builder, AudioCaptcha audioCaptcha) {
        this(builder);
    }

    public static class Builder {
        private String _answer = "";
        private Sample _challenge;
        private List<VoiceProducer> _voiceProds = new ArrayList<VoiceProducer>();
        private List<NoiseProducer> _noiseProds = new ArrayList<NoiseProducer>();

        public Builder addAnswer() {
            return this.addAnswer(new NumbersAnswerProducer());
        }

        public Builder addAnswer(TextProducer ansProd) {
            this._answer = String.valueOf(this._answer) + ansProd.getText();
            return this;
        }

        public Builder addVoice() {
            this._voiceProds.add(new RandomNumberVoiceProducer());
            return this;
        }

        public Builder addVoice(VoiceProducer vProd) {
            this._voiceProds.add(vProd);
            return this;
        }

        public Builder addNoise() {
            return this.addNoise(new RandomNoiseProducer());
        }

        public Builder addNoise(NoiseProducer noiseProd) {
            this._noiseProds.add(noiseProd);
            return this;
        }

        public AudioCaptcha build() {
            if (this._voiceProds.size() == 0) {
                this.addVoice();
            }
            char[] ansAry = this._answer.toCharArray();
            ArrayList<Sample> samples = new ArrayList<Sample>();
            int i = 0;
            while (i < ansAry.length) {
                VoiceProducer vProd = this._voiceProds.get(RAND.nextInt(this._voiceProds.size()));
                Sample sample = vProd.getVocalization(ansAry[i]);
                samples.add(sample);
                ++i;
            }
            if (this._noiseProds.size() > 0) {
                NoiseProducer nProd = this._noiseProds.get(RAND.nextInt(this._noiseProds.size()));
                this._challenge = nProd.addNoise(samples);
                return new AudioCaptcha(this, null);
            }
            this._challenge = Mixer.append(samples);
            return new AudioCaptcha(this, null);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("[Answer: ");
            sb.append(this._answer);
            sb.append("]");
            return sb.toString();
        }
    }
}

