/*
 * Decompiled with CFR 0.152.
 */
package com.sci.v2.ipinv2.secu;

import com.sci.v2.ipinv2.secu.SciUtil;
import com.sci.v2.ipinv2.secu.aes.SciHttpSecuX;
import com.sci.v2.ipinv2.secu.aes.SciPacketConversion;
import com.sci.v2.ipinv2.secu.hmac.SciHmac;
import com.sci.v2.ipinv2.secu.seed.manager.SeedManager;

public class SciSecuManager {
    String svrName = "CBA";
    String progName = "SciSecuManager";
    private String userId = "";
    private String keySeq = "0001";
    private String encSecuKey = "";
    public String reqNum = "";
    public String discrHash = "";
    public String vDiscrNo = "";
    public String name = "";
    public String result = "";
    public String age = "";
    public String sex = "";
    public String ip = "";
    public String cba = "";
    public String birth = "";
    public String fgn = "";
    public String auhInfo = "";

    public String getKeyInfo() {
        return String.valueOf(this.userId) + "^" + this.keySeq + "^" + this.encSecuKey;
    }

    public String getSecuKey() {
        String methodName = "getSecuKey";
        String step = "00";
        String errInfo = "";
        String secuKey = "";
        SciPacketConversion aes = new SciPacketConversion();
        try {
            StringBuffer decStr = new StringBuffer("");
            decStr = SciPacketConversion.RecvWritePacket(this.encSecuKey);
            secuKey = decStr.toString();
        }
        catch (Exception e) {
            SciUtil.javaLog(this.svrName, "ERR", this.progName, methodName, step, "Exception", e.getMessage(), errInfo);
            return "";
        }
        return secuKey;
    }

    public String getSecuKeyPublic() {
        String methodName = "getSecuKeyPublic";
        String step = "00";
        String errInfo = "";
        String secuKey = "";
        SciHttpSecuX aes = new SciHttpSecuX();
        try {
            secuKey = SciHttpSecuX.getInitStr();
        }
        catch (Exception e) {
            SciUtil.javaLog(this.svrName, "ERR", this.progName, methodName, step, "Exception", e.getMessage(), errInfo);
            return "";
        }
        return secuKey;
    }

    public String getEncPublic(String str) {
        String methodName = "getEnc";
        String step = "00";
        String errInfo = "";
        String secuKey = this.getSecuKey();
        String result = "";
        try {
            result = this.getEnc(str, "SEED", secuKey);
        }
        catch (Exception e) {
            SciUtil.javaLog(this.svrName, "ERR", this.progName, methodName, step, "Exception", e.getMessage(), errInfo);
            return "";
        }
        return result;
    }

    public String setEncPublic(String userid, String pwd) {
        String methodName = "setEncPublic";
        String step = "00";
        String errInfo = "";
        String secuKey = this.getSecuKeyPublic();
        String result = "";
        try {
            this.userId = userid;
            result = this.getEnc(pwd, "AES", secuKey);
            this.encSecuKey = result.substring(0, 32);
        }
        catch (Exception e) {
            SciUtil.javaLog(this.svrName, "ERR", this.progName, methodName, step, "Exception", e.getMessage(), errInfo);
            return "";
        }
        return result;
    }

    public String EncPublic(String str) {
        String methodName = "EncPublic";
        String step = "00";
        String errInfo = "";
        String secuKey = this.getSecuKeyPublic();
        String result = "";
        try {
            result = this.getEnc(str, "SEED", secuKey);
        }
        catch (Exception e) {
            SciUtil.javaLog(this.svrName, "ERR", this.progName, methodName, step, "Exception", e.getMessage(), errInfo);
            return "";
        }
        return result;
    }

    public String setInfoPublic(String userid, String secuKey) {
        String methodName = "setInfoPublic";
        String step = "00";
        String errInfo = "";
        String result = "";
        try {
            this.userId = userid;
            this.encSecuKey = secuKey;
        }
        catch (Exception e) {
            SciUtil.javaLog(this.svrName, "ERR", this.progName, methodName, step, "Exception", e.getMessage(), errInfo);
            return "";
        }
        return result;
    }

    private String getSecuIV(String reqNum) {
        String methodName = "getSecuIV";
        String step = "00";
        String errInfo = "";
        String seedIV = "";
        try {
            if (reqNum != null) {
                int reqLength = reqNum.length();
                if (reqLength > 16) {
                    seedIV = reqNum.substring(reqLength - 16, reqLength);
                } else {
                    seedIV = reqNum;
                    int i = reqLength;
                    while (i < 16) {
                        seedIV = String.valueOf(seedIV) + "0";
                        ++i;
                    }
                }
            }
        }
        catch (Exception e) {
            SciUtil.javaLog(this.svrName, "ERR", this.progName, methodName, step, "Exception", e.getMessage(), errInfo);
            return "";
        }
        return seedIV;
    }

    public String getMsg(String str) {
        String methodName = "getMsg";
        String step = "00";
        String errInfo = "";
        String secuKey = this.getSecuKey();
        String result = "";
        try {
            result = this.getEnc(str, "HMAC", secuKey);
        }
        catch (Exception e) {
            SciUtil.javaLog(this.svrName, "ERR", this.progName, methodName, step, "Exception", e.getMessage(), errInfo);
            return "";
        }
        return result;
    }

    public String getMsgClient(String str) {
        String methodName = "getMsg";
        String step = "00";
        String errInfo = "";
        String secuKey = this.encSecuKey;
        String result = "";
        try {
            result = this.getEnc(str, "HMAC", secuKey);
        }
        catch (Exception e) {
            SciUtil.javaLog(this.svrName, "ERR", this.progName, methodName, step, "Exception", e.getMessage(), errInfo);
            return "";
        }
        return result;
    }

    public String getEnc(String str, String gb, String secuKey) {
        String result;
        block6: {
            String methodName = "getEnc";
            String step = "00";
            String errInfo = "";
            result = "";
            SciPacketConversion aes = new SciPacketConversion();
            SciHmac hmac = new SciHmac();
            SeedManager seed = new SeedManager();
            try {
                if (str.length() > 0) {
                    if (gb.equals("AES")) {
                        StringBuffer encStr = new StringBuffer("");
                        encStr = SciPacketConversion.SendWritePacket(str, secuKey);
                        result = encStr.toString();
                        break block6;
                    }
                    if (gb.equals("HMAC")) {
                        result = SciHmac.HMacEncript(str, secuKey);
                        break block6;
                    }
                    if (gb.equals("SEED")) {
                        result = seed.getEncryptSeed(str, secuKey);
                        break block6;
                    }
                    SciUtil.javaLog(this.svrName, "ERR", this.progName, methodName, step, "", "Enc gubun is Null", errInfo);
                    return "";
                }
                return "";
            }
            catch (Exception e) {
                SciUtil.javaLog(this.svrName, "ERR", this.progName, methodName, step, "Exception", e.getMessage(), errInfo);
                return "";
            }
        }
        return result;
    }

    public String getEnc(String str, String gb, String secuKey, String secuIV) {
        String result;
        block6: {
            String methodName = "getEnc";
            String step = "00";
            String errInfo = "";
            result = "";
            SciPacketConversion aes = new SciPacketConversion();
            SciHmac hmac = new SciHmac();
            SeedManager seed = new SeedManager();
            try {
                if (str.length() > 0) {
                    if (gb.equals("AES")) {
                        StringBuffer encStr = new StringBuffer("");
                        encStr = SciPacketConversion.SendWritePacket(str, secuKey);
                        result = encStr.toString();
                        break block6;
                    }
                    if (gb.equals("HMAC")) {
                        result = SciHmac.HMacEncript(str, secuKey);
                        break block6;
                    }
                    if (gb.equals("SEED")) {
                        secuIV = this.getSecuIV(secuIV);
                        result = seed.getEncryptSeed(str, secuKey, secuIV);
                        break block6;
                    }
                    SciUtil.javaLog(this.svrName, "ERR", this.progName, methodName, step, "", "Enc gubun is Null", errInfo);
                    return "";
                }
                return "";
            }
            catch (Exception e) {
                SciUtil.javaLog(this.svrName, "ERR", this.progName, methodName, step, "Exception", e.getMessage(), errInfo);
                return "";
            }
        }
        return result;
    }

    public String getEncReq(String str, String gb) {
        String result;
        block6: {
            String methodName = "getEncReq";
            String step = "00";
            String errInfo = "";
            String secuKey = this.getSecuKey();
            result = "";
            SciPacketConversion aes = new SciPacketConversion();
            SciHmac hmac = new SciHmac();
            SeedManager seed = new SeedManager();
            try {
                if (str.length() > 0) {
                    if (gb.equals("AES")) {
                        StringBuffer encStr = new StringBuffer("");
                        encStr = SciPacketConversion.SendWritePacket(str, secuKey);
                        result = encStr.toString();
                        break block6;
                    }
                    if (gb.equals("HMAC")) {
                        result = SciHmac.HMacEncript(str, secuKey);
                        break block6;
                    }
                    if (gb.equals("SEED")) {
                        result = seed.getEncryptSeed(str, secuKey);
                        break block6;
                    }
                    SciUtil.javaLog(this.svrName, "ERR", this.progName, methodName, step, "", "Enc gubun is Null", errInfo);
                    return "";
                }
                return "";
            }
            catch (Exception e) {
                SciUtil.javaLog(this.svrName, "ERR", this.progName, methodName, step, "Exception", e.getMessage(), errInfo);
                return "";
            }
        }
        return result;
    }

    public String getDec(String str, String reqNum) {
        String methodName = "getDec";
        String step = "00";
        String errInfo = "";
        String secuKey = this.getSecuKey();
        String result = "";
        try {
            if (reqNum == null || reqNum.equals("")) {
                result = this.getDec(str, "SEED", secuKey);
            } else {
                String secuIV = this.getSecuIV(reqNum);
                result = this.getDec(str, "SEED", secuKey, secuIV);
            }
        }
        catch (Exception e) {
            SciUtil.javaLog(this.svrName, "ERR", this.progName, methodName, step, "Exception", e.getMessage(), errInfo);
            return "";
        }
        return result;
    }

    public String getDecPublic(String str, String enckey) {
        String result;
        block3: {
            String methodName = "getDec";
            String step = "00";
            String errInfo = "";
            String secuKey = enckey;
            result = "";
            try {
                if (str != null || !str.equals("")) {
                    result = this.getDec(str, "SEED", secuKey);
                    break block3;
                }
                SciUtil.javaLog(this.svrName, "ERR", this.progName, methodName, step, "", "Dec gubun is Null", errInfo);
                return "";
            }
            catch (Exception e) {
                SciUtil.javaLog(this.svrName, "ERR", this.progName, methodName, step, "Exception", e.getMessage(), errInfo);
                return "";
            }
        }
        return result;
    }

    public boolean isMsgChk(String encStr, String msg) {
        String methodName = "isMsgChk";
        String step = "00";
        String errInfo = "";
        String secuKey = this.getSecuKey();
        String decStr = "";
        String decStrMsg = "";
        boolean result = false;
        try {
            decStr = this.getDec(encStr, "AES", secuKey);
            decStrMsg = this.getEnc(decStr, "HMAC", secuKey);
            if (decStrMsg.equals(msg)) {
                result = true;
            }
        }
        catch (Exception e) {
            SciUtil.javaLog(this.svrName, "ERR", this.progName, methodName, step, "Exception", e.getMessage(), errInfo);
            return result;
        }
        return result;
    }

    public boolean isMsgChk(String encStr, String msg, String reqNum) {
        String methodName = "isMsgChk";
        String step = "00";
        String errInfo = "";
        String secuKey = this.getSecuKey();
        String decStr = "";
        String decStrMsg = "";
        boolean result = false;
        try {
            decStr = this.getDec(encStr, "AES", String.valueOf(secuKey) + reqNum);
            decStrMsg = this.getEnc(decStr, "HMAC", String.valueOf(secuKey) + reqNum);
            if (decStrMsg.equals(msg)) {
                result = true;
            }
        }
        catch (Exception e) {
            SciUtil.javaLog(this.svrName, "ERR", this.progName, methodName, step, "Exception", e.getMessage(), errInfo);
            return result;
        }
        return result;
    }

    public String getDec(String str, String gb, String secuKey) {
        String result;
        block5: {
            String methodName = "getDec";
            String step = "00";
            String errInfo = "";
            result = "";
            SciPacketConversion aes = new SciPacketConversion();
            SeedManager seed = new SeedManager();
            try {
                if (str.length() > 0) {
                    if (gb.equals("AES")) {
                        StringBuffer decStr = new StringBuffer("");
                        decStr = SciPacketConversion.RecvWritePacket(str, secuKey);
                        result = decStr.toString();
                        break block5;
                    }
                    if (gb.equals("SEED")) {
                        result = seed.getDecryptSeed(str, secuKey);
                        break block5;
                    }
                    SciUtil.javaLog(this.svrName, "ERR", this.progName, methodName, step, "", "Enc gubun is Null", errInfo);
                    return "";
                }
                return "";
            }
            catch (Exception e) {
                SciUtil.javaLog(this.svrName, "ERR", this.progName, methodName, step, "Exception", e.getMessage(), errInfo);
                return "";
            }
        }
        return result;
    }

    public String getDec(String str, String gb, String secuKey, String secuIV) {
        String result;
        block5: {
            String methodName = "getDec";
            String step = "00";
            String errInfo = "";
            result = "";
            SciPacketConversion aes = new SciPacketConversion();
            SeedManager seed = new SeedManager();
            try {
                if (str.length() > 0) {
                    if (gb.equals("AES")) {
                        StringBuffer decStr = new StringBuffer("");
                        decStr = SciPacketConversion.RecvWritePacket(str, secuKey);
                        result = decStr.toString();
                        break block5;
                    }
                    if (gb.equals("SEED")) {
                        secuIV = this.getSecuIV(secuIV);
                        result = seed.getDecryptSeed(str, secuKey, secuIV);
                        break block5;
                    }
                    SciUtil.javaLog(this.svrName, "ERR", this.progName, methodName, step, "", "Enc gubun is Null", errInfo);
                    return "";
                }
                return "";
            }
            catch (Exception e) {
                SciUtil.javaLog(this.svrName, "ERR", this.progName, methodName, step, "Exception", e.getMessage(), errInfo);
                return "";
            }
        }
        return result;
    }

    public String getEncSecuKey() {
        return this.encSecuKey;
    }
}

