/*
 * Decompiled with CFR 0.152.
 */
package com.ubintis.agt5.module.key;

import com.ubintis.agt5.api.ApiLogService;
import com.ubintis.agt5.common.util.ConnectUtil;
import com.ubintis.agt5.common.util.JsonUtil;
import com.ubintis.agt5.common.util.StrUtil;
import com.ubintis.agt5.framework.bean.AgentBean;
import com.ubintis.agt5.framework.config.AgentConfig;
import com.ubintis.agt5.framework.log.PniLogger;
import com.ubintis.agt5.module.cs.CipherBlock;
import com.ubintis.agt5.module.cs.Digest;
import com.ubintis.agt5.module.cs.key.KeyGenerator;
import com.ubintis.agt5.module.cs.key.KeyStorage;
import com.ubintis.agt5.module.cs.key.type.ECCKey;
import com.ubintis.agt5.module.cs.key.type.SecretKey;
import com.ubintis.crypto.RSA;
import java.util.HashMap;

public class KeyExchange {
    private static final PniLogger LOGGER = PniLogger.getLogger();
    private boolean flag = false;
    private String errorCode = "";

    public boolean getStatus() {
        return this.flag;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void execute() {
        this.flag = false;
        AgentBean agentBean = AgentConfig.getInstance().getAgentBean();
        if (agentBean != null) {
            String agt_id = agentBean.getAgent_id();
            String agent_encoding = StrUtil.NVL(agentBean.getEncoding(), "UTF-8");
            String server_pubkey = StrUtil.NVL(agentBean.getServer_public_key());
            KeyStorage keyStorage = KeyStorage.getInstance();
            byte[] bSecky = (byte[])keyStorage.getKey("com.ubintis.sso.agt.cs.key.SecretKey");
            if (!"".equals(server_pubkey) && bSecky != null && bSecky.length == 32) {
                KeyGenerator keyGenerator = new KeyGenerator();
                Digest digest = new Digest();
                String agt_r = keyGenerator.randomGenerateToHex(16);
                ECCKey eccKey = keyGenerator.eccKeyGenerate();
                if (eccKey != null) {
                    HashMap<String, String> paramMap = new HashMap<String, String>();
                    paramMap.put("agt_id", agt_id);
                    paramMap.put("agt_r", agt_r);
                    paramMap.put("agt_pu", eccKey.getPublicKey());
                    paramMap.put("agt_s", digest.genHmacToHex(agt_r, bSecky));
                    String server_url = String.valueOf(agentBean.getServer_api_url()) + "/key/change";
                    String server_param = JsonUtil.toString(paramMap);
                    LOGGER.debug("[KeyExchange] server_url : " + server_url);
                    LOGGER.debug("[KeyExchange] server_param : " + server_param);
                    ConnectUtil connectUtil = new ConnectUtil();
                    String responseData = connectUtil.connect(server_url, server_param);
                    LOGGER.debug("[KeyExchange] responseData : " + responseData);
                    if (responseData != null && !"".equals(responseData)) {
                        HashMap<String, Object> responseMap = JsonUtil.parse(responseData);
                        if (responseMap != null && !responseMap.isEmpty()) {
                            String code = StrUtil.NVL(responseMap.get("code"));
                            String ser_r = StrUtil.NVL(responseMap.get("ser_r"));
                            String ser_s = StrUtil.NVL(responseMap.get("ser_s"));
                            String ser_pu = StrUtil.NVL(responseMap.get("ser_pu"));
                            String com_ky = StrUtil.NVL(responseMap.get("com_ky"));
                            if ("SS0001".equals(code)) {
                                RSA rsa = new RSA();
                                byte[] bVerifyData = StrUtil.convertByteArray(String.valueOf(agt_r) + ser_r, agent_encoding);
                                boolean bRet = rsa.SSA_Verify(bVerifyData, server_pubkey, ser_s);
                                if (bRet) {
                                    byte[] bCalculateKey = keyGenerator.calculateKeyGenerate(eccKey.getPrivateKey(), ser_pu);
                                    byte[] bSaltKey = keyGenerator.randomGenerate(32);
                                    SecretKey calculateKey = new SecretKey(bCalculateKey, bSaltKey);
                                    this.setCalculateKey(calculateKey, com_ky, bSaltKey);
                                } else {
                                    this.errorCode = "EA0009";
                                }
                            } else {
                                this.errorCode = code;
                            }
                        } else {
                            this.errorCode = "EA0006";
                        }
                    } else {
                        this.errorCode = connectUtil.getErrorCode();
                    }
                } else {
                    this.errorCode = "EA0011";
                }
            } else {
                this.errorCode = "EA0010";
            }
        } else {
            this.errorCode = "EA0001";
        }
        String code = "".equals(this.errorCode) ? "SS0001" : this.errorCode;
        ApiLogService apiLogService = new ApiLogService();
        apiLogService.keyExchangeLog(code);
    }

    private void setCalculateKey(SecretKey calculateKey, String com_ky, byte[] bSaltKey) {
        KeyStorage keyStorage = KeyStorage.getInstance();
        if ("".equals(com_ky)) {
            keyStorage.addKey("com.ubintis.sso.agt.cs.key.CalculateKey", calculateKey);
            this.flag = true;
        } else {
            CipherBlock cipherBlock = new CipherBlock();
            byte[] bKey = cipherBlock.decrypt(com_ky, calculateKey);
            if (bKey != null && bKey.length > 0) {
                keyStorage.addKey("com.ubintis.sso.agt.cs.key.CalculateKey", new SecretKey(bKey, bSaltKey));
                this.flag = true;
            } else {
                this.errorCode = "EA0008";
            }
        }
    }
}

