/*
 * Decompiled with CFR 0.152.
 */
package com.ubintis.agt5.module.cs.key;

import com.ubintis.agt5.common.exception.AgentException;
import com.ubintis.agt5.framework.log.PniLogger;
import com.ubintis.agt5.module.cs.key.type.SecretKey;
import java.util.HashMap;

public class KeyStorage {
    private static final PniLogger LOGGER = PniLogger.getLogger();
    private HashMap<String, Object> keyMap = null;

    private KeyStorage() {
        this.init();
    }

    public static KeyStorage getInstance() {
        return Singleton.instance;
    }

    private void init() {
        if (this.keyMap != null) {
            this.keyMap.clear();
            this.keyMap = null;
        }
        this.keyMap = new HashMap();
    }

    public Object getKey(String keyName) {
        Object key = null;
        if (keyName != null && !"".equals(keyName)) {
            if (this.keyMap.containsKey(keyName)) {
                key = this.keyMap.get(keyName);
            } else {
                LOGGER.debug("KeyMap contains not found : " + keyName);
            }
        } else {
            throw new AgentException("Parameter value is null");
        }
        return key;
    }

    public boolean addKey(String keyName, Object key) {
        boolean rtnFalg = false;
        if (keyName != null && !"".equals(keyName) && key != null) {
            if (this.keyMap.containsKey(keyName)) {
                this.keyMap.remove(keyName);
            }
        } else {
            throw new AgentException("Parameter value is null");
        }
        this.keyMap.put(keyName, key);
        rtnFalg = true;
        return rtnFalg;
    }

    public boolean delKey(String keyName) {
        boolean rtnFalg = false;
        if (keyName != null && !"".equals(keyName)) {
            if (this.keyMap.containsKey(keyName)) {
                this.keyMap.remove(keyName);
                rtnFalg = true;
            }
        } else {
            throw new AgentException("Parameter value is null");
        }
        return rtnFalg;
    }

    public void destroy() throws Exception {
        if (this.keyMap != null) {
            SecretKey calculateKey;
            SecretKey masterKey = (SecretKey)this.getKey("com.ubintis.sso.agt.cs.key.MasterKey");
            if (masterKey != null) {
                masterKey.zeroize();
                masterKey = null;
                this.keyMap.put("com.ubintis.sso.agt.cs.key.MasterKey", null);
            }
            if ((calculateKey = (SecretKey)this.getKey("com.ubintis.sso.agt.cs.key.CalculateKey")) != null) {
                calculateKey.zeroize();
                calculateKey = null;
                this.keyMap.put("com.ubintis.sso.agt.cs.key.CalculateKey", null);
            }
            this.keyMap.clear();
            this.keyMap = null;
        }
    }

    /* synthetic */ KeyStorage(KeyStorage keyStorage) {
        this();
    }

    private static class Singleton {
        private static final KeyStorage instance = new KeyStorage(null);

        private Singleton() {
        }
    }
}

