/*
 * Decompiled with CFR 0.152.
 */
package com.ubintis.agt5.module.cs;

import com.ubintis.agt5.common.exception.AgentException;
import com.ubintis.agt5.common.util.StrUtil;
import com.ubintis.agt5.framework.bean.AgentBean;
import com.ubintis.agt5.framework.config.AgentConfig;
import com.ubintis.agt5.module.cs.key.KeyStorage;
import com.ubintis.agt5.module.cs.key.type.SecretKey;
import com.ubintis.crypto.jni.PniccJNI;

public class CipherBlock {
    private static final String CBC_MODE = "CBC";
    private static final String CCM_MODE = "CCM";
    private static final int CCM_MODE_LEN = 4;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String encrypt(String plainText) {
        String cipherText = "";
        if (plainText == null) throw new AgentException("Parameter value is null");
        if ("".equals(plainText)) throw new AgentException("Parameter value is null");
        AgentBean agentBean = AgentConfig.getInstance().getAgentBean();
        if (agentBean == null) throw new AgentException("Agent Property load error");
        String encoding = agentBean.getEncoding();
        KeyStorage keyStorage = KeyStorage.getInstance();
        SecretKey masterKey = (SecretKey)keyStorage.getKey("com.ubintis.sso.agt.cs.key.MasterKey");
        if (masterKey == null) throw new AgentException("Master Key load error");
        byte[] bPlain = StrUtil.convertByteArray(plainText, encoding);
        if (bPlain == null) throw new AgentException("String to byte[] convert error : " + encoding);
        if (bPlain.length <= 0) throw new AgentException("String to byte[] convert error : " + encoding);
        return this.encrypt(bPlain, true, masterKey);
    }

    public String encrypt(byte[] bPlain) {
        SecretKey masterKey;
        String cipherText = "";
        if (bPlain != null && bPlain.length > 0) {
            KeyStorage keyStorage = KeyStorage.getInstance();
            masterKey = (SecretKey)keyStorage.getKey("com.ubintis.sso.agt.cs.key.MasterKey");
            if (masterKey == null) {
                throw new AgentException("Master Key load error");
            }
        } else {
            throw new AgentException("Parameter value is null");
        }
        cipherText = this.encrypt(bPlain, true, masterKey);
        return cipherText;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String decrypt(String cipherText) {
        String plainText = "";
        if (cipherText == null) throw new AgentException("Parameter value is null");
        if ("".equals(cipherText)) throw new AgentException("Parameter value is null");
        AgentBean agentBean = AgentConfig.getInstance().getAgentBean();
        if (agentBean == null) throw new AgentException("Agent Property load error");
        String encoding = agentBean.getEncoding();
        KeyStorage keyStorage = KeyStorage.getInstance();
        SecretKey masterKey = (SecretKey)keyStorage.getKey("com.ubintis.sso.agt.cs.key.MasterKey");
        if (masterKey == null) throw new AgentException("Master Key load error");
        byte[] bPlain = this.decrypt(cipherText, true, masterKey);
        if (bPlain == null) return plainText;
        if (bPlain.length <= 0) return plainText;
        return StrUtil.convertString(bPlain, encoding);
    }

    public byte[] decrypt(String cipherText, int i) {
        SecretKey masterKey;
        byte[] bPlain = null;
        if (cipherText != null && !"".equals(cipherText)) {
            KeyStorage keyStorage = KeyStorage.getInstance();
            masterKey = (SecretKey)keyStorage.getKey("com.ubintis.sso.agt.cs.key.MasterKey");
            if (masterKey == null) {
                throw new AgentException("Master Key load error");
            }
        } else {
            throw new AgentException("Parameter value is null");
        }
        bPlain = this.decrypt(cipherText, true, masterKey);
        return bPlain;
    }

    public String encrypt(String plainText, String encoding, SecretKey secretKey) {
        byte[] bPlain;
        String cipherText = "";
        if (plainText != null && !"".equals(plainText) && encoding != null && !"".equals(encoding) && secretKey != null) {
            bPlain = StrUtil.convertByteArray(plainText, encoding);
            if (bPlain == null || bPlain.length <= 0) {
                throw new AgentException("String to byte[] convert error : " + encoding);
            }
        } else {
            throw new AgentException("Parameter value is null");
        }
        cipherText = this.encrypt(bPlain, false, secretKey);
        return cipherText;
    }

    public String encrypt(byte[] bPlain, SecretKey secretKey) {
        String cipherText = "";
        if (bPlain == null || bPlain.length <= 0 || secretKey == null) {
            throw new AgentException("Parameter value is null");
        }
        cipherText = this.encrypt(bPlain, false, secretKey);
        return cipherText;
    }

    public String decrypt(String cipherText, String encoding, SecretKey secretKey) {
        String plainText = "";
        if (cipherText != null && !"".equals(cipherText) && encoding != null && !"".equals(encoding) && secretKey != null) {
            byte[] bPlain = this.decrypt(cipherText, false, secretKey);
            if (bPlain != null && bPlain.length > 0 && ((plainText = StrUtil.convertString(bPlain, encoding)) == null || "".equals(plainText))) {
                throw new AgentException("String to byte[] convert error : " + encoding);
            }
        } else {
            throw new AgentException("Parameter value is null");
        }
        return plainText;
    }

    public byte[] decrypt(String cipherText, SecretKey secretKey) {
        byte[] bPlain = null;
        if (cipherText == null || "".equals(cipherText) || secretKey == null) {
            throw new AgentException("Parameter value is null");
        }
        bPlain = this.decrypt(cipherText, false, secretKey);
        return bPlain;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String encrypt(byte[] bPlain, boolean sameEncryptFlag, SecretKey secretKey) {
        String rtnData = "";
        AgentBean agentBean = AgentConfig.getInstance().getAgentBean();
        if (agentBean == null) throw new AgentException("Agent Property load error");
        byte algorithm = agentBean.getAlgorithm();
        String algorithm_mode = agentBean.getAlgorithm_mode();
        PniccJNI pniccJni = new PniccJNI();
        if (CBC_MODE.equals(algorithm_mode)) {
            rtnData = sameEncryptFlag ? pniccJni.BCipher_Encrypt(algorithm, bPlain, secretKey.getKey(), secretKey.getIv()) : pniccJni.BCipher_Encrypt2(algorithm, bPlain, secretKey.getKey(), secretKey.getIv());
            if (rtnData != null && !"".equals(rtnData)) return rtnData;
            throw new AgentException("Encrypt Data value is null : Algorithm[" + algorithm + "], CBC Mode");
        }
        if (!CCM_MODE.equals(algorithm_mode)) throw new AgentException("Encrypt Algorithm Mode [" + algorithm_mode + "] Incorrect");
        rtnData = sameEncryptFlag ? pniccJni.BCipher_Encrypt_ccm(algorithm, (byte)0, bPlain, secretKey.getKey(), secretKey.getIv(), secretKey.getMacKey(), 4) : pniccJni.BCipher_Encrypt_ccm(algorithm, (byte)1, bPlain, secretKey.getKey(), secretKey.getIv(), secretKey.getMacKey(), 4);
        if (rtnData != null && !"".equals(rtnData)) return rtnData;
        throw new AgentException("Encrypt Data value is null : Algorithm[" + algorithm + "], CCM Mode");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] decrypt(String cipherText, boolean sameEncryptFlag, SecretKey secretKey) {
        byte[] bPlain = null;
        AgentBean agentBean = AgentConfig.getInstance().getAgentBean();
        if (agentBean == null) throw new AgentException("Agent Property load error");
        byte algorithm = agentBean.getAlgorithm();
        String algorithm_mode = agentBean.getAlgorithm_mode();
        PniccJNI pniccJni = new PniccJNI();
        if (CBC_MODE.equals(algorithm_mode)) {
            bPlain = sameEncryptFlag ? pniccJni.BCipher_Decrypt(algorithm, cipherText, secretKey.getKey(), secretKey.getIv()) : pniccJni.BCipher_Decrypt2(algorithm, cipherText, secretKey.getKey(), secretKey.getIv());
            if (bPlain != null && bPlain.length >= 1) return bPlain;
            throw new AgentException("Decrypt Data value is null : Algorithm[" + algorithm + "], CBC Mode");
        }
        if (!CCM_MODE.equals(algorithm_mode)) throw new AgentException("Decrypt Algorithm Mode [" + algorithm_mode + "] Incorrect");
        bPlain = sameEncryptFlag ? pniccJni.BCipher_Decrypt_ccm(algorithm, (byte)0, cipherText, secretKey.getKey(), secretKey.getIv(), secretKey.getMacKey(), 4) : pniccJni.BCipher_Decrypt_ccm(algorithm, (byte)1, cipherText, secretKey.getKey(), secretKey.getIv(), secretKey.getMacKey(), 4);
        if (bPlain != null && bPlain.length >= 1) return bPlain;
        throw new AgentException("Decrypt Data value is null : Algorithm[" + algorithm + "], CCM Mode");
    }
}

