/*
 * Decompiled with CFR 0.152.
 */
package com.ubintis.agt5.module;

import com.ubintis.agt5.common.exception.AgentException;
import com.ubintis.agt5.common.util.Base64;
import com.ubintis.agt5.common.util.ConnectUtil;
import com.ubintis.agt5.common.util.JsonUtil;
import com.ubintis.agt5.common.util.StrUtil;
import com.ubintis.agt5.framework.bean.AgentBean;
import com.ubintis.agt5.framework.config.AgentConfig;
import com.ubintis.agt5.framework.log.PniLogger;
import com.ubintis.agt5.module.cs.CipherBlock;
import com.ubintis.agt5.module.cs.Digest;
import com.ubintis.agt5.module.cs.key.type.SecretKey;
import com.ubintis.agt5.module.key.KeyManager;
import java.util.HashMap;

public class RequestServer {
    private static final PniLogger LOGGER = PniLogger.getLogger();
    private String responseData;

    public String getResponseData() {
        return this.responseData;
    }

    public String execute(String serverUrl, HashMap<String, String> reqDataMap) {
        String errorCode;
        block18: {
            errorCode = "";
            if (serverUrl != null && !"".equals(serverUrl) && reqDataMap != null && !reqDataMap.isEmpty()) {
                AgentBean agentBean = AgentConfig.getInstance().getAgentBean();
                if (agentBean != null) {
                    KeyManager keyManager = new KeyManager();
                    SecretKey calculateKey = keyManager.getCalculateKey();
                    if (calculateKey != null) {
                        String reqData = JsonUtil.toString(reqDataMap);
                        String agt_id = agentBean.getAgent_id();
                        String encoding = StrUtil.NVL(agentBean.getEncoding(), "UTF-8");
                        CipherBlock cipherBlock = new CipherBlock();
                        Digest digest = new Digest();
                        HashMap<String, String> paramMap = new HashMap<String, String>();
                        paramMap.put("agt_id", agt_id);
                        paramMap.put("data", cipherBlock.encrypt(reqData, encoding, calculateKey));
                        paramMap.put("sign", digest.genHmacToHex(reqData, calculateKey));
                        String server_url = String.valueOf(agentBean.getServer_api_url()) + serverUrl;
                        String server_param = JsonUtil.toString(paramMap);
                        LOGGER.debug("[RequestServer] server_url : " + server_url);
                        LOGGER.debug("[RequestServer] server_param : " + server_param);
                        ConnectUtil connectUtil = new ConnectUtil();
                        String responseData = connectUtil.connect(server_url, server_param);
                        if (responseData != null && !"".equals(responseData)) {
                            LOGGER.debug("[RequestServer] responseData : " + responseData);
                            HashMap<String, Object> responseMap = JsonUtil.parse(responseData);
                            if (responseMap != null && !responseMap.isEmpty()) {
                                String code = StrUtil.NVL(responseMap.get("code"));
                                String serData = StrUtil.NVL(responseMap.get("data"));
                                String serSign = StrUtil.NVL(responseMap.get("sign"));
                                if ("SS0001".equals(code)) {
                                    if (!"".equals(serData) && !"".equals(serSign)) {
                                        try {
                                            String resData = cipherBlock.decrypt(serData, encoding, calculateKey);
                                            if (digest.verifyHmac(resData, serSign, calculateKey)) {
                                                this.responseData = resData;
                                                break block18;
                                            }
                                            errorCode = "EA0009";
                                        }
                                        catch (AgentException e) {
                                            errorCode = "EA0008";
                                        }
                                    } else {
                                        errorCode = "EA0007";
                                    }
                                } else {
                                    errorCode = code;
                                }
                            } else {
                                errorCode = "EA0006";
                            }
                        } else {
                            errorCode = connectUtil.getErrorCode();
                        }
                    } else {
                        errorCode = "EA0005";
                    }
                } else {
                    errorCode = "EA0001";
                }
            } else {
                errorCode = "EA0002";
            }
        }
        if (!"".equals(errorCode)) {
            LOGGER.debug("[RequestServer] errorCode : " + errorCode);
        }
        return errorCode;
    }

    public String executeLog(String serverUrl, HashMap<String, String> reqDataMap) {
        String errorCode = "";
        if (serverUrl != null && !"".equals(serverUrl) && reqDataMap != null && !reqDataMap.isEmpty()) {
            AgentBean agentBean = AgentConfig.getInstance().getAgentBean();
            if (agentBean != null) {
                String reqData = JsonUtil.toString(reqDataMap);
                String agt_id = agentBean.getAgent_id();
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("agt_id", agt_id);
                paramMap.put("data", Base64.encode(reqData));
                String server_url = String.valueOf(agentBean.getServer_api_url()) + serverUrl;
                String server_param = JsonUtil.toString(paramMap);
                LOGGER.debug("[RequestServer] server_url : " + server_url);
                LOGGER.debug("[RequestServer] server_param : " + server_param);
                ConnectUtil connectUtil = new ConnectUtil();
                String responseData = connectUtil.connect(server_url, server_param);
                if (responseData != null && !"".equals(responseData)) {
                    LOGGER.debug("[RequestServer] responseData : " + responseData);
                    HashMap<String, Object> responseMap = JsonUtil.parse(responseData);
                    if (responseMap != null && !responseMap.isEmpty()) {
                        String code = StrUtil.NVL(responseMap.get("code"));
                        if (!"SS0001".equals(code)) {
                            errorCode = code;
                        }
                    } else {
                        errorCode = "EA0006";
                    }
                } else {
                    errorCode = connectUtil.getErrorCode();
                }
            } else {
                errorCode = "EA0001";
            }
        } else {
            errorCode = "EA0002";
        }
        if (!"".equals(errorCode)) {
            LOGGER.debug("[RequestServer] errorCode : " + errorCode);
        }
        return errorCode;
    }
}

