/*
 * Decompiled with CFR 0.152.
 */
package com.ubintis.agt5.framework.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class PniLoggerFormatter
extends Formatter {
    private static final String lineSeparator = System.getProperty("line.separator");

    @Override
    public String format(LogRecord record) {
        StringBuffer sb = new StringBuffer();
        sb.append("[" + this.calcDate(record.getMillis()) + "]");
        sb.append(" ");
        sb.append(record.getLevel());
        sb.append(" - ");
        sb.append(this.formatMessage(record));
        sb.append(lineSeparator);
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    private String calcDate(long millisecs) {
        SimpleDateFormat date_format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.KOREA);
        Date resultdate = new Date(millisecs);
        return date_format.format(resultdate);
    }
}

