/*
 * Decompiled with CFR 0.152.
 */
package com.ubintis.agt5.framework.log;

import com.ubintis.agt5.common.util.DateUtil;
import com.ubintis.agt5.framework.bean.AgentBean;
import com.ubintis.agt5.framework.config.AgentConfig;
import com.ubintis.agt5.framework.log.PniLoggerFormatter;
import java.io.File;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PniLogger {
    private static final Logger LOGGER = Logger.getLogger("com.ubintis.agent5");
    private boolean flag = false;

    private PniLogger() {
        this.init();
    }

    public static PniLogger getLogger() {
        return Singleton.instance;
    }

    private void init() {
        this.flag = false;
        AgentBean agentBean = AgentConfig.getInstance().getAgentBean();
        if (agentBean != null) {
            try {
                String logger_level = agentBean.getLogger_level();
                if ("info".equalsIgnoreCase(logger_level)) {
                    LOGGER.setLevel(Level.INFO);
                } else if ("debug".equalsIgnoreCase(logger_level)) {
                    LOGGER.setLevel(Level.FINE);
                } else {
                    LOGGER.setLevel(Level.ALL);
                }
                String path = agentBean.getLogger_file_path();
                String name = String.valueOf(agentBean.getLogger_file_name()) + "%u_" + DateUtil.getShortDateString();
                if (path != null && !"".equals(path)) {
                    File directory = new File(path);
                    if (!directory.exists()) {
                        directory.mkdir();
                    }
                    FileHandler fileHandler = new FileHandler(String.valueOf(path) + File.separator + name + ".log", true);
                    fileHandler.setFormatter(new PniLoggerFormatter());
                    LOGGER.addHandler(fileHandler);
                }
                this.flag = true;
            }
            catch (SecurityException e) {
                System.out.println("[PniLogger] " + e.getMessage());
            }
            catch (IOException e) {
                System.out.println("[PniLogger] " + e.getMessage());
            }
        }
    }

    public boolean getStatus() {
        return this.flag;
    }

    public void info(String msg) {
        LOGGER.info(msg);
    }

    public void debug(String msg) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(msg);
        }
    }

    public void error(String msg) {
        LOGGER.severe(msg);
    }

    /* synthetic */ PniLogger(PniLogger pniLogger) {
        this();
    }

    private static class Singleton {
        private static final PniLogger instance = new PniLogger(null);

        private Singleton() {
        }
    }
}

