/*
 * Decompiled with CFR 0.152.
 */
package com.ubintis.agt5.framework.config;

import com.ubintis.agt5.common.util.StrUtil;
import com.ubintis.agt5.framework.bean.IntgrtyBean;
import java.io.IOException;
import java.io.InputStream;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;

public class IntgrtyConfig {
    private IntgrtyBean intgrtyBean = null;
    private boolean flag = false;

    private IntgrtyConfig() {
        this.init();
    }

    public static IntgrtyConfig getInstance() {
        return Singleton.instance;
    }

    private void init() {
        this.flag = false;
        if (this.intgrtyBean != null) {
            this.intgrtyBean = null;
        }
        this.intgrtyBean = new IntgrtyBean();
        InputStream inputStream = null;
        try {
            String configName = "spconfig/intgrty5-config.xml";
            inputStream = this.getClass().getClassLoader().getResourceAsStream(configName);
            if (inputStream != null) {
                Properties properties = new Properties();
                properties.loadFromXML(inputStream);
                String pni_config = StrUtil.NVL(properties.getProperty("pni.config"));
                String pni_jar = StrUtil.NVL(properties.getProperty("pni.jar"));
                this.intgrtyBean.setPni_config(pni_config);
                this.intgrtyBean.setPni_jar(pni_jar);
                this.flag = true;
            }
        }
        catch (InvalidPropertiesFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public IntgrtyBean getIntgrtyBean() {
        return this.intgrtyBean;
    }

    public boolean getStatus() {
        return this.flag;
    }

    public void destroy() throws Exception {
        if (this.intgrtyBean != null) {
            this.intgrtyBean = null;
        }
    }

    /* synthetic */ IntgrtyConfig(IntgrtyConfig intgrtyConfig) {
        this();
    }

    private static class Singleton {
        private static final IntgrtyConfig instance = new IntgrtyConfig(null);

        private Singleton() {
        }
    }
}

