/*
 * Decompiled with CFR 0.152.
 */
package com.ubintis.agt5.framework.config;

import com.ubintis.agt5.common.util.StrUtil;
import com.ubintis.agt5.framework.bean.AgentBean;
import java.io.IOException;
import java.io.InputStream;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;

public class AgentConfig {
    public static final String PNI_VERSION = "token";
    private AgentBean agentBean = null;
    private boolean flag = false;

    private AgentConfig() {
        this.init();
    }

    public static AgentConfig getInstance() {
        return Singleton.instance;
    }

    private void init() {
        block30: {
            this.flag = false;
            if (this.agentBean != null) {
                this.agentBean = null;
            }
            this.agentBean = new AgentBean();
            InputStream inputStream = null;
            try {
                String configName = "spconfig/pni5-config.xml";
                inputStream = this.getClass().getClassLoader().getResourceAsStream(configName);
                if (inputStream != null) {
                    Properties properties = new Properties();
                    properties.loadFromXML(inputStream);
                    String product = StrUtil.NVL(properties.getProperty("product"));
                    String application = StrUtil.NVL(properties.getProperty("application"));
                    this.agentBean.setProduct(product);
                    this.agentBean.setApplication(application);
                    String server_id = StrUtil.NVL(properties.getProperty("server.id"));
                    String server_app_url = StrUtil.NVL(properties.getProperty("server.app.url"));
                    String server_api_url = StrUtil.NVL(properties.getProperty("server.api.url"));
                    String server_public_key = StrUtil.NVL(properties.getProperty("server.public.key"));
                    this.agentBean.setServer_id(server_id);
                    this.agentBean.setServer_app_url(server_app_url);
                    this.agentBean.setServer_api_url(server_api_url);
                    this.agentBean.setServer_public_key(server_public_key);
                    String agent_id = StrUtil.NVL(properties.getProperty("agent.id"));
                    String agent_version = StrUtil.NVL(properties.getProperty("agent.version"));
                    String agent_domain = StrUtil.NVL(properties.getProperty("agent.domain"));
                    String agent_secky = StrUtil.NVL(properties.getProperty("agent.secky"));
                    String agent_pni_key = StrUtil.NVL(properties.getProperty("agent.pni.key"));
                    String agent_pni_type = StrUtil.NVL(properties.getProperty("agent.pni.type"), "7");
                    String agent_pni_version = StrUtil.NVL(properties.getProperty("agent.pni.version"), PNI_VERSION);
                    String agent_root_path = StrUtil.NVL(properties.getProperty("agent.root.path"));
                    this.agentBean.setAgent_id(agent_id);
                    this.agentBean.setAgent_version(agent_version);
                    this.agentBean.setAgent_domain(agent_domain);
                    this.agentBean.setAgent_secky(agent_secky);
                    this.agentBean.setAgent_pni_key(agent_pni_key);
                    this.agentBean.setAgent_pni_type(agent_pni_type);
                    this.agentBean.setAgent_pni_version(agent_pni_version);
                    this.agentBean.setAgent_root_path(agent_root_path);
                    String crypto_algorithm = StrUtil.NVL(properties.getProperty("crypto.algorithm"), "ARIA256");
                    String crypto_algorithm_mode = StrUtil.NVL(properties.getProperty("crypto.algorithm.mode"), "CBC");
                    String crypto_digest = StrUtil.NVL(properties.getProperty("crypto.digest"), "SHA256");
                    String crypto_rsasize = StrUtil.NVL(properties.getProperty("crypto.rsasize"), "2048");
                    String crypto_ec_type = StrUtil.NVL(properties.getProperty("crypto.ec.type"), "P256");
                    String crypto_encoding = StrUtil.NVL(properties.getProperty("crypto.encoding"), "UTF-8");
                    byte algorithm = -1;
                    if ("ARIA128".equals(crypto_algorithm)) {
                        algorithm = 1;
                    } else if ("ARIA192".equals(crypto_algorithm)) {
                        algorithm = 2;
                    } else if ("ARIA256".equals(crypto_algorithm)) {
                        algorithm = 3;
                    } else if ("SEED".equals(crypto_algorithm)) {
                        algorithm = 4;
                    } else if ("LEA128".equals(crypto_algorithm)) {
                        algorithm = 5;
                    } else if ("LEA192".equals(crypto_algorithm)) {
                        algorithm = 6;
                    } else if ("LEA256".equals(crypto_algorithm)) {
                        algorithm = 7;
                    }
                    byte digest = -1;
                    if ("SHA224".equals(crypto_digest)) {
                        digest = 3;
                    } else if ("SHA256".equals(crypto_digest)) {
                        digest = 4;
                    } else if ("SHA384".equals(crypto_digest)) {
                        digest = 5;
                    } else if ("SHA512".equals(crypto_digest)) {
                        digest = 6;
                    }
                    int rsasize = 2048;
                    try {
                        rsasize = Integer.parseInt(crypto_rsasize);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("[AgentConfig] " + e.getMessage());
                    }
                    int ec_type = -1;
                    if ("P224".equals(crypto_ec_type)) {
                        ec_type = 1;
                    } else if ("P256".equals(crypto_ec_type)) {
                        ec_type = 2;
                    }
                    this.agentBean.setAlgorithm(algorithm);
                    this.agentBean.setAlgorithm_mode(crypto_algorithm_mode);
                    this.agentBean.setDigest(digest);
                    this.agentBean.setRsasize(rsasize);
                    this.agentBean.setEc_type(ec_type);
                    this.agentBean.setEncoding(crypto_encoding);
                    String logger_file_path = StrUtil.NVL(properties.getProperty("logger.file.path"));
                    String logger_file_name = StrUtil.NVL(properties.getProperty("logger.file.name"));
                    String logger_level = StrUtil.NVL(properties.getProperty("logger.level"));
                    this.agentBean.setLogger_file_path(logger_file_path);
                    this.agentBean.setLogger_file_name(logger_file_name);
                    this.agentBean.setLogger_level(logger_level);
                    this.flag = true;
                    break block30;
                }
                this.agentBean = null;
            }
            catch (InvalidPropertiesFormatException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public AgentBean getAgentBean() {
        return this.agentBean;
    }

    public boolean getStatus() {
        return this.flag;
    }

    public void destroy() throws Exception {
        if (this.agentBean != null) {
            this.agentBean = null;
        }
    }

    /* synthetic */ AgentConfig(AgentConfig agentConfig) {
        this();
    }

    private static class Singleton {
        private static final AgentConfig instance = new AgentConfig(null);

        private Singleton() {
        }
    }
}

