/*
 * Decompiled with CFR 0.152.
 */
package com.ubintis.agt5.common.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class ConnectUtil {
    private String errorCode = "";

    public String getErrorCode() {
        return this.errorCode;
    }

    public String connect(String reqUrl, String jsonParam) {
        String responseData = "";
        this.errorCode = "";
        if (reqUrl != null && !"".equals(reqUrl)) {
            responseData = reqUrl.toLowerCase().startsWith("https://") ? this.httpsConnect(reqUrl, jsonParam) : this.httpConnect(reqUrl, jsonParam);
        } else {
            this.errorCode = "EA0002";
        }
        return responseData;
    }

    private String httpConnect(String reqUrl, String jsonParam) {
        BufferedWriter bufferedWriter = null;
        BufferedReader bufferedReader = null;
        try {
            URL url = new URL(reqUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Accept", " application/json");
            connection.setRequestMethod("POST");
            connection.setConnectTimeout(3000);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setDefaultUseCaches(false);
            connection.setRequestProperty("Connection", "close");
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream()));
            bufferedWriter.write(jsonParam);
            bufferedWriter.flush();
            bufferedWriter.close();
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                bufferedReader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuffer data = new StringBuffer();
                String buffer = "";
                while ((buffer = bufferedReader.readLine()) != null) {
                    data.append(buffer);
                }
                bufferedReader.close();
                String string = data.toString();
                return string;
            }
            try {
                this.errorCode = "EA0003";
                connection.disconnect();
            }
            catch (Exception e) {
                this.errorCode = "EA0004";
                e.printStackTrace();
            }
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
                bufferedWriter = null;
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
                bufferedReader = null;
            }
        }
        return null;
    }

    private String httpsConnect(String reqUrl, String jsonParam) {
        BufferedWriter bufferedWriter = null;
        BufferedReader bufferedReader = null;
        try {
            TrustManager[] trustAllCertificates = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            HostnameVerifier trustAllHostnames = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCertificates, new SecureRandom());
            URL url = new URL(reqUrl);
            HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Accept", " application/json");
            connection.setRequestMethod("POST");
            connection.setConnectTimeout(3000);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setDefaultUseCaches(false);
            connection.setRequestProperty("Connection", "close");
            connection.setSSLSocketFactory(sc.getSocketFactory());
            connection.setHostnameVerifier(trustAllHostnames);
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream()));
            bufferedWriter.write(jsonParam);
            bufferedWriter.flush();
            bufferedWriter.close();
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                bufferedReader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuffer data = new StringBuffer();
                String buffer = "";
                while ((buffer = bufferedReader.readLine()) != null) {
                    data.append(buffer);
                }
                bufferedReader.close();
                String string = data.toString();
                return string;
            }
            try {
                this.errorCode = "EA0003";
                connection.disconnect();
            }
            catch (Exception e) {
                this.errorCode = "EA0004";
                e.printStackTrace();
            }
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
                bufferedWriter = null;
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
                bufferedReader = null;
            }
        }
        return null;
    }
}

